/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.profile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.profile.ProfileChooserContentProvider;
import org.eclipse.papyrus.uml.diagram.wizards.profile.ProfileChooserLabelProvider;
import org.eclipse.papyrus.uml.diagram.wizards.widget.ExtensionFilter;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.uml2.uml.Profile;

public class ProfileChooserComposite
extends Composite {
    public static final String PROFILE_SEPARATOR = "\n";
    private Text textField;
    private Button workspaceButton;
    private Button registeredButton;
    private LinkedList<ViewerFilter> filters;
    private ElementTreeSelectionDialog treeDialog;
    private boolean workspaceProfile;
    private String[] workspaceFilters = new String[]{"profile.uml"};
    private List<IFile> selectedFile = new ArrayList<IFile>();
    private List<Object> selectedProfile = new ArrayList<Object>();

    public ProfileChooserComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, true));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createProfileChooser(this);
    }

    private void createProfileChooser(Composite parent) {
        this.filters = new LinkedList();
        this.setFilterExtensions(this.workspaceFilters);
        this.textField = new Text(parent, 2562);
        GridData fieldGrid = new GridData(4, 4, true, false);
        fieldGrid.verticalSpan = 10;
        fieldGrid.horizontalSpan = 2;
        this.textField.setLayoutData((Object)fieldGrid);
        this.treeDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new ProfileChooserLabelProvider(), (ITreeContentProvider)new ProfileChooserContentProvider());
        this.treeDialog.setInput((Object)RegisteredProfile.getRegisteredProfiles());
        this.treeDialog.setAllowMultiple(true);
        this.treeDialog.setTitle(Messages.ProfileChooserComposite_RegisteredProfilesDialog);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IFile[] ifile;
                ProfileChooserComposite.this.refreshListFromTextField();
                if (e.widget.equals(ProfileChooserComposite.this.workspaceButton) && (ifile = WorkspaceResourceDialog.openFileSelection((Shell)ProfileChooserComposite.this.getShell(), null, null, (boolean)true, (Object[])ProfileChooserComposite.this.selectedFile.toArray(), (List)ProfileChooserComposite.this.filters)).length > 0) {
                    ProfileChooserComposite.this.selectedFile = new ArrayList<IFile>(Arrays.asList(ifile));
                    ProfileChooserComposite.this.refreshTextField();
                }
                if (e.widget.equals(ProfileChooserComposite.this.registeredButton)) {
                    ProfileChooserComposite.this.treeDialog.setInitialSelections(ProfileChooserComposite.this.selectedProfile.toArray());
                    ProfileChooserComposite.this.treeDialog.open();
                    Object[] profiles = ProfileChooserComposite.this.treeDialog.getResult();
                    if (profiles != null) {
                        ProfileChooserComposite.this.selectedProfile = new ArrayList<Object>(Arrays.asList(profiles));
                        ProfileChooserComposite.this.refreshTextField();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.workspaceButton = new Button(parent, 0);
        this.workspaceButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.workspaceButton.addSelectionListener(selectionListener);
        this.workspaceButton.setText(Messages.ProfileChooserComposite_WorkspaceSelectionButton);
        this.registeredButton = new Button(parent, 0);
        this.registeredButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.registeredButton.addSelectionListener(selectionListener);
        this.registeredButton.setText(Messages.ProfileChooserComposite_RegisteredSelectionButton);
    }

    private void refreshListFromTextField() {
        if (this.textField.isDisposed()) {
            return;
        }
        List<String> stringList = Arrays.asList(this.textField.getText().split(PROFILE_SEPARATOR));
        Iterator<IFile> fileIterator = this.selectedFile.iterator();
        while (fileIterator.hasNext()) {
            IFile file = fileIterator.next();
            if (stringList.contains(file.getFullPath().toString().trim())) continue;
            fileIterator.remove();
        }
        Iterator<Object> profileIterator = this.selectedProfile.iterator();
        while (profileIterator.hasNext()) {
            String profilePath;
            Object profile = profileIterator.next();
            if (!(profile instanceof IRegisteredProfile) || stringList.contains(profilePath = this.registeredProfileToString((IRegisteredProfile)profile))) continue;
            profileIterator.remove();
        }
    }

    private void refreshTextField() {
        StringBuilder builder = new StringBuilder();
        for (Object profile : this.selectedProfile) {
            if (!(profile instanceof IRegisteredProfile)) continue;
            builder.append(this.registeredProfileToString((IRegisteredProfile)profile));
            builder.append(PROFILE_SEPARATOR);
        }
        for (IFile file : this.selectedFile) {
            builder.append(this.fileProfileToString(file));
            builder.append(PROFILE_SEPARATOR);
        }
        if (!builder.toString().isEmpty()) {
            builder.delete(builder.length() - 1, builder.length());
        }
        this.textField.setText(builder.toString());
    }

    public IStatus getProfileDefinitionStatus() {
        ResourceSet resourceSet = Util.createTemporaryResourceSet();
        try {
            List<String> profilePath = this.getProfilesURI();
            if (profilePath.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            for (String pp : profilePath) {
                URI profileURI = URI.createURI((String)pp);
                Resource resource = resourceSet.getResource(profileURI, true);
                if (resource == null) {
                    Status status = new Status(4, "org.eclipse.papyrus.uml.diagram.wizards", Messages.ProfileChooserComposite_ProfileStatus_NullResource);
                    return status;
                }
                if (resource.getContents().isEmpty()) {
                    Status status = new Status(4, "org.eclipse.papyrus.uml.diagram.wizards", Messages.ProfileChooserComposite_ProfileStatus_EmptyResource);
                    return status;
                }
                EObject eObject = (EObject)resource.getContents().get(0);
                if (!(eObject instanceof Profile)) {
                    Status status = new Status(4, "org.eclipse.papyrus.uml.diagram.wizards", Messages.ProfileChooserComposite_ProfileStatus_NotAProfile);
                    return status;
                }
                Profile profile = (Profile)eObject;
                if (profile.isDefined()) continue;
                Status status = new Status(4, "org.eclipse.papyrus.uml.diagram.wizards", Messages.ProfileChooserComposite_ProfileStatus_ProfileNotDefined);
                return status;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (WrappedException ex) {
            Status status = new Status(4, "org.eclipse.papyrus.uml.diagram.wizards", Messages.ProfileChooserComposite_ProfileStatus_UnavailableResource, (Throwable)ex);
            return status;
        }
        finally {
            EMFHelper.unload((ResourceSet)resourceSet);
        }
    }

    public String getProfileURI() {
        if (this.textField.isDisposed()) {
            return null;
        }
        String path = this.textField.getText();
        if (path.trim().equals("")) {
            return null;
        }
        if (this.workspaceProfile) {
            return path.trim();
        }
        return URI.createURI((String)path).toString();
    }

    public List<String> getProfilesURI() {
        ArrayList<String> result = new ArrayList<String>();
        List<Object> stringList = new ArrayList();
        if (this.textField.isDisposed()) {
            return result;
        }
        String path = this.textField.getText();
        if (path.trim().equals("")) {
            return result;
        }
        stringList = Arrays.asList(path.split(PROFILE_SEPARATOR));
        for (String string : stringList) {
            result.add(string.trim());
        }
        return result;
    }

    protected String fileProfileToString(IFile file) {
        return file.getFullPath().toString();
    }

    protected String registeredProfileToString(IRegisteredProfile registeredProfile) {
        return registeredProfile.getPath().toString();
    }

    public void setFilterExtensions(String[] extensions) {
        this.filters.clear();
        ExtensionFilter filter = new ExtensionFilter(extensions);
        this.filters.add(filter);
    }

    public Text getTextField() {
        return this.textField;
    }

    public void dispose() {
        super.dispose();
        this.selectedFile.clear();
        this.selectedProfile.clear();
    }
}

