/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.part;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramUpdater;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Package;

public class UMLDiagramContentInitializer {
    private Map myDomain2NotationMap = new HashMap();
    private Collection myLinkDescriptors = new LinkedList();

    public void initDiagramContent(Diagram diagram) {
        if (!"PapyrusUMLTimingDiagram".equals(diagram.getType())) {
            UMLDiagramEditorPlugin.getInstance().logError("Incorrect diagram passed as a parameter: " + diagram.getType());
            return;
        }
        if (!(diagram.getElement() instanceof Package)) {
            UMLDiagramEditorPlugin.getInstance().logError("Incorrect diagram element specified: " + diagram.getElement() + " instead of Package");
            return;
        }
        this.createPackage_TimingDiagram_Children((View)diagram);
        this.createLinks(diagram);
    }

    private void createPackage_TimingDiagram_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getPackage_TimingDiagram_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createInteraction_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getInteraction_Shape_OutgoingLinks(view));
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getInteraction_Shape_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
        this.createInteraction_SubfragmentCompartment_Children((View)this.getCompartment(view, "Interaction_SubfragmentCompartment"));
        this.createInteraction_TimeRulerCompartment_Children((View)this.getCompartment(view, "Interaction_TimeRulerCompartment"));
    }

    private void createLifeline_FullShape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getLifeline_FullShape_OutgoingLinks(view));
        this.createLifeline_FullStateDefinitionCompartment_Children((View)this.getCompartment(view, "Lifeline_FullStateDefinitionCompartment"));
        this.createLifeline_FullSubfragmentCompartment_Children((View)this.getCompartment(view, "Lifeline_FullSubfragmentCompartment"));
        this.createLifeline_FullTimeRulerCompartment_Children((View)this.getCompartment(view, "Lifeline_FullTimeRulerCompartment"));
    }

    private void createLifeline_CompactShape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getLifeline_CompactShape_OutgoingLinks(view));
        this.createLifeline_CompactSubfragmentCompartment_Children((View)this.getCompartment(view, "Lifeline_CompactSubfragmentCompartment"));
        this.createLifeline_CompactTimeRulerCompartment_Children((View)this.getCompartment(view, "Lifeline_CompactTimeRulerCompartment"));
    }

    private void createStateInvariant_FullShape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getStateInvariant_FullShape_OutgoingLinks(view));
    }

    private void createStateInvariant_CompactShape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getStateInvariant_CompactShape_OutgoingLinks(view));
    }

    private void createOccurrenceSpecification_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getOccurrenceSpecification_Shape_OutgoingLinks(view));
    }

    private void createMessageOccurrenceSpecification_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getMessageOccurrenceSpecification_Shape_OutgoingLinks(view));
    }

    private void createTimeConstraint_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getTimeConstraint_Shape_OutgoingLinks(view));
    }

    private void createTimeObservation_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getTimeObservation_Shape_OutgoingLinks(view));
    }

    private void createDurationConstraint_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getDurationConstraint_Shape_OutgoingLinks(view));
    }

    private void createDurationObservation_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getDurationObservation_Shape_OutgoingLinks(view));
    }

    private void createGeneralOrdering_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getGeneralOrdering_Shape_OutgoingLinks(view));
    }

    private void createDestructionOccurrenceSpecification_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getDestructionOccurrenceSpecification_Shape_OutgoingLinks(view));
    }

    private void createLifeline_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getLifeline_Shape_OutgoingLinks(view));
    }

    private void createGate_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getGate_Shape_OutgoingLinks(view));
    }

    private void createInteraction_SubfragmentCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getInteraction_SubfragmentCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifeline_FullStateDefinitionCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getLifeline_FullStateDefinitionCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifeline_FullSubfragmentCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getLifeline_FullSubfragmentCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifeline_CompactSubfragmentCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getLifeline_CompactSubfragmentCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createInteraction_TimeRulerCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getInteraction_TimeRulerCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifeline_FullTimeRulerCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getLifeline_FullTimeRulerCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createLifeline_CompactTimeRulerCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getLifeline_CompactTimeRulerCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createNode(View parentView, UMLNodeDescriptor nodeDescriptor) {
        String nodeType = UMLVisualIDRegistry.getType(nodeDescriptor.getVisualID());
        Node node = ViewService.createNode((View)parentView, (EObject)nodeDescriptor.getModelElement(), (String)nodeType, (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        switch (nodeDescriptor.getVisualID()) {
            case "Interaction_Shape": {
                this.createInteraction_Shape_Children((View)node);
                return;
            }
            case "Lifeline_FullShape": {
                this.createLifeline_FullShape_Children((View)node);
                return;
            }
            case "Lifeline_CompactShape": {
                this.createLifeline_CompactShape_Children((View)node);
                return;
            }
            case "StateInvariant_FullShape": {
                this.createStateInvariant_FullShape_Children((View)node);
                return;
            }
            case "StateInvariant_CompactShape": {
                this.createStateInvariant_CompactShape_Children((View)node);
                return;
            }
            case "OccurrenceSpecification_Shape": {
                this.createOccurrenceSpecification_Shape_Children((View)node);
                return;
            }
            case "MessageOccurrenceSpecification_Shape": {
                this.createMessageOccurrenceSpecification_Shape_Children((View)node);
                return;
            }
            case "TimeConstraint_Shape": {
                this.createTimeConstraint_Shape_Children((View)node);
                return;
            }
            case "TimeObservation_Shape": {
                this.createTimeObservation_Shape_Children((View)node);
                return;
            }
            case "DurationConstraint_Shape": {
                this.createDurationConstraint_Shape_Children((View)node);
                return;
            }
            case "DurationObservation_Shape": {
                this.createDurationObservation_Shape_Children((View)node);
                return;
            }
            case "GeneralOrdering_Shape": {
                this.createGeneralOrdering_Shape_Children((View)node);
                return;
            }
            case "DestructionOccurrenceSpecification_Shape": {
                this.createDestructionOccurrenceSpecification_Shape_Children((View)node);
                return;
            }
            case "Lifeline_Shape": {
                this.createLifeline_Shape_Children((View)node);
                return;
            }
            case "Gate_Shape": {
                this.createGate_Shape_Children((View)node);
                return;
            }
        }
    }

    private void createLinks(Diagram diagram) {
        boolean continueLinkCreation = true;
        while (continueLinkCreation) {
            continueLinkCreation = false;
            LinkedList<UMLLinkDescriptor> additionalDescriptors = new LinkedList<UMLLinkDescriptor>();
            Iterator it = this.myLinkDescriptors.iterator();
            while (it.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = (UMLLinkDescriptor)((Object)it.next());
                if (!this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getSource()) || !this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getDestination())) continue;
                String linkType = UMLVisualIDRegistry.getType(nextLinkDescriptor.getVisualID());
                Edge edge = ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), (View)diagram, linkType, -1, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (edge == null) continue;
                edge.setSource((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getSource()));
                edge.setTarget((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getDestination()));
                it.remove();
                if (nextLinkDescriptor.getModelElement() != null) {
                    this.myDomain2NotationMap.put(nextLinkDescriptor.getModelElement(), edge);
                }
                continueLinkCreation = true;
                switch (nextLinkDescriptor.getVisualID()) {
                    case "Message_SynchEdge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getMessage_SynchEdge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Message_AsynchEdge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getMessage_AsynchEdge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Message_ReplyEdge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getMessage_ReplyEdge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Message_CreateEdge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getMessage_CreateEdge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Message_DeleteEdge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getMessage_DeleteEdge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Message_LostEdge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getMessage_LostEdge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Message_FoundEdge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getMessage_FoundEdge_OutgoingLinks((View)edge));
                    }
                }
            }
            this.myLinkDescriptors.addAll(additionalDescriptors);
        }
    }

    private Node getCompartment(View node, String visualID) {
        String type = UMLVisualIDRegistry.getType(visualID);
        for (View nextView : node.getChildren()) {
            if (!(nextView instanceof Node) || !type.equals(nextView.getType())) continue;
            return (Node)nextView;
        }
        return null;
    }
}

