/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleStringEditor;
import org.eclipse.papyrus.infra.widgets.selectors.RealSelector;
import org.eclipse.swt.widgets.Composite;

public class MultipleDoubleEditor
extends MultipleStringEditor<RealSelector> {
    public MultipleDoubleEditor(Composite parent, int style) {
        super(parent, style, new RealSelector());
    }

    public MultipleDoubleEditor(Composite parent, int style, String label) {
        super(parent, style, new RealSelector(), label);
    }

    public MultipleDoubleEditor(Composite parent, int style, boolean ordered, boolean unique, String label) {
        super(parent, style, new RealSelector(), ordered, unique, label);
    }

    public MultipleDoubleEditor(Composite parent, boolean directCreation, boolean directCreationWithTreeViewer, int style) {
        super(parent, style, new RealSelector(), directCreation, directCreationWithTreeViewer);
    }

    @Override
    protected CellEditor createCellEditor(Object element) {
        return new DoubleCellEditor((Composite)this.tree);
    }

    @Override
    protected Object getDefaultValue() {
        return new Double(0.0);
    }

    private static class DoubleCellEditor
    extends TextCellEditor {
        public DoubleCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new ICellEditorValidator(){

                public String isValid(Object object) {
                    if (object instanceof Double) {
                        return null;
                    }
                    String string = (String)object;
                    try {
                        Double.parseDouble(string);
                        return null;
                    }
                    catch (NumberFormatException exception) {
                        return exception.getMessage();
                    }
                }
            });
        }

        public Object doGetValue() {
            return Double.parseDouble((String)super.doGetValue());
        }

        public void doSetValue(Object value) {
            super.doSetValue((Object)value.toString());
        }
    }
}

