/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescription;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionPreferences;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFactory;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFramework;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.Concern;
import org.eclipse.papyrus.infra.core.architecture.Stakeholder;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitectureDescriptionImpl;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitectureDescriptionLanguageImpl;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitectureDescriptionPreferencesImpl;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitectureDomainImpl;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitectureFrameworkImpl;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitectureViewpointImpl;
import org.eclipse.papyrus.infra.core.architecture.impl.ConcernImpl;
import org.eclipse.papyrus.infra.core.architecture.impl.StakeholderImpl;

public class ArchitectureFactoryImpl
extends EFactoryImpl
implements ArchitectureFactory {
    public static ArchitectureFactory init() {
        try {
            ArchitectureFactory theArchitectureFactory = (ArchitectureFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/infra/core/architecture");
            if (theArchitectureFactory != null) {
                return theArchitectureFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ArchitectureFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createArchitectureDomain();
            }
            case 2: {
                return this.createArchitectureDescriptionLanguage();
            }
            case 3: {
                return this.createStakeholder();
            }
            case 4: {
                return this.createConcern();
            }
            case 5: {
                return this.createArchitectureViewpoint();
            }
            case 8: {
                return this.createArchitectureFramework();
            }
            case 9: {
                return this.createArchitectureDescription();
            }
            case 10: {
                return this.createArchitectureDescriptionPreferences();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public ArchitectureDomain createArchitectureDomain() {
        ArchitectureDomainImpl architectureDomain = new ArchitectureDomainImpl();
        return architectureDomain;
    }

    @Override
    public ArchitectureDescriptionLanguage createArchitectureDescriptionLanguage() {
        ArchitectureDescriptionLanguageImpl architectureDescriptionLanguage = new ArchitectureDescriptionLanguageImpl();
        return architectureDescriptionLanguage;
    }

    @Override
    public Stakeholder createStakeholder() {
        StakeholderImpl stakeholder = new StakeholderImpl();
        return stakeholder;
    }

    @Override
    public Concern createConcern() {
        ConcernImpl concern = new ConcernImpl();
        return concern;
    }

    @Override
    public ArchitectureViewpoint createArchitectureViewpoint() {
        ArchitectureViewpointImpl architectureViewpoint = new ArchitectureViewpointImpl();
        return architectureViewpoint;
    }

    @Override
    public ArchitectureFramework createArchitectureFramework() {
        ArchitectureFrameworkImpl architectureFramework = new ArchitectureFrameworkImpl();
        return architectureFramework;
    }

    @Override
    public ArchitectureDescription createArchitectureDescription() {
        ArchitectureDescriptionImpl architectureDescription = new ArchitectureDescriptionImpl();
        return architectureDescription;
    }

    @Override
    public ArchitectureDescriptionPreferences createArchitectureDescriptionPreferences() {
        ArchitectureDescriptionPreferencesImpl architectureDescriptionPreferences = new ArchitectureDescriptionPreferencesImpl();
        return architectureDescriptionPreferences;
    }

    @Override
    public ArchitecturePackage getArchitecturePackage() {
        return (ArchitecturePackage)this.getEPackage();
    }

    @Deprecated
    public static ArchitecturePackage getPackage() {
        return ArchitecturePackage.eINSTANCE;
    }
}

