/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTupleExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.OclVoidTypeId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class CGUtil {
    public static @NonNull String compressJDTannotations(@NonNull String classFileContent) {
        String ORG_ECLIPSE_JDT_ANNOTATION = NonNull.class.getPackage().getName();
        String AT_ORG_ECLIPSE_JDT_ANNOTATION_DOT = "@" + ORG_ECLIPSE_JDT_ANNOTATION + ".";
        HashSet<@NonNull String> reservedNames = new HashSet<String>();
        reservedNames.add("Byte");
        reservedNames.add("Character");
        reservedNames.add("Class");
        reservedNames.add("Double");
        reservedNames.add("Enum");
        reservedNames.add("Error");
        reservedNames.add("Exception");
        reservedNames.add("Float");
        reservedNames.add("Integer");
        reservedNames.add("Long");
        reservedNames.add("Math");
        reservedNames.add("Object");
        reservedNames.add("Package");
        reservedNames.add("Process");
        reservedNames.add("Short");
        reservedNames.add("String");
        try {
            String line;
            HashSet<@NonNull String> longImports = new HashSet<String>();
            BufferedReader reader = new BufferedReader(new StringReader(classFileContent));
            StringBuilder s = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                int prefixEnd;
                String longImport;
                int lastIndex;
                int index;
                if (line.startsWith("import ") && (index = line.indexOf(";")) > 0 && (lastIndex = (longImport = line.substring(7, index).trim()).lastIndexOf(".")) > 0) {
                    String shortImport = longImport.substring(lastIndex + 1);
                    assert (shortImport != null);
                    if (!reservedNames.contains(shortImport)) {
                        longImports.add(longImport);
                    }
                }
                while ((prefixEnd = line.indexOf(AT_ORG_ECLIPSE_JDT_ANNOTATION_DOT)) >= 0) {
                    char c;
                    char c2;
                    char c3;
                    int prefixIndex = prefixEnd;
                    while (prefixIndex > 0) {
                        char c4 = line.charAt(prefixIndex - 1);
                        if (c4 != '.' && !Character.isJavaIdentifierPart(c4)) break;
                        --prefixIndex;
                    }
                    String prefixName = line.substring(prefixIndex, prefixEnd - 1);
                    int annotationStart = prefixEnd + AT_ORG_ECLIPSE_JDT_ANNOTATION_DOT.length();
                    int annotationEnd = annotationStart + 1;
                    while (Character.isJavaIdentifierPart(c3 = line.charAt(annotationEnd))) {
                        ++annotationEnd;
                    }
                    String annotationName = line.substring(annotationStart, annotationEnd);
                    if (!longImports.contains(String.valueOf(ORG_ECLIPSE_JDT_ANNOTATION) + "." + annotationName)) break;
                    int suffixStart = annotationEnd;
                    while (Character.isWhitespace(c2 = line.charAt(suffixStart))) {
                        ++suffixStart;
                    }
                    int suffixEnd = suffixStart;
                    while (Character.isJavaIdentifierPart(c = line.charAt(suffixEnd))) {
                        ++suffixEnd;
                    }
                    String suffixName = line.substring(suffixStart, suffixEnd);
                    String importName = String.valueOf(prefixName) + "." + suffixName;
                    if (longImports.contains(importName) || importName.startsWith("java.lang.")) {
                        line = String.valueOf(line.substring(0, prefixIndex)) + "@" + line.substring(annotationStart, line.length());
                        continue;
                    }
                    line = String.valueOf(line.substring(0, prefixEnd)) + "@" + line.substring(annotationStart, line.length());
                    break;
                }
                s.append(line);
                s.append("\n");
            }
            return s.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return classFileContent;
        }
    }

    public static @NonNull CGParameter createCGParameter(@NonNull String name, @NonNull CGTypeId typeId) {
        CGParameter cgParameter = CGModelFactory.eINSTANCE.createCGParameter();
        cgParameter.setName(name);
        cgParameter.setTypeId(typeId);
        return cgParameter;
    }

    public static @Nullable CGClass getContainingClass(@NonNull CGElement cgExpression) {
        CGElement cgElement = cgExpression;
        while (cgElement != null) {
            if (cgElement instanceof CGClass) {
                return (CGClass)cgElement;
            }
            cgElement = cgElement.getParent();
        }
        return null;
    }

    public static @NonNull CGValuedElement getInit(@NonNull CGTuplePart cgTuplePart) {
        return (CGValuedElement)ClassUtil.nonNullState((Object)cgTuplePart.getInit());
    }

    public static @NonNull CGValuedElement getInit(@NonNull CGVariable cgVariable) {
        return (CGValuedElement)ClassUtil.nonNullState((Object)cgVariable.getInit());
    }

    public static Iterable<@NonNull CGTuplePart> getParts(@NonNull CGTupleExp cgTupleExp) {
        return ClassUtil.nullFree(cgTupleExp.getParts());
    }

    public static @NonNull CGValuedElement getReferredConstant(@NonNull CGConstantExp cgConstantExp) {
        return (CGValuedElement)ClassUtil.nonNullState((Object)cgConstantExp.getReferredConstant());
    }

    public static @NonNull CGValuedElement getReferredVariable(@NonNull CGVariableExp cgVariableExp) {
        return (CGValuedElement)ClassUtil.nonNullState((Object)cgVariableExp.getReferredVariable());
    }

    public static boolean isInlinedId(@NonNull ElementId elementId) {
        return elementId instanceof PrimitiveTypeId || elementId instanceof OclVoidTypeId || elementId instanceof TemplateParameterId;
    }

    public static @Nullable Boolean isKindOf(@NonNull CGValuedElement cgValue, @NonNull CGExecutorType executorType) {
        CGTypeId actualTypeId;
        CGTypeId referenceTypeId = executorType.getUnderlyingTypeId();
        return referenceTypeId == (actualTypeId = cgValue.getTypeId()) ? Boolean.TRUE : null;
    }

    public static boolean isMavenSurefire() {
        String testNameSuffix = System.getProperty("testNameSuffix", "");
        return testNameSuffix != null && testNameSuffix.startsWith("maven");
    }

    public static boolean isTychoSurefire() {
        String testNameSuffix = System.getProperty("testNameSuffix", "");
        return testNameSuffix != null && testNameSuffix.startsWith("tycho");
    }

    public static @NonNull CGValuedElement replace(@NonNull CGValuedElement oldElement, @NonNull CGValuedElement newElement) {
        assert (!oldElement.isRequired() || !newElement.isNull());
        EObject oldContainer = oldElement.eContainer();
        EcoreUtil.replace((EObject)oldElement, (EObject)newElement);
        assert (oldElement.eContainer() == null);
        assert (newElement.eContainer() == oldContainer);
        return oldElement;
    }

    public static @NonNull String trimLines(@NonNull String classFileContent) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(classFileContent));
            StringBuilder s = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                int len;
                int i = len = line.length();
                while (i > 0 && Character.isWhitespace(line.charAt(i - 1))) {
                    --i;
                }
                s.append(i < len ? line.substring(0, i) : line);
                s.append("\n");
            }
            return s.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return classFileContent;
        }
    }

    public static void wrap(@NonNull CGCallExp wrapExp, @NonNull CGValuedElement wrappedExp) {
        wrapExp.setTypeId(wrappedExp.getTypeId());
        wrapExp.setAst(wrappedExp.getAst());
        CGUtil.replace(wrappedExp, wrapExp);
        wrapExp.setSource(wrappedExp);
    }
}

