/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.FontState;
import org.eclipse.mylyn.wikitext.parser.css.CssRule;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class CssStyleManager {
    public static final String RULE_VERTICAL_ALIGN = "vertical-align";
    public static final String RULE_TEXT_DECORATION = "text-decoration";
    public static final String RULE_FONT_FAMILY = "font-family";
    public static final String RULE_FONT_SIZE = "font-size";
    public static final String RULE_FONT_WEIGHT = "font-weight";
    public static final String RULE_FONT_STYLE = "font-style";
    public static final String RULE_BACKGROUND_COLOR = "background-color";
    public static final String RULE_COLOR = "color";
    private static final int MIN_FONT_SIZE = 9;
    private static final int MAX_FONT_SIZE = 50;
    private static final Map<String, Integer> colorToRgb = new HashMap<String, Integer>();
    static final Pattern rgbPattern;
    private final Font defaultFont;
    private final Font defaultMonospaceFont;
    private final Map<String, RuleHandler> ruleNameToHandler = new HashMap<String, RuleHandler>();
    private final int defaultFontHeight;
    private final int defaultMonospaceFontHeight;

    static {
        colorToRgb.put("AliceBlue".toLowerCase(), 0xF0F8FF);
        colorToRgb.put("AntiqueWhite".toLowerCase(), 16444375);
        colorToRgb.put("Aqua".toLowerCase(), 65535);
        colorToRgb.put("Aquamarine".toLowerCase(), 8388564);
        colorToRgb.put("Azure".toLowerCase(), 0xF0FFFF);
        colorToRgb.put("Beige".toLowerCase(), 16119260);
        colorToRgb.put("Bisque".toLowerCase(), 16770244);
        colorToRgb.put("Black".toLowerCase(), 0);
        colorToRgb.put("BlanchedAlmond".toLowerCase(), 16772045);
        colorToRgb.put("Blue".toLowerCase(), 255);
        colorToRgb.put("BlueViolet".toLowerCase(), 9055202);
        colorToRgb.put("Brown".toLowerCase(), 0xA52A2A);
        colorToRgb.put("BurlyWood".toLowerCase(), 14596231);
        colorToRgb.put("CadetBlue".toLowerCase(), 6266528);
        colorToRgb.put("Chartreuse".toLowerCase(), 0x7FFF00);
        colorToRgb.put("Chocolate".toLowerCase(), 13789470);
        colorToRgb.put("Coral".toLowerCase(), 16744272);
        colorToRgb.put("CornflowerBlue".toLowerCase(), 6591981);
        colorToRgb.put("Cornsilk".toLowerCase(), 16775388);
        colorToRgb.put("Crimson".toLowerCase(), 14423100);
        colorToRgb.put("Cyan".toLowerCase(), 65535);
        colorToRgb.put("DarkBlue".toLowerCase(), 139);
        colorToRgb.put("DarkCyan".toLowerCase(), 35723);
        colorToRgb.put("DarkGoldenRod".toLowerCase(), 12092939);
        colorToRgb.put("DarkGray".toLowerCase(), 0xA9A9A9);
        colorToRgb.put("DarkGrey".toLowerCase(), 0xA9A9A9);
        colorToRgb.put("DarkGreen".toLowerCase(), 25600);
        colorToRgb.put("DarkKhaki".toLowerCase(), 12433259);
        colorToRgb.put("DarkMagenta".toLowerCase(), 0x8B008B);
        colorToRgb.put("DarkOliveGreen".toLowerCase(), 5597999);
        colorToRgb.put("Darkorange".toLowerCase(), 16747520);
        colorToRgb.put("DarkOrchid".toLowerCase(), 10040012);
        colorToRgb.put("DarkRed".toLowerCase(), 0x8B0000);
        colorToRgb.put("DarkSalmon".toLowerCase(), 15308410);
        colorToRgb.put("DarkSeaGreen".toLowerCase(), 9419919);
        colorToRgb.put("DarkSlateBlue".toLowerCase(), 4734347);
        colorToRgb.put("DarkSlateGray".toLowerCase(), 0x2F4F4F);
        colorToRgb.put("DarkSlateGrey".toLowerCase(), 0x2F4F4F);
        colorToRgb.put("DarkTurquoise".toLowerCase(), 52945);
        colorToRgb.put("DarkViolet".toLowerCase(), 9699539);
        colorToRgb.put("DeepPink".toLowerCase(), 16716947);
        colorToRgb.put("DeepSkyBlue".toLowerCase(), 49151);
        colorToRgb.put("DimGray".toLowerCase(), 0x696969);
        colorToRgb.put("DimGrey".toLowerCase(), 0x696969);
        colorToRgb.put("DodgerBlue".toLowerCase(), 2003199);
        colorToRgb.put("FireBrick".toLowerCase(), 0xB22222);
        colorToRgb.put("FloralWhite".toLowerCase(), 0xFFFAF0);
        colorToRgb.put("ForestGreen".toLowerCase(), 0x228B22);
        colorToRgb.put("Fuchsia".toLowerCase(), 0xFF00FF);
        colorToRgb.put("Gainsboro".toLowerCase(), 0xDCDCDC);
        colorToRgb.put("GhostWhite".toLowerCase(), 0xF8F8FF);
        colorToRgb.put("Gold".toLowerCase(), 16766720);
        colorToRgb.put("GoldenRod".toLowerCase(), 14329120);
        colorToRgb.put("Gray".toLowerCase(), 0x808080);
        colorToRgb.put("Grey".toLowerCase(), 0x808080);
        colorToRgb.put("Green".toLowerCase(), 32768);
        colorToRgb.put("GreenYellow".toLowerCase(), 11403055);
        colorToRgb.put("HoneyDew".toLowerCase(), 0xF0FFF0);
        colorToRgb.put("HotPink".toLowerCase(), 16738740);
        colorToRgb.put("IndianRed".toLowerCase(), 0xCD5C5C);
        colorToRgb.put("Indigo".toLowerCase(), 4915330);
        colorToRgb.put("Ivory".toLowerCase(), 0xFFFFF0);
        colorToRgb.put("Khaki".toLowerCase(), 15787660);
        colorToRgb.put("Lavender".toLowerCase(), 15132410);
        colorToRgb.put("LavenderBlush".toLowerCase(), 0xFFF0F5);
        colorToRgb.put("LawnGreen".toLowerCase(), 8190976);
        colorToRgb.put("LemonChiffon".toLowerCase(), 16775885);
        colorToRgb.put("LightBlue".toLowerCase(), 11393254);
        colorToRgb.put("LightCoral".toLowerCase(), 0xF08080);
        colorToRgb.put("LightCyan".toLowerCase(), 0xE0FFFF);
        colorToRgb.put("LightGoldenRodYellow".toLowerCase(), 16448210);
        colorToRgb.put("LightGray".toLowerCase(), 0xD3D3D3);
        colorToRgb.put("LightGrey".toLowerCase(), 0xD3D3D3);
        colorToRgb.put("LightGreen".toLowerCase(), 0x90EE90);
        colorToRgb.put("LightPink".toLowerCase(), 16758465);
        colorToRgb.put("LightSalmon".toLowerCase(), 16752762);
        colorToRgb.put("LightSeaGreen".toLowerCase(), 2142890);
        colorToRgb.put("LightSkyBlue".toLowerCase(), 8900346);
        colorToRgb.put("LightSlateGray".toLowerCase(), 0x778899);
        colorToRgb.put("LightSlateGrey".toLowerCase(), 0x778899);
        colorToRgb.put("LightSteelBlue".toLowerCase(), 11584734);
        colorToRgb.put("LightYellow".toLowerCase(), 0xFFFFE0);
        colorToRgb.put("Lime".toLowerCase(), 65280);
        colorToRgb.put("LimeGreen".toLowerCase(), 3329330);
        colorToRgb.put("Linen".toLowerCase(), 16445670);
        colorToRgb.put("Magenta".toLowerCase(), 0xFF00FF);
        colorToRgb.put("Maroon".toLowerCase(), 0x800000);
        colorToRgb.put("MediumAquaMarine".toLowerCase(), 6737322);
        colorToRgb.put("MediumBlue".toLowerCase(), 205);
        colorToRgb.put("MediumOrchid".toLowerCase(), 12211667);
        colorToRgb.put("MediumPurple".toLowerCase(), 9662680);
        colorToRgb.put("MediumSeaGreen".toLowerCase(), 3978097);
        colorToRgb.put("MediumSlateBlue".toLowerCase(), 8087790);
        colorToRgb.put("MediumSpringGreen".toLowerCase(), 64154);
        colorToRgb.put("MediumTurquoise".toLowerCase(), 4772300);
        colorToRgb.put("MediumVioletRed".toLowerCase(), 13047173);
        colorToRgb.put("MidnightBlue".toLowerCase(), 1644912);
        colorToRgb.put("MintCream".toLowerCase(), 0xF5FFFA);
        colorToRgb.put("MistyRose".toLowerCase(), 16770273);
        colorToRgb.put("Moccasin".toLowerCase(), 16770229);
        colorToRgb.put("NavajoWhite".toLowerCase(), 16768685);
        colorToRgb.put("Navy".toLowerCase(), 128);
        colorToRgb.put("OldLace".toLowerCase(), 16643558);
        colorToRgb.put("Olive".toLowerCase(), 0x808000);
        colorToRgb.put("OliveDrab".toLowerCase(), 7048739);
        colorToRgb.put("Orange".toLowerCase(), 16753920);
        colorToRgb.put("OrangeRed".toLowerCase(), 16729344);
        colorToRgb.put("Orchid".toLowerCase(), 14315734);
        colorToRgb.put("PaleGoldenRod".toLowerCase(), 0xEEE8AA);
        colorToRgb.put("PaleGreen".toLowerCase(), 10025880);
        colorToRgb.put("PaleTurquoise".toLowerCase(), 0xAFEEEE);
        colorToRgb.put("PaleVioletRed".toLowerCase(), 14184595);
        colorToRgb.put("PapayaWhip".toLowerCase(), 16773077);
        colorToRgb.put("PeachPuff".toLowerCase(), 16767673);
        colorToRgb.put("Peru".toLowerCase(), 13468991);
        colorToRgb.put("Pink".toLowerCase(), 16761035);
        colorToRgb.put("Plum".toLowerCase(), 0xDDA0DD);
        colorToRgb.put("PowderBlue".toLowerCase(), 11591910);
        colorToRgb.put("Purple".toLowerCase(), 0x800080);
        colorToRgb.put("Red".toLowerCase(), 0xFF0000);
        colorToRgb.put("RosyBrown".toLowerCase(), 12357519);
        colorToRgb.put("RoyalBlue".toLowerCase(), 4286945);
        colorToRgb.put("SaddleBrown".toLowerCase(), 9127187);
        colorToRgb.put("Salmon".toLowerCase(), 16416882);
        colorToRgb.put("SandyBrown".toLowerCase(), 16032864);
        colorToRgb.put("SeaGreen".toLowerCase(), 3050327);
        colorToRgb.put("SeaShell".toLowerCase(), 0xFFF5EE);
        colorToRgb.put("Sienna".toLowerCase(), 10506797);
        colorToRgb.put("Silver".toLowerCase(), 0xC0C0C0);
        colorToRgb.put("SkyBlue".toLowerCase(), 8900331);
        colorToRgb.put("SlateBlue".toLowerCase(), 6970061);
        colorToRgb.put("SlateGray".toLowerCase(), 7372944);
        colorToRgb.put("SlateGrey".toLowerCase(), 7372944);
        colorToRgb.put("Snow".toLowerCase(), 0xFFFAFA);
        colorToRgb.put("SpringGreen".toLowerCase(), 65407);
        colorToRgb.put("SteelBlue".toLowerCase(), 4620980);
        colorToRgb.put("Tan".toLowerCase(), 13808780);
        colorToRgb.put("Teal".toLowerCase(), 32896);
        colorToRgb.put("Thistle".toLowerCase(), 14204888);
        colorToRgb.put("Tomato".toLowerCase(), 16737095);
        colorToRgb.put("Turquoise".toLowerCase(), 4251856);
        colorToRgb.put("Violet".toLowerCase(), 0xEE82EE);
        colorToRgb.put("Wheat".toLowerCase(), 16113331);
        colorToRgb.put("White".toLowerCase(), 0xFFFFFF);
        colorToRgb.put("WhiteSmoke".toLowerCase(), 0xF5F5F5);
        colorToRgb.put("Yellow".toLowerCase(), 0xFFFF00);
        colorToRgb.put("YellowGreen".toLowerCase(), 10145074);
        rgbPattern = Pattern.compile("rgb\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)");
    }

    public CssStyleManager(Font defaultFont) {
        this(defaultFont, null);
    }

    public CssStyleManager(Font defaultFont, Font defaultMonospaceFont) {
        this.register(new ColorRuleHandler());
        this.register(new BackgroundColorRuleHandler());
        this.register(new FontStyleRuleHandler());
        this.register(new FontWeightRuleHandler());
        this.register(new FontSizeRuleHandler());
        this.register(new FontFamilyRuleHandler());
        this.register(new TextDecorationRuleHandler());
        this.register(new VerticalAlignRuleHandler());
        if (defaultFont == null) {
            throw new IllegalArgumentException();
        }
        this.defaultFont = defaultFont;
        this.defaultFontHeight = defaultFont.getFontData()[0].getHeight();
        this.defaultMonospaceFont = defaultMonospaceFont;
        this.defaultMonospaceFontHeight = defaultMonospaceFont == null ? this.defaultFontHeight : defaultMonospaceFont.getFontData()[0].getHeight();
    }

    public CssStyleManager() {
        this.register(new ColorRuleHandler());
        this.register(new BackgroundColorRuleHandler());
        this.register(new FontStyleRuleHandler());
        this.register(new FontWeightRuleHandler());
        this.register(new FontSizeRuleHandler());
        this.register(new FontFamilyRuleHandler());
        this.register(new TextDecorationRuleHandler());
        this.register(new VerticalAlignRuleHandler());
        this.defaultFont = null;
        this.defaultMonospaceFont = null;
        this.defaultFontHeight = 11;
        this.defaultMonospaceFontHeight = 11;
    }

    private void register(RuleHandler handler) {
        this.ruleNameToHandler.put(handler.getRuleName(), handler);
    }

    public StyleRange createStyleRange(FontState fontState, int offset, int length) {
        StyleRange styleRange = new StyleRange(offset, length, this.getColorFromRgb(fontState.foreground), this.getColorFromRgb(fontState.background));
        if (fontState.isBold()) {
            styleRange.fontStyle |= 1;
        }
        if (fontState.isUnderline()) {
            styleRange.underline = true;
        }
        if (fontState.isStrikethrough()) {
            styleRange.strikeout = true;
        }
        if (fontState.isItalic()) {
            styleRange.fontStyle |= 2;
        }
        if (fontState.isSubscript()) {
            styleRange.rise = -4;
        } else if (fontState.isSuperscript()) {
            styleRange.rise = 4;
        }
        if (fontState.isFixedWidth()) {
            Font monospaceFont;
            String symbolicName = this.computeSymbolicName(fontState, "monospace", this.defaultMonospaceFont);
            Font font = monospaceFont = JFaceResources.getFontRegistry().hasValueFor(symbolicName) ? JFaceResources.getFontRegistry().get(symbolicName) : null;
            if (monospaceFont == null) {
                FontData[] fontData = null;
                if (this.defaultMonospaceFont != null) {
                    fontData = this.defaultMonospaceFont.getFontData();
                } else {
                    String[] fontNames;
                    Font defaultFont = JFaceResources.getFontRegistry().defaultFont();
                    String[] stringArray = fontNames = this.computeMonospaceFontNames();
                    int n = fontNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fontName = stringArray[n2];
                        fontData = defaultFont.getDevice().getFontList(fontName, false);
                        if (fontData == null || fontData.length == 0) {
                            fontData = defaultFont.getDevice().getFontList(fontName, true);
                        }
                        if (fontData != null && fontData.length > 0) break;
                        ++n2;
                    }
                }
                if (fontData != null && fontData.length > 0) {
                    fontData = this.applyFontState(fontState, fontData);
                    JFaceResources.getFontRegistry().put(symbolicName, fontData);
                    monospaceFont = JFaceResources.getFontRegistry().get(symbolicName);
                }
            }
            if (monospaceFont != null) {
                styleRange.font = monospaceFont;
            }
        } else {
            Font font;
            String symbolicName = this.computeSymbolicName(fontState, "default", this.defaultFont);
            Font font2 = font = JFaceResources.getFontRegistry().hasValueFor(symbolicName) ? JFaceResources.getFontRegistry().get(symbolicName) : null;
            if (font == null) {
                FontData[] fontData = this.createFontData(fontState, this.defaultFont);
                JFaceResources.getFontRegistry().put(symbolicName, fontData);
                font = JFaceResources.getFontRegistry().get(symbolicName);
            }
            if (font != null) {
                styleRange.font = font;
            }
        }
        return styleRange;
    }

    private String[] computeMonospaceFontNames() {
        boolean macosx;
        boolean linux;
        block5: {
            linux = false;
            macosx = false;
            try {
                String os = Platform.getOS();
                macosx = "macosx".equals(os);
                linux = "linux".equals(os);
            }
            catch (Exception e) {
                String osName = System.getProperty("os.name");
                if (osName == null) break block5;
                if (osName.startsWith("Mac")) {
                    macosx = true;
                }
                if (!osName.startsWith("Linux")) break block5;
                linux = true;
            }
        }
        if (linux) {
            return new String[]{"monospace", "Courier New", "Courier"};
        }
        if (macosx) {
            return new String[]{"Courier", "Courier New"};
        }
        return new String[]{"Courier New", "Courier"};
    }

    private FontData[] applyFontState(FontState fontState, FontData[] fontData) {
        boolean bold = fontState.isBold();
        boolean italics = fontState.isItalic();
        int fontHeight = this.computeFontHeight(fontState);
        FontData[] fontDataArray = fontData;
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(fontHeight);
            int style = data.getStyle();
            if (bold) {
                style |= 1;
            }
            if (italics) {
                style |= 2;
            }
            data.setStyle(style);
            ++n2;
        }
        return fontData;
    }

    private int computeFontHeight(FontState fontState) {
        int fontHeight = fontState.isFixedWidth() ? this.defaultMonospaceFontHeight : this.defaultFontHeight;
        fontHeight = (int)((float)fontHeight * fontState.sizeFactor);
        fontHeight = Math.min(50, Math.max(9, fontHeight));
        return fontHeight;
    }

    private FontData[] createFontData(FontState fontState, Font baseFont) {
        FontData[] fontData = new FontData[baseFont.getFontData().length];
        int index = -1;
        FontData[] fontDataArray = baseFont.getFontData();
        int n = fontDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fontData[++index] = new FontData(fd.getName(), fd.getHeight(), fd.getStyle());
            ++n2;
        }
        return this.applyFontState(fontState, fontData);
    }

    private String computeSymbolicName(FontState fontState, String key, Font defaultFont) {
        String symbolicName = String.valueOf(this.getClass().getSimpleName()) + '-' + key + '-' + this.computeFontHeight(fontState);
        if (fontState.isBold()) {
            symbolicName = String.valueOf(symbolicName) + "-bold";
        }
        if (fontState.isItalic()) {
            symbolicName = String.valueOf(symbolicName) + "-italic";
        }
        if (defaultFont != null) {
            FontData fontData = defaultFont.getFontData()[0];
            symbolicName = String.valueOf(symbolicName) + '-' + fontData.getName() + '-' + fontData.getStyle();
        }
        return symbolicName;
    }

    public Color getColorFromRgb(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        String symbolicName = String.format("#%02X%02X%02X", rgb.red, rgb.green, rgb.blue);
        Color color = JFaceResources.getColorRegistry().get(symbolicName);
        if (color == null) {
            JFaceResources.getColorRegistry().put(symbolicName, rgb);
            color = JFaceResources.getColorRegistry().get(symbolicName);
        }
        return color;
    }

    public SortedSet<String> getRecognizedRuleNames() {
        return new TreeSet<String>(this.ruleNameToHandler.keySet());
    }

    public boolean isKnownRule(CssRule rule) {
        return this.ruleNameToHandler.containsKey(rule.name);
    }

    private static RGB toRGB(int rgb) {
        return new RGB((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
    }

    public static Integer cssColorRgb(String cssColor) {
        Integer rgb = colorToRgb.get(cssColor.toLowerCase());
        if (rgb == null) {
            try {
                if (cssColor.startsWith("#")) {
                    String rgbNumeric = cssColor.substring(1);
                    if (rgbNumeric.length() == 3) {
                        String firstDigit = rgbNumeric.substring(0, 1);
                        String secondDigit = rgbNumeric.substring(1, 2);
                        String thirdDigit = rgbNumeric.substring(2, 3);
                        rgbNumeric = String.valueOf(firstDigit) + firstDigit + secondDigit + secondDigit + thirdDigit + thirdDigit;
                    }
                    rgb = Integer.parseInt(rgbNumeric, 16);
                } else {
                    Matcher rgbMatcher = rgbPattern.matcher(cssColor);
                    if (rgbMatcher.matches()) {
                        String r = rgbMatcher.group(1);
                        String g = rgbMatcher.group(2);
                        String b = rgbMatcher.group(3);
                        String rgbNumeric = String.format("%02X%02X%02X", Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
                        rgb = Integer.parseInt(rgbNumeric, 16);
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return rgb;
    }

    public FontState createDefaultFontState() {
        FontState fontState = new FontState();
        return fontState;
    }

    public void processCssStyles(FontState fontState, FontState parentFontState, CssRule rule) {
        RuleHandler ruleHandler = this.ruleNameToHandler.get(rule.name);
        if (ruleHandler != null) {
            ruleHandler.process(rule, fontState, parentFontState);
        }
    }

    private static class BackgroundColorRuleHandler
    implements RuleHandler {
        private BackgroundColorRuleHandler() {
        }

        @Override
        public String getRuleName() {
            return CssStyleManager.RULE_BACKGROUND_COLOR;
        }

        @Override
        public void process(CssRule rule, FontState fontState, FontState parentFontState) {
            Integer rgb = CssStyleManager.cssColorRgb(rule.value);
            if (rgb != null) {
                fontState.background = CssStyleManager.toRGB(rgb);
            }
        }
    }

    private static class ColorRuleHandler
    implements RuleHandler {
        private ColorRuleHandler() {
        }

        @Override
        public String getRuleName() {
            return CssStyleManager.RULE_COLOR;
        }

        @Override
        public void process(CssRule rule, FontState fontState, FontState parentFontState) {
            Integer rgb = CssStyleManager.cssColorRgb(rule.value);
            if (rgb != null) {
                fontState.foreground = CssStyleManager.toRGB(rgb);
            }
        }
    }

    private static class FontFamilyRuleHandler
    implements RuleHandler {
        private FontFamilyRuleHandler() {
        }

        @Override
        public String getRuleName() {
            return CssStyleManager.RULE_FONT_FAMILY;
        }

        @Override
        public void process(CssRule rule, FontState fontState, FontState parentFontState) {
            String[] parts;
            String[] stringArray = parts = rule.value.split("((\\s+)|(\\s*,\\s*))");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.length() > 1 && part.startsWith("'") && part.endsWith("'")) {
                    part = part.substring(1, part.length() - 1);
                }
                if ("monospace".equals(part) || "courier".equalsIgnoreCase(part) || "courier new".equalsIgnoreCase(part)) {
                    fontState.setFixedWidth(true);
                } else {
                    fontState.setFixedWidth(false);
                }
                ++n2;
            }
        }
    }

    private class FontSizeRuleHandler
    implements RuleHandler {
        private FontSizeRuleHandler() {
        }

        @Override
        public String getRuleName() {
            return CssStyleManager.RULE_FONT_SIZE;
        }

        @Override
        public void process(CssRule rule, FontState fontState, FontState parentFontState) {
            String cssFontSizeValue = rule.value;
            if (cssFontSizeValue.endsWith("%")) {
                try {
                    float percentage = Float.parseFloat(cssFontSizeValue.substring(0, cssFontSizeValue.length() - 1)) / 100.0f;
                    if (percentage > 0.0f) {
                        fontState.sizeFactor = percentage;
                    }
                }
                catch (NumberFormatException percentage) {}
            } else if ("xx-small".equals(cssFontSizeValue)) {
                fontState.sizeFactor = 0.4f;
            } else if ("x-small".equals(cssFontSizeValue)) {
                fontState.sizeFactor = 0.6f;
            } else if ("small".equals(cssFontSizeValue)) {
                fontState.sizeFactor = 0.8f;
            } else if ("medium".equals(cssFontSizeValue)) {
                fontState.sizeFactor = 1.0f;
            } else if ("large".equals(cssFontSizeValue)) {
                fontState.sizeFactor = 1.2f;
            } else if ("x-large".equals(cssFontSizeValue)) {
                fontState.sizeFactor = 1.4f;
            } else if ("xx-large".equals(cssFontSizeValue)) {
                fontState.sizeFactor = 1.6f;
            } else if ("larger".equals(cssFontSizeValue)) {
                fontState.sizeFactor *= 1.2f;
            } else if ("smaller".equals(cssFontSizeValue)) {
                fontState.sizeFactor = parentFontState.sizeFactor - parentFontState.sizeFactor * 0.2f;
            } else {
                try {
                    float exactSize;
                    if (cssFontSizeValue.endsWith("pt") || cssFontSizeValue.endsWith("px")) {
                        cssFontSizeValue = cssFontSizeValue.substring(0, cssFontSizeValue.length() - 2);
                    }
                    if ((exactSize = Float.parseFloat(cssFontSizeValue)) > 0.0f) {
                        float defaultSize = fontState.isFixedWidth() ? CssStyleManager.this.defaultMonospaceFontHeight : CssStyleManager.this.defaultFontHeight;
                        fontState.sizeFactor = exactSize / defaultSize;
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class FontStyleRuleHandler
    implements RuleHandler {
        private FontStyleRuleHandler() {
        }

        @Override
        public String getRuleName() {
            return CssStyleManager.RULE_FONT_STYLE;
        }

        @Override
        public void process(CssRule rule, FontState fontState, FontState parentFontState) {
            String[] parts;
            String[] stringArray = parts = rule.value.split("((\\s+)|(\\s*,\\s*))");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if ("italic".equals(part)) {
                    fontState.setItalic(true);
                } else if ("bold".equals(part)) {
                    fontState.setBold(true);
                } else if ("normal".equals(part)) {
                    fontState.setItalic(false);
                }
                ++n2;
            }
        }
    }

    private static class FontWeightRuleHandler
    implements RuleHandler {
        private FontWeightRuleHandler() {
        }

        @Override
        public String getRuleName() {
            return CssStyleManager.RULE_FONT_WEIGHT;
        }

        @Override
        public void process(CssRule rule, FontState fontState, FontState parentFontState) {
            if ("bold".equals(rule.value) || "bolder".equals(rule.value)) {
                fontState.setBold(true);
            } else if ("normal".equals(rule.value) || "lighter".equals(rule.value)) {
                fontState.setBold(false);
            }
        }
    }

    private static interface RuleHandler {
        public String getRuleName();

        public void process(CssRule var1, FontState var2, FontState var3);
    }

    private static class TextDecorationRuleHandler
    implements RuleHandler {
        private TextDecorationRuleHandler() {
        }

        @Override
        public String getRuleName() {
            return CssStyleManager.RULE_TEXT_DECORATION;
        }

        @Override
        public void process(CssRule rule, FontState fontState, FontState parentFontState) {
            String[] parts;
            String[] stringArray = parts = rule.value.split("((\\s+)|(\\s*,\\s*))");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if ("none".equals(part)) {
                    fontState.setStrikethrough(false);
                    fontState.setUnderline(false);
                } else if ("line-through".equals(part)) {
                    fontState.setStrikethrough(true);
                } else if ("underline".equals(part)) {
                    fontState.setUnderline(true);
                }
                ++n2;
            }
        }
    }

    private static class VerticalAlignRuleHandler
    implements RuleHandler {
        private VerticalAlignRuleHandler() {
        }

        @Override
        public String getRuleName() {
            return CssStyleManager.RULE_VERTICAL_ALIGN;
        }

        @Override
        public void process(CssRule rule, FontState fontState, FontState parentFontState) {
            if ("super".equals(rule.value)) {
                fontState.setSuperscript(true);
            } else if ("sub".equals(rule.value)) {
                fontState.setSubscript(true);
            }
        }
    }
}

