/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.notifications;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.SynchronizationManger;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataDiff;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManagerEvent;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeTasksJob;
import org.eclipse.mylyn.internal.tasks.ui.ITaskListNotificationProvider;
import org.eclipse.mylyn.internal.tasks.ui.notifications.Messages;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDiffUtil;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotification;
import org.eclipse.mylyn.internal.tasks.ui.views.PresentationFilter;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class TaskListNotifier
implements ITaskDataManagerListener,
ITaskListNotificationProvider {
    public static final String KEY_INCOMING_NOTIFICATION_TEXT = "org.eclipse.mylyn.tasks.ui.TaskNotificationText";
    private final TaskDataManager taskDataManager;
    private final List<TaskListNotification> notificationQueue = new ArrayList<TaskListNotification>();
    public boolean enabled;
    private final SynchronizationManger synchronizationManger;

    public TaskListNotifier(TaskDataManager taskDataManager, SynchronizationManger synchronizationManger) {
        this.taskDataManager = taskDataManager;
        this.synchronizationManger = synchronizationManger;
    }

    public TaskListNotification getNotification(ITask task, Object token) {
        String notificationText;
        if (task.getSynchronizationState() == ITask.SynchronizationState.INCOMING_NEW) {
            TaskListNotification notification = new TaskListNotification(task, token);
            notification.setDescription(Messages.TaskListNotifier_New_unread_task);
            return notification;
        }
        if (task.getSynchronizationState().isIncoming() && !Strings.isNullOrEmpty((String)(notificationText = task.getAttribute(KEY_INCOMING_NOTIFICATION_TEXT)))) {
            TaskListNotification notification = new TaskListNotification(task, token);
            notification.setDescription(notificationText);
            return notification;
        }
        return null;
    }

    public TaskDataDiff getDiff(ITask task) {
        try {
            TaskDataState workingCopy = this.taskDataManager.getTaskDataState(task);
            if (workingCopy != null) {
                return this.synchronizationManger.createDiff(workingCopy.getRepositoryData(), workingCopy.getLastReadData(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to get task data for task: \"" + task + "\"", (Throwable)e));
        }
        return null;
    }

    public void taskDataUpdated(TaskDataManagerEvent event) {
        if (event.getTaskChanged() && event.getData() instanceof SynchronizeTasksJob) {
            this.recordNotificationText(event);
            if (this.shouldDisplayNotification(event)) {
                this.queueNotification(event);
            }
        }
    }

    private void recordNotificationText(TaskDataManagerEvent event) {
        ITask task = event.getTask();
        ITask.SynchronizationState state = task.getSynchronizationState();
        String notificationText = null;
        if (state.isIncoming()) {
            notificationText = this.computeNotificationText(task);
        }
        task.setAttribute(KEY_INCOMING_NOTIFICATION_TEXT, notificationText);
    }

    public String computeNotificationText(ITask task) {
        TaskDataDiff diff = this.getDiff(task);
        if (diff != null && diff.hasChanged()) {
            return TaskDiffUtil.toString(diff, true);
        }
        return null;
    }

    private boolean shouldDisplayNotification(TaskDataManagerEvent event) {
        return event.getToken() != null && this.isEnabled() && PresentationFilter.getInstance().isInVisibleQuery(event.getTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNotification(TaskDataManagerEvent event) {
        TaskListNotification notification;
        AbstractRepositoryConnectorUi connectorUi = TasksUi.getRepositoryConnectorUi(event.getTaskData().getConnectorKind());
        if (!connectorUi.hasCustomNotifications() && (notification = this.getNotification(event.getTask(), event.getToken())) != null) {
            List<TaskListNotification> list = this.notificationQueue;
            synchronized (list) {
                if (this.enabled) {
                    this.notificationQueue.add(notification);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AbstractUiNotification> getNotifications() {
        List<TaskListNotification> list = this.notificationQueue;
        synchronized (list) {
            if (this.notificationQueue.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<AbstractUiNotification> result = new HashSet<AbstractUiNotification>(this.notificationQueue);
            this.notificationQueue.clear();
            return result;
        }
    }

    public void editsDiscarded(TaskDataManagerEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        List<TaskListNotification> list = this.notificationQueue;
        synchronized (list) {
            if (!enabled) {
                this.notificationQueue.clear();
            }
            this.enabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        List<TaskListNotification> list = this.notificationQueue;
        synchronized (list) {
            return this.enabled;
        }
    }
}

