/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.File;
import java.net.URL;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.internal.AbstractPart;
import org.eclipse.mat.report.internal.DataFile;
import org.eclipse.mat.report.internal.LinkedPart;
import org.eclipse.mat.report.internal.QueryPart;
import org.eclipse.mat.report.internal.ResultRenderer;

class RenderingInfo
implements IOutputter.Context {
    private ResultRenderer resultRenderer;
    private QueryPart part;
    private boolean[] visibleColumns;
    private int limit;
    private boolean showTotals = true;

    public RenderingInfo(QueryPart part, ResultRenderer resultRenderer) {
        this.part = part;
        this.resultRenderer = resultRenderer;
        this.limit = 25;
    }

    public RenderingInfo(QueryPart part, ResultRenderer resultRenderer, int columnCount) {
        this(part, resultRenderer);
        this.visibleColumns = new boolean[columnCount];
        int ii = 0;
        while (ii < this.visibleColumns.length) {
            this.visibleColumns[ii] = true;
            ++ii;
        }
    }

    public String getId() {
        return this.part.getId();
    }

    public File getOutputDirectory() {
        return this.resultRenderer.getOutputDirectory(this.part);
    }

    public IQueryContext getQueryContext() {
        return this.resultRenderer.getQueryContext();
    }

    public String addIcon(URL icon) {
        return this.resultRenderer.addIcon(icon, this.part);
    }

    public String getPathToRoot() {
        return this.resultRenderer.getPathToRoot(this.part);
    }

    public String addContextResult(String name, IResult result) {
        AbstractPart child = null;
        child = result instanceof Spec ? this.part.factory.create(this.part, (Spec)result) : this.part.factory.create(this.part, new QuerySpec(name, result));
        child.params().put("$embedded", "true");
        DataFile dataFile = child.getDataFile();
        String filename = dataFile.getUrl();
        if (filename == null) {
            filename = dataFile.getSuggestedFile();
        }
        if (filename == null) {
            filename = "pages/" + child.getId() + ".html";
            dataFile.setSuggestedFile(filename);
        }
        if (!(child instanceof LinkedPart)) {
            this.part.children.add(child);
        }
        return String.valueOf(this.resultRenderer.getPathToRoot(this.part)) + filename;
    }

    public boolean hasLimit() {
        return this.limit >= 0;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isColumnVisible(int columnIndex) {
        return this.visibleColumns[columnIndex];
    }

    public boolean isTotalsRowVisible() {
        return this.showTotals;
    }

    public String param(String key) {
        return this.part.params().get(key);
    }

    public String param(String key, String defaultValue) {
        return this.part.params().get(key, defaultValue);
    }

    public void setShowTotals(boolean showTotals) {
        this.showTotals = showTotals;
    }

    public void setColumnVisible(int columnIndex, boolean isVisible) {
        this.visibleColumns[columnIndex] = isVisible;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

