/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.snapshot.extension.CollectionExtractionInfo;
import org.eclipse.mat.snapshot.extension.ICollectionExtractorProvider;
import org.eclipse.mat.util.RegistryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionExtractorProviderRegistry
extends RegistryReader<ICollectionExtractorProvider> {
    private static final CollectionExtractorProviderRegistry INSTANCE = new CollectionExtractorProviderRegistry();
    private final Map<ICollectionExtractorProvider, List<CollectionExtractionInfo>> providerMap = new HashMap<ICollectionExtractorProvider, List<CollectionExtractionInfo>>();
    private final List<CollectionExtractionInfo> extractorInfos = new ArrayList<CollectionExtractionInfo>();
    private final List<CollectionExtractionInfo> unmodifiableExtractorInfos;

    public static CollectionExtractorProviderRegistry instance() {
        return INSTANCE;
    }

    private CollectionExtractorProviderRegistry() {
        this.init(MATPlugin.getDefault().getExtensionTracker(), "org.eclipse.mat.api.collectionExtractorProvider");
        this.unmodifiableExtractorInfos = Collections.unmodifiableList(this.extractorInfos);
    }

    protected ICollectionExtractorProvider createDelegate(IConfigurationElement configElement) throws CoreException {
        ICollectionExtractorProvider provider = (ICollectionExtractorProvider)configElement.createExecutableExtension("impl");
        List<CollectionExtractionInfo> infos = provider.getExtractorInfo();
        this.providerMap.put(provider, infos);
        this.extractorInfos.addAll(infos);
        return provider;
    }

    protected void removeDelegate(ICollectionExtractorProvider provider) {
        List<CollectionExtractionInfo> infos = this.providerMap.get(provider);
        this.extractorInfos.removeAll(infos);
    }

    public List<CollectionExtractionInfo> getCollectionExtractionInfo() {
        return this.unmodifiableExtractorInfos;
    }
}

