/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl;

import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.LocalVariable;
import org.eclipse.m2m.atl.emftvm.impl.TypedElementImpl;

public class LocalVariableImpl
extends TypedElementImpl
implements LocalVariable {
    protected static final int SLOT_EDEFAULT = -1;
    protected int slot = -1;
    protected Instruction startInstruction;
    protected Instruction endInstruction;
    protected static final int START_INSTRUCTION_INDEX_EDEFAULT = -1;
    protected static final int END_INSTRUCTION_INDEX_EDEFAULT = -1;
    protected int startInstructionIndex = -1;
    protected int endInstructionIndex = -1;

    protected LocalVariableImpl() {
    }

    protected EClass eStaticClass() {
        return EmftvmPackage.Literals.LOCAL_VARIABLE;
    }

    public int getSlot() {
        CodeBlock cb;
        if (this.slot == -1 && (cb = this.getOwningBlock()) != null) {
            EList<LocalVariable> locals = cb.getLocalVariables();
            int maxIndex = locals.indexOf((Object)this);
            assert (maxIndex > -1);
            if (maxIndex == 0) {
                this.slot = 0;
            } else {
                HashSet<Integer> localSlots = new HashSet<Integer>(maxIndex);
                int startIndex = this.getStartInstructionIndex();
                int endIndex = this.getEndInstructionIndex();
                int lvIndex = 0;
                while (lvIndex < maxIndex) {
                    LocalVariable lv = (LocalVariable)locals.get(lvIndex);
                    int start = lv.getStartInstructionIndex();
                    int end = lv.getEndInstructionIndex();
                    assert (startIndex < 0 || start > -1);
                    assert (endIndex < 0 || end > -1);
                    if (startIndex < 0 || endIndex < 0 || start <= endIndex && end >= startIndex) {
                        int slot = lv.getSlot();
                        if (slot < 0) {
                            throw new RuntimeException(String.format("Cannot calculate slot for %s; missing slot for %s", this, lv));
                        }
                        if (localSlots.contains(slot)) {
                            throw new RuntimeException(String.format("Code block %s has more than one local variable occupying slot %d at instruction %d", cb, slot, startIndex));
                        }
                        localSlots.add(slot);
                    }
                    ++lvIndex;
                }
                int freeSlot = 0;
                while (localSlots.contains(freeSlot)) {
                    ++freeSlot;
                }
                this.slot = freeSlot;
            }
        }
        return this.slot;
    }

    public void setSlot(int newSlot) {
        int oldSlot = this.slot;
        this.slot = newSlot;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldSlot, this.slot));
        }
    }

    public Instruction getStartInstruction() {
        if (this.startInstruction == null) {
            CodeBlock cb = this.getOwningBlock();
            int startInstructionIndex = this.getStartInstructionIndex();
            if (cb != null && startInstructionIndex != -1 && startInstructionIndex < cb.getCode().size()) {
                this.startInstruction = (Instruction)cb.getCode().get(startInstructionIndex);
            }
        }
        if (this.startInstruction != null && this.startInstruction.eIsProxy()) {
            InternalEObject oldStartInstruction = (InternalEObject)this.startInstruction;
            this.startInstruction = (Instruction)this.eResolveProxy(oldStartInstruction);
            if (this.startInstruction != oldStartInstruction && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldStartInstruction, (Object)this.startInstruction));
            }
        }
        return this.startInstruction;
    }

    public Instruction basicGetStartInstruction() {
        if (this.startInstruction == null) {
            CodeBlock cb = this.getOwningBlock();
            int startInstructionIndex = this.getStartInstructionIndex();
            if (cb != null && startInstructionIndex != -1 && startInstructionIndex < cb.getCode().size()) {
                this.startInstruction = (Instruction)cb.getCode().get(startInstructionIndex);
            }
        }
        return this.startInstruction;
    }

    public void setStartInstruction(Instruction newStartInstruction) {
        Instruction oldStartInstruction = this.startInstruction;
        this.startInstruction = newStartInstruction;
        this.startInstructionIndex = -1;
        this.slot = -1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldStartInstruction, (Object)this.startInstruction));
        }
    }

    public Instruction getEndInstruction() {
        if (this.endInstruction == null) {
            CodeBlock cb = this.getOwningBlock();
            int endInstructionIndex = this.getEndInstructionIndex();
            if (cb != null && endInstructionIndex != -1 && endInstructionIndex < cb.getCode().size()) {
                this.endInstruction = (Instruction)cb.getCode().get(endInstructionIndex);
            }
        }
        if (this.endInstruction != null && this.endInstruction.eIsProxy()) {
            InternalEObject oldEndInstruction = (InternalEObject)this.endInstruction;
            this.endInstruction = (Instruction)this.eResolveProxy(oldEndInstruction);
            if (this.endInstruction != oldEndInstruction && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldEndInstruction, (Object)this.endInstruction));
            }
        }
        return this.endInstruction;
    }

    public Instruction basicGetEndInstruction() {
        if (this.endInstruction == null) {
            CodeBlock cb = this.getOwningBlock();
            int endInstructionIndex = this.getEndInstructionIndex();
            if (cb != null && endInstructionIndex != -1 && endInstructionIndex < cb.getCode().size()) {
                this.endInstruction = (Instruction)cb.getCode().get(endInstructionIndex);
            }
        }
        return this.endInstruction;
    }

    public void setEndInstruction(Instruction newEndInstruction) {
        Instruction oldEndInstruction = this.endInstruction;
        this.endInstruction = newEndInstruction;
        this.endInstructionIndex = -1;
        this.slot = -1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldEndInstruction, (Object)this.endInstruction));
        }
    }

    public int getStartInstructionIndex() {
        CodeBlock cb;
        if (this.startInstructionIndex == -1 && (cb = this.getOwningBlock()) != null) {
            EList<Instruction> code = cb.getCode();
            if (this.startInstruction != null) {
                this.startInstructionIndex = cb.getCode().indexOf((Object)this.startInstruction);
                if (this.startInstructionIndex < 0) {
                    throw new IllegalArgumentException(String.format("Start instruction %s not found in code block %s", this.startInstruction, cb));
                }
            } else if (!code.isEmpty()) {
                this.startInstructionIndex = 0;
            }
        }
        return this.startInstructionIndex;
    }

    public void setStartInstructionIndex(int newStartInstructionIndex) {
        int oldStartInstructionIndex = this.startInstructionIndex;
        this.startInstructionIndex = newStartInstructionIndex;
        if (newStartInstructionIndex != -1) {
            this.startInstruction = null;
        }
        this.slot = -1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldStartInstructionIndex, this.startInstructionIndex));
        }
    }

    public int getEndInstructionIndex() {
        CodeBlock cb;
        if (this.endInstructionIndex == -1 && (cb = this.getOwningBlock()) != null) {
            EList<Instruction> code = cb.getCode();
            if (this.endInstruction != null) {
                this.endInstructionIndex = cb.getCode().indexOf((Object)this.endInstruction);
                if (this.endInstructionIndex < 0) {
                    throw new IllegalArgumentException(String.format("End instruction %s not found in code block %s", this.endInstruction, cb));
                }
            } else if (!code.isEmpty()) {
                this.endInstructionIndex = code.size() - 1;
            }
        }
        return this.endInstructionIndex;
    }

    public void setEndInstructionIndex(int newEndInstructionIndex) {
        int oldEndInstructionIndex = this.endInstructionIndex;
        this.endInstructionIndex = newEndInstructionIndex;
        if (newEndInstructionIndex != -1) {
            this.endInstruction = null;
        }
        this.slot = -1;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldEndInstructionIndex, this.endInstructionIndex));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetOwningBlock((CodeBlock)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return this.basicSetOwningBlock(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 5: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 4, CodeBlock.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getSlot();
            }
            case 5: {
                return this.getOwningBlock();
            }
            case 6: {
                if (resolve) {
                    return this.getStartInstruction();
                }
                return this.basicGetStartInstruction();
            }
            case 7: {
                if (resolve) {
                    return this.getEndInstruction();
                }
                return this.basicGetEndInstruction();
            }
            case 8: {
                return this.getStartInstructionIndex();
            }
            case 9: {
                return this.getEndInstructionIndex();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setSlot((Integer)newValue);
                return;
            }
            case 5: {
                this.setOwningBlock((CodeBlock)newValue);
                return;
            }
            case 6: {
                this.setStartInstruction((Instruction)newValue);
                return;
            }
            case 7: {
                this.setEndInstruction((Instruction)newValue);
                return;
            }
            case 8: {
                this.setStartInstructionIndex((Integer)newValue);
                return;
            }
            case 9: {
                this.setEndInstructionIndex((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setSlot(-1);
                return;
            }
            case 5: {
                this.setOwningBlock(null);
                return;
            }
            case 6: {
                this.setStartInstruction(null);
                return;
            }
            case 7: {
                this.setEndInstruction(null);
                return;
            }
            case 8: {
                this.setStartInstructionIndex(-1);
                return;
            }
            case 9: {
                this.setEndInstructionIndex(-1);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return this.getSlot() != -1;
            }
            case 5: {
                return this.getOwningBlock() != null;
            }
            case 6: {
                return this.startInstruction != null;
            }
            case 7: {
                return this.endInstruction != null;
            }
            case 8: {
                return this.getStartInstructionIndex() != -1;
            }
            case 9: {
                return this.getEndInstructionIndex() != -1;
            }
        }
        return super.eIsSet(featureID);
    }

    public CodeBlock getOwningBlock() {
        if (this.eContainerFeatureID() != 5) {
            return null;
        }
        return (CodeBlock)this.eInternalContainer();
    }

    public NotificationChain basicSetOwningBlock(CodeBlock newOwningBlock, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newOwningBlock, 5, msgs);
        return msgs;
    }

    public void setOwningBlock(CodeBlock newOwningBlock) {
        if (newOwningBlock != this.eInternalContainer() || this.eContainerFeatureID() != 5 && newOwningBlock != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newOwningBlock)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newOwningBlock != null) {
                msgs = ((InternalEObject)newOwningBlock).eInverseAdd((InternalEObject)this, 4, CodeBlock.class, msgs);
            }
            if ((msgs = this.basicSetOwningBlock(newOwningBlock, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newOwningBlock, (Object)newOwningBlock));
        }
    }

    public String toString() {
        return super.toString();
    }
}

