/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.color;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;
import org.eclipse.jface.util.Geometry;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.color.DocumentColorProvider;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ColorInformationMining
extends LineContentCodeMining {
    private final RGBA rgba;
    private final DocumentColorProvider colorProvider;

    public ColorInformationMining(ColorInformation colorInformation, @NonNull IDocument document, TextDocumentIdentifier textDocumentIdentifier, CompletableFuture<LanguageServer> languageServer, DocumentColorProvider colorProvider) throws BadLocationException {
        super(ColorInformationMining.toPosition(colorInformation.getRange(), document), (ICodeMiningProvider)colorProvider, (Consumer)new UpdateColorWithDialog(textDocumentIdentifier, colorInformation, languageServer, document));
        this.rgba = LSPEclipseUtils.toRGBA(colorInformation.getColor());
        this.colorProvider = colorProvider;
        super.setLabel(" ");
    }

    public Point draw(GC gc, StyledText textWidget, Color color, int x, int y) {
        FontMetrics fontMetrics = gc.getFontMetrics();
        int size = ColorInformationMining.getSquareSize(fontMetrics);
        Rectangle rect = new Rectangle(x += fontMetrics.getLeading(), y += fontMetrics.getDescent(), size, size);
        gc.setBackground(this.colorProvider.getColor(this.rgba, textWidget.getDisplay()));
        gc.fillRectangle(rect);
        gc.setForeground(textWidget.getForeground());
        gc.drawRectangle(rect);
        return new Point(ColorInformationMining.getSquareWidth(fontMetrics), size);
    }

    private static int getSquareSize(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() - 2 * fontMetrics.getDescent();
    }

    private static int getSquareWidth(FontMetrics fontMetrics) {
        int width = (int)fontMetrics.getAverageCharacterWidth() + ColorInformationMining.getSquareSize(fontMetrics);
        return width;
    }

    private static Position toPosition(Range range, IDocument document) throws BadLocationException {
        int start = LSPEclipseUtils.toOffset(range.getStart(), document);
        int end = LSPEclipseUtils.toOffset(range.getEnd(), document);
        return new Position(start, end - start);
    }

    private static class UpdateColorWithDialog
    implements Consumer<MouseEvent> {
        private final TextDocumentIdentifier textDocumentIdentifier;
        private final ColorInformation colorInformation;
        private final CompletableFuture<LanguageServer> languageServer;
        private final IDocument document;

        public UpdateColorWithDialog(TextDocumentIdentifier textDocumentIdentifier, ColorInformation colorInformation, CompletableFuture<LanguageServer> languageServer, IDocument document) {
            this.textDocumentIdentifier = textDocumentIdentifier;
            this.colorInformation = colorInformation;
            this.languageServer = languageServer;
            this.document = document;
        }

        @Override
        public void accept(MouseEvent event) {
            StyledText styledText = (StyledText)event.widget;
            Shell shell = new Shell(styledText.getDisplay());
            Rectangle location = Geometry.toDisplay((Control)styledText, (Rectangle)new Rectangle(event.x, event.y, 1, 1));
            shell.setLocation(location.x, location.y);
            ColorDialog dialog = new ColorDialog(shell);
            dialog.setRGB(LSPEclipseUtils.toRGBA((org.eclipse.lsp4j.Color)this.colorInformation.getColor()).rgb);
            RGB rgb = dialog.open();
            if (rgb != null) {
                ColorPresentationParams params = new ColorPresentationParams(this.textDocumentIdentifier, LSPEclipseUtils.toColor(rgb), this.colorInformation.getRange());
                this.languageServer.thenCompose(ls -> ls.getTextDocumentService().colorPresentation(params).thenAccept(presentations -> {
                    if (presentations.isEmpty()) {
                        return;
                    }
                    try {
                        TextEdit textEdit = ((ColorPresentation)presentations.get(0)).getTextEdit();
                        LSPEclipseUtils.applyEdit(textEdit, this.document);
                    }
                    catch (BadLocationException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }));
            }
        }
    }
}

