/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

public class ContainerFileProxy {
    private final String path;
    private final String name;
    private final String link;
    private final boolean isFolder;
    private final boolean isLink;

    public ContainerFileProxy(String directory, String name, boolean isFolder) {
        this.path = String.valueOf(directory) + (directory.equals("/") ? "" : "/") + name;
        this.name = name;
        this.isFolder = isFolder;
        this.isLink = false;
        this.link = this.path;
    }

    public ContainerFileProxy(String directory, String name, boolean isFolder, boolean isLink, String link) {
        this.path = String.valueOf(directory) + (directory.equals("/") ? "" : "/") + name;
        this.name = name;
        this.isFolder = isFolder;
        this.isLink = isLink;
        this.link = link == null ? this.path : link;
    }

    public String getFullPath() {
        return this.path;
    }

    public String getLabel() {
        if (this.name.isEmpty()) {
            return "/";
        }
        return this.name;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public String getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getFullPath();
    }
}

