/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.preferences;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.ui.preferences.AbstractScriptEditorColoringConfigurationBlock;
import org.eclipse.dltk.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ldt.ui.internal.Activator;
import org.eclipse.ldt.ui.internal.editor.templates.SimpleLuaSourceViewerConfiguration;
import org.eclipse.ldt.ui.internal.editor.text.LuaTextTools;
import org.eclipse.ldt.ui.internal.preferences.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Version;

public class LuaEditorColoringConfigurationBlock
extends AbstractScriptEditorColoringConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final String PREVIEW_FILE_NAME = "sample/formatter.lua";
    private static final String[][] SYNTAX_COLOR_LIST_MODEL = new String[][]{{PreferencesMessages.DLTKEditorPreferencePage_singleLineComment, "DLTK_single_line_comment", sCommentsCategory}, {Messages.LuaEditorColoringConfigurationBlock_multiLineComment, "DLTK_multi_line_comment", sCommentsCategory}, {PreferencesMessages.DLTKEditorPreferencePage_keywords, "DLTK_keyword", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_strings, "DLTK_string", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_others, "DLTK_default", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_numbers, "DLTK_number", sCoreCategory}, {Messages.LuaEditorColoringConfigurationBlock_localVariable, "variable.local", sCoreCategory}, {Messages.LuaEditorColoringConfigurationBlock_globalVariable, "variable.global", sCoreCategory}, {PreferencesMessages.DLTKEditorPreferencePage_CommentTaskTags, "DLTK_comment_task_tag", sCommentsCategory}, {Messages.LuaEditorColoringConfigurationBlock_luaDocumentor, "DLTK_doc", sDocumentationCategory}, {Messages.LuaEditorColoringConfigurationBlock_luaDocumentorTags, "luadoc.tags", sDocumentationCategory}};

    public LuaEditorColoringConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
    }

    protected String[][] getSyntaxColorListModel() {
        return SYNTAX_COLOR_LIST_MODEL;
    }

    protected ProjectionViewer createPreviewViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
        return new ScriptSourceViewer(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
    }

    protected ScriptSourceViewerConfiguration createSimpleSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, boolean configureFormatter) {
        return new SimpleLuaSourceViewerConfiguration(colorManager, preferenceStore, editor, "__lua_partitioning", configureFormatter);
    }

    protected void setDocumentPartitioning(IDocument document) {
        IDocumentSetupParticipant participant = new IDocumentSetupParticipant(){

            public void setup(IDocument document) {
                LuaTextTools tools = Activator.getDefault().getTextTools();
                tools.setupDocumentPartitioner(document, "__lua_partitioning");
            }
        };
        participant.setup(document);
    }

    protected InputStream getPreviewContentReader() {
        try {
            URL fileURL = Activator.getDefault().getBundle().getEntry(PREVIEW_FILE_NAME);
            if (fileURL != null) {
                return fileURL.openStream();
            }
        }
        catch (IOException e) {
            Activator.logError("Unable to generate code preview", e);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    protected ScriptTextTools getTextTools() {
        return Activator.getDefault().getTextTools();
    }

    protected String getNatureId() {
        Version dltkVersion = Platform.getBundle((String)"org.eclipse.dltk.ui").getVersion();
        if (dltkVersion.getMajor() >= 4) {
            return "org.eclipse.ldt.nature";
        }
        return null;
    }
}

