/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.editor.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ldt.core.grammar.IGrammar;
import org.eclipse.ldt.core.internal.grammar.LuaGrammarManager;
import org.eclipse.ldt.ui.internal.Activator;

public class LuaCodeScanner
extends AbstractScriptScanner {
    private static String[] fgTokenProperties = new String[]{"DLTK_number", "DLTK_default", "DLTK_keyword"};

    public LuaCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        Token keyword = this.getToken("DLTK_keyword");
        Token numbers = this.getToken("DLTK_number");
        Token other = this.getToken("DLTK_default");
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new LuaWhitespaceDetector()));
        String grammarName = this.getPreferenceStore().getString("Grammar__default_id");
        if (grammarName == null || grammarName.isEmpty()) {
            grammarName = "lua-5.1";
        }
        IGrammar grammar = null;
        try {
            grammar = LuaGrammarManager.getAvailableGrammar((String)grammarName);
            if (grammar == null) {
                Activator.logWarning(String.format("Unable to find grammar for %s", grammarName));
            }
        }
        catch (CoreException e) {
            Activator.logWarning(String.format("Unable to find grammar for %s", grammarName), e);
        }
        WordRule wordRule = new WordRule((IWordDetector)new LuaWordDetector(), (IToken)other);
        if (grammar != null) {
            for (String word : grammar.getKeywords()) {
                wordRule.addWord(word, (IToken)keyword);
            }
        }
        rules.add((IRule)wordRule);
        LuaNumberRule numberRule = new LuaNumberRule((IToken)numbers);
        rules.add((IRule)numberRule);
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return "Grammar__default_id".equals(event.getProperty()) || super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if ("Grammar__default_id".equals(event.getProperty())) {
            this.initialize();
        } else {
            super.adaptToPreferenceChange(event);
        }
    }

    public static class LuaNumberRule
    extends NumberRule {
        public LuaNumberRule(IToken token) {
            super(token);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            if (LuaNumberRule.eatNumber(scanner) > 0) {
                return this.fToken;
            }
            return Token.UNDEFINED;
        }

        private static int eatExponential(ICharacterScanner scanner) {
            char current = (char)scanner.read();
            if (current == 'e' || current == 'E') {
                if (LuaNumberRule.followedByDigit(scanner)) {
                    return LuaNumberRule.eatDecimalDigits(scanner) + 1;
                }
                current = (char)scanner.read();
                if ((current == '-' || current == '+') && LuaNumberRule.followedByDigit(scanner)) {
                    return LuaNumberRule.eatDecimalDigits(scanner) + 2;
                }
                scanner.unread();
            }
            scanner.unread();
            return 0;
        }

        private static int eatDecimalDigitsFromDot(ICharacterScanner scanner) {
            if (scanner.read() == 46) {
                return LuaNumberRule.eatDecimalDigits(scanner) + 1;
            }
            scanner.unread();
            return 0;
        }

        private static int eatDecimalDigits(ICharacterScanner scanner) {
            int digits = 0;
            while (Character.isDigit((char)scanner.read())) {
                ++digits;
            }
            scanner.unread();
            return digits;
        }

        private static int eatNumber(ICharacterScanner scanner) {
            char current = (char)scanner.read();
            switch (current) {
                case '.': {
                    int result = LuaNumberRule.eatDecimalDigits(scanner);
                    if (result <= 0) break;
                    return result + LuaNumberRule.eatExponential(scanner) + 1;
                }
                case '0': {
                    if (LuaNumberRule.followedByChar(scanner, 'x') || LuaNumberRule.followedByChar(scanner, 'X')) {
                        int result = LuaNumberRule.eatHexaecimalDigits(scanner);
                        if (result <= 0) break;
                        return result + LuaNumberRule.eatExponential(scanner) + 1;
                    }
                    return LuaNumberRule.eatDecimalDigits(scanner) + LuaNumberRule.eatDecimalDigitsFromDot(scanner) + LuaNumberRule.eatExponential(scanner) + 1;
                }
                default: {
                    if (!Character.isDigit(current)) break;
                    return LuaNumberRule.eatDecimalDigits(scanner) + LuaNumberRule.eatDecimalDigitsFromDot(scanner) + LuaNumberRule.eatExponential(scanner) + 1;
                }
            }
            scanner.unread();
            return 0;
        }

        /*
         * Unable to fully structure code
         */
        private static int eatHexaecimalDigits(ICharacterScanner scanner) {
            block1: {
                digits = 0;
                current = (char)scanner.read();
                if (current != 'x' && current != 'X' || !LuaNumberRule.followedByHexadecimal(scanner)) break block1;
                ++digits;
                if (true) ** GOTO lbl11
            }
            scanner.unread();
            return digits;
            do {
                ++digits;
lbl11:
                // 2 sources

            } while (Character.digit((char)scanner.read(), 16) != -1);
            scanner.unread();
            return digits;
        }

        private static boolean followedByChar(ICharacterScanner scanner, char character) {
            boolean result = character == (char)scanner.read();
            scanner.unread();
            return result;
        }

        private static boolean followedByDigit(ICharacterScanner scanner) {
            boolean result = Character.isDigit((char)scanner.read());
            scanner.unread();
            return result;
        }

        private static boolean followedByHexadecimal(ICharacterScanner scanner) {
            boolean result = Character.digit((char)scanner.read(), 16) != -1;
            scanner.unread();
            return result;
        }
    }

    public static class LuaWhitespaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }

    public static class LuaWordDetector
    implements IWordDetector {
        public boolean isWordPart(char character) {
            return Character.isJavaIdentifierPart(character);
        }

        public boolean isWordStart(char character) {
            return Character.isJavaIdentifierStart(character);
        }
    }
}

