/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigEditPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NewLaunchConfigTypePage2
extends WizardPage {
    private final NewLaunchConfigEditPage editPage;
    private Table modeTable;
    private Table typeTable;

    public NewLaunchConfigTypePage2(NewLaunchConfigEditPage editPage) {
        super(NewLaunchConfigTypePage2.class.getName());
        this.editPage = editPage;
        this.setTitle(Messages.NewLaunchConfigTypePage_1);
        this.setDescription(Messages.NewLaunchConfigTypePage_2);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        Group modeGroup = new Group(comp, 0);
        modeGroup.setText(Messages.NewLaunchConfigTypePage2_Mode);
        modeGroup.setLayout((Layout)new GridLayout());
        modeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.modeTable = new Table((Composite)modeGroup, 2052);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 100;
        this.modeTable.setLayoutData((Object)data);
        this.modeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLaunchConfigTypePage2.this.modeChanged();
            }
        });
        Group typeGroup = new Group(comp, 0);
        typeGroup.setText(Messages.NewLaunchConfigTypePage2_Type);
        typeGroup.setLayout((Layout)new GridLayout());
        typeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeTable = new Table((Composite)typeGroup, 2052);
        this.typeTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewLaunchConfigTypePage2.this.typeChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                NewLaunchConfigTypePage2.this.getContainer().showPage(NewLaunchConfigTypePage2.this.getNextPage());
            }
        });
        this.populateMode();
        this.setControl((Control)comp);
    }

    private void populateMode() {
        ILaunchGroup group;
        int select = -1;
        ILaunchGroup[] iLaunchGroupArray = DebugUITools.getLaunchGroups();
        int n = iLaunchGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            group = iLaunchGroupArray[n2];
            if (group.getMode().equals("run") && this.createModeItem(this.modeTable, group)) {
                ++select;
            }
            ++n2;
        }
        iLaunchGroupArray = DebugUITools.getLaunchGroups();
        n = iLaunchGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            group = iLaunchGroupArray[n2];
            if (group.getMode().equals("debug") && this.createModeItem(this.modeTable, group)) {
                ++select;
            }
            ++n2;
        }
        iLaunchGroupArray = DebugUITools.getLaunchGroups();
        n = iLaunchGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            group = iLaunchGroupArray[n2];
            if (!group.getMode().equals("run") && !group.getMode().equals("debug")) {
                this.createModeItem(this.modeTable, group);
            }
            ++n2;
        }
        if (select >= 0) {
            this.modeTable.select(select);
            this.modeChanged();
        } else if (this.modeTable.getItemCount() > 0) {
            this.modeTable.select(0);
            this.modeChanged();
        } else {
            this.setPageComplete(false);
        }
    }

    private boolean createModeItem(Table table, ILaunchGroup group) {
        if (group.getCategory() != null || !group.isPublic()) {
            return false;
        }
        TableItem item = new TableItem(table, 0);
        item.setText(group.getLabel().replace("&", ""));
        ImageDescriptor imageDesc = group.getImageDescriptor();
        if (imageDesc != null) {
            item.setImage(imageDesc.createImage());
        }
        item.setData((Object)group);
        return true;
    }

    private void modeChanged() {
        TableItem[] selection = this.modeTable.getSelection();
        if (selection.length == 0) {
            this.editPage.setLaunchGroup(null);
            this.setPageComplete(false);
            return;
        }
        ILaunchGroup group = (ILaunchGroup)selection[0].getData();
        this.editPage.setLaunchGroup(group);
        ILaunchConfigurationType[] types = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        Arrays.sort(types, new Comparator<ILaunchConfigurationType>(){

            @Override
            public int compare(ILaunchConfigurationType type0, ILaunchConfigurationType type1) {
                int comp = type0.getPluginIdentifier().compareTo(type1.getPluginIdentifier());
                if (comp != 0) {
                    return comp;
                }
                return type0.getName().compareTo(type1.getName());
            }
        });
        this.typeTable.removeAll();
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType type = iLaunchConfigurationTypeArray[n2];
            if (type.isPublic() && type.getCategory() == null && type.supportsMode(group.getMode())) {
                TableItem item = new TableItem(this.typeTable, 0);
                item.setText(type.getName());
                ImageDescriptor imageDesc = DebugUITools.getDefaultImageDescriptor((Object)type);
                if (imageDesc != null) {
                    item.setImage(imageDesc.createImage());
                }
                item.setData((Object)type);
            }
            ++n2;
        }
        if (this.typeTable.getItemCount() > 0) {
            this.typeTable.select(0);
            this.typeChanged();
        } else {
            this.setPageComplete(false);
        }
    }

    private void typeChanged() {
        TableItem[] selection = this.typeTable.getSelection();
        if (selection.length == 0) {
            this.editPage.setLaunchConfigType(null);
            this.setPageComplete(false);
            return;
        }
        ILaunchConfigurationType type = (ILaunchConfigurationType)selection[0].getData();
        this.editPage.setLaunchConfigType(type);
        this.setPageComplete(true);
    }
}

