/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jwt.meta.model.core.Comment;
import org.eclipse.jwt.meta.model.core.CoreFactory;
import org.eclipse.jwt.meta.model.core.CorePackage;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.core.provider.CoreItemProviderAdapterFactory;
import org.eclipse.jwt.meta.model.data.DataFactory;
import org.eclipse.jwt.meta.model.data.DataType;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ProcessesFactory;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.meta.model.processes.provider.ProcessesItemProviderAdapterFactory;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.commands.template.ImportTemplateCommand;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.wizards.template.TemplateFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class WizardHelper {
    static final Logger logger = Logger.getLogger(WizardHelper.class);

    public static GridData createData(int verticalAlignment, int horizontalAlignment, boolean grabExcessVerticalSpace, boolean grabExcessHorizontalSpace, int verticalSpan, int horizontalSpan) {
        GridData data = new GridData();
        if (verticalAlignment != -1) {
            data.verticalAlignment = verticalAlignment;
        }
        if (horizontalAlignment != -1) {
            data.horizontalAlignment = horizontalAlignment;
        }
        if (horizontalSpan != -1) {
            data.horizontalSpan = horizontalSpan;
        }
        if (horizontalSpan != -1) {
            data.verticalSpan = verticalSpan;
        }
        data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        return data;
    }

    public static List createListBox(Composite parent) {
        Label listboxLabel = new Label(parent, 131072);
        listboxLabel.setText(PluginProperties.wizards_TemplateSelected_label);
        listboxLabel.setLayoutData((Object)WizardHelper.createData(4, 4, false, true, -1, 10));
        listboxLabel.setAlignment(16384);
        List listbox = new List(parent, 4);
        listbox.setLayoutData((Object)WizardHelper.createData(4, 4, true, true, -1, 10));
        return listbox;
    }

    public static Button createAddButton(Composite parent) {
        Button addButton = new Button(parent, 8);
        addButton.setText(PluginProperties.wizards_Add_label);
        addButton.setEnabled(false);
        addButton.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, -1, 1));
        return addButton;
    }

    public static Button createRemoveButton(Composite parent) {
        Button removeButton = new Button(parent, 8);
        removeButton.setText(PluginProperties.wizards_Remove_label);
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, -1, 1));
        return removeButton;
    }

    public static Button createRemoveAllButton(Composite parent) {
        Button removeallButton = new Button(parent, 8);
        removeallButton.setText(PluginProperties.wizards_RemoveAll_label);
        removeallButton.setEnabled(false);
        removeallButton.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, -1, 8));
        return removeallButton;
    }

    public static Text createTemplateField(Composite parent) {
        Label templateLabel = new Label(parent, 131072);
        templateLabel.setText("Template:");
        templateLabel.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, -1, -1));
        Text templateField = new Text(parent, 2048);
        templateField.setLayoutData((Object)WizardHelper.createData(-1, 4, false, true, -1, 8));
        return templateField;
    }

    public static Button createBrowseButton(Composite parent) {
        Button browseButton = new Button(parent, 8);
        browseButton.setText(PluginProperties.wizards_Browse_label);
        browseButton.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, -1, -1));
        return browseButton;
    }

    public static Tree createPackageTree(Composite parent) {
        Label packageLabel = new Label(parent, 131072);
        packageLabel.setText(PluginProperties.wizards_TemplateContents_label);
        packageLabel.setLayoutData((Object)WizardHelper.createData(4, 4, false, true, -1, 10));
        packageLabel.setAlignment(16384);
        Tree packageTree = new Tree(parent, 4);
        packageTree.setLayoutData((Object)WizardHelper.createData(4, 4, true, true, 25, 10));
        return packageTree;
    }

    public static TreeViewer createPackageViewer(AdapterFactory adapterfactory, Tree packageTree) {
        TreeViewer packageViewer = new TreeViewer(packageTree);
        if (adapterfactory == null) {
            ComposedAdapterFactory caf = new ComposedAdapterFactory();
            caf.addAdapterFactory((AdapterFactory)new CoreItemProviderAdapterFactory());
            caf.addAdapterFactory((AdapterFactory)new ProcessesItemProviderAdapterFactory());
            caf.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            packageViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)caf));
            packageViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)caf));
        } else {
            packageViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(adapterfactory));
            packageViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(adapterfactory));
        }
        packageViewer.addFilter((ViewerFilter)new TemplateFilter());
        return packageViewer;
    }

    public static void addListBox(Text templatefield, List list) {
        int index = -1;
        String templateName = URI.createFileURI((String)templatefield.getText()).toFileString();
        if (!templateName.endsWith(WEEditor.getTemplateExtension())) {
            templateName = String.valueOf(templateName) + "." + WEEditor.getTemplateExtension();
        }
        int i = 0;
        while (i < list.getItems().length) {
            if (templateName.equals(list.getItems()[i].toString())) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            list.add(templateName);
            index = list.getItems().length - 1;
        }
        list.select(index);
        list.notifyListeners(13, null);
        templatefield.setText("");
    }

    public static void removeListBoxItem(List list) {
        int index = list.getSelectionIndex();
        if (index != -1) {
            list.remove(index);
            if (index - 1 != -1) {
                list.select(index - 1);
            } else if (list.getItems().length > 0) {
                list.select(0);
            }
        }
        list.notifyListeners(13, null);
    }

    public static void removeAllListBoxItems(List list) {
        list.removeAll();
        list.notifyListeners(13, null);
    }

    protected static void clearModelView(TreeViewer packageViewer, ResourceSet resourceSet) {
        resourceSet = null;
        packageViewer.setInput(null);
    }

    public static String showModelInBox(List listbox, TreeViewer packageViewer, ResourceSet resourceSet, String loadedModedFile, String modelError) {
        String modelFile = "";
        if (listbox.getSelectionIndex() != -1) {
            modelFile = listbox.getItem(listbox.getSelectionIndex());
        }
        if (listbox.getSelectionIndex() == -1 || modelError.equals(modelFile)) {
            WizardHelper.clearModelView(packageViewer, resourceSet);
            return "";
        }
        if (modelFile.equals(loadedModedFile)) {
            return loadedModedFile;
        }
        loadedModedFile = modelFile;
        URI fileUri = URI.createFileURI((String)modelFile);
        resourceSet = null;
        resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(WEEditor.getTemplateExtension(), new XMIResourceFactoryImpl());
        try {
            XMIResource resource = (XMIResource)resourceSet.getResource(fileUri, true);
            for (Object resourceC : resource.getContents()) {
                if (!(resourceC instanceof Package)) continue;
                packageViewer.setInput(resourceC);
                break;
            }
            packageViewer.expandToLevel(2);
        }
        catch (Exception e) {
            logger.warning("Error loading file `" + modelFile + "'.", e);
            listbox.setItem(listbox.getSelectionIndex(), modelError);
            WizardHelper.clearModelView(packageViewer, resourceSet);
            return "";
        }
        return loadedModedFile;
    }

    public static EObject createResources(String packageName, String activityName, String authorName, String versionName, boolean standardPackages, ArrayList templates) {
        Model rootPackage = CoreFactory.eINSTANCE.createModel();
        rootPackage.setName(packageName);
        rootPackage.setAuthor(authorName);
        rootPackage.setVersion(versionName);
        rootPackage.setFileversion(GeneralHelper.getWEVersion());
        if (standardPackages) {
            Package applicationPackage = CoreFactory.eINSTANCE.createPackage();
            applicationPackage.setName(PluginProperties.wizards_ModelWizardApplicationPackage_std);
            rootPackage.getSubpackages().add((Object)applicationPackage);
            if (!PluginProperties.wizards_ModelWizardApplicationComment_std.equals("")) {
                Comment applicationComment = CoreFactory.eINSTANCE.createComment();
                applicationComment.setText(PluginProperties.wizards_ModelWizardApplicationComment_std);
                applicationPackage.getOwnedComment().add((Object)applicationComment);
            }
            Package rolePackage = CoreFactory.eINSTANCE.createPackage();
            rolePackage.setName(PluginProperties.wizards_ModelWizardRolePackage_std);
            rootPackage.getSubpackages().add((Object)rolePackage);
            if (!PluginProperties.wizards_ModelWizardRoleComment_std.equals("")) {
                Comment roleComment = CoreFactory.eINSTANCE.createComment();
                roleComment.setText(PluginProperties.wizards_ModelWizardRoleComment_std);
                rolePackage.getOwnedComment().add((Object)roleComment);
            }
            Package dataPackage = CoreFactory.eINSTANCE.createPackage();
            dataPackage.setName(PluginProperties.wizards_ModelWizardDataPackage_std);
            rootPackage.getSubpackages().add((Object)dataPackage);
            if (!PluginProperties.wizards_ModelWizardDataComment_std.equals("")) {
                Comment dataComment = CoreFactory.eINSTANCE.createComment();
                dataComment.setText(PluginProperties.wizards_ModelWizardDataComment_std);
                dataPackage.getOwnedComment().add((Object)dataComment);
            }
            Package datatypesPackage = CoreFactory.eINSTANCE.createPackage();
            datatypesPackage.setName(PluginProperties.wizards_ModelWizardDatatypesPackage_std);
            rootPackage.getSubpackages().add((Object)datatypesPackage);
            datatypesPackage.setSuperpackage(dataPackage);
            DataFactory factory = DataFactory.eINSTANCE;
            DataType url = factory.createDataType();
            url.setName(PluginProperties.Datatypes_URL);
            url.setPackage(datatypesPackage);
            DataType dioParameter = factory.createDataType();
            dioParameter.setName(PluginProperties.Datatypes_dioParameter);
            dioParameter.setPackage(datatypesPackage);
            DataType qualifier = factory.createDataType();
            qualifier.setName(PluginProperties.Datatypes_qualifier);
            qualifier.setPackage(datatypesPackage);
            DataType searchquery = factory.createDataType();
            searchquery.setName(PluginProperties.Datatypes_searchquery);
            searchquery.setPackage(datatypesPackage);
            DataType filename = factory.createDataType();
            filename.setName(PluginProperties.Datatypes_filename);
            filename.setPackage(datatypesPackage);
            if (!PluginProperties.wizards_ModelWizardDatatypesComment_std.equals("")) {
                Comment datatypesComment = CoreFactory.eINSTANCE.createComment();
                datatypesComment.setText(PluginProperties.wizards_ModelWizardDatatypesComment_std);
                datatypesPackage.getOwnedComment().add((Object)datatypesComment);
            }
        }
        Activity rootActivity = ProcessesFactory.eINSTANCE.createActivity();
        rootPackage.getElements().add((Object)rootActivity);
        rootActivity.setName(activityName);
        if (!PluginProperties.wizards_ModelWizardActivityComment_std.equals("")) {
            Comment activityComment = CoreFactory.eINSTANCE.createComment();
            activityComment.setText(PluginProperties.wizards_ModelWizardActivityComment_std);
            rootActivity.getOwnedComment().add((Object)activityComment);
        }
        if (templates.size() != 0) {
            Iterator i = templates.iterator();
            while (i.hasNext()) {
                URI fileUri = URI.createFileURI((String)((String)i.next()));
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(WEEditor.getTemplateExtension(), new XMIResourceFactoryImpl());
                resourceSet.getPackageRegistry().put((Object)"org.eclipse.jwt/core", (Object)CorePackage.eINSTANCE);
                resourceSet.getPackageRegistry().put((Object)"org.eclipse.jwt/processes", (Object)ProcessesPackage.eINSTANCE);
                try {
                    if (!(resourceSet.getResource(fileUri, true).getContents().get(0) instanceof Package)) continue;
                    Package importpackage = (Package)resourceSet.getResource(fileUri, true).getContents().get(0);
                    new ImportTemplateCommand((Package)rootPackage, null, importpackage, null).execute();
                }
                catch (Exception e) {
                    logger.warning("Error importing file `" + fileUri.toFileString() + "'.", e);
                }
            }
        }
        return rootPackage;
    }

    public static void resizeDialog(Shell shell) {
        int workbenchWidth = Plugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().getBounds().width;
        int workbenchHeight = Plugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().getBounds().height;
        int workbenchX = Plugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().getBounds().x;
        int workbenchY = Plugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().getBounds().y;
        int newDialogHeight = Math.max(shell.getSize().y, 600);
        int newDialogWidth = Math.max(shell.getSize().x, 520);
        int newDialogX = workbenchWidth / 2 + workbenchX - newDialogWidth / 2;
        int newDialogY = workbenchHeight / 2 + workbenchY - newDialogHeight / 2;
        shell.setBounds(newDialogX, newDialogY, newDialogWidth, newDialogHeight);
    }
}

