/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.we.figures.IImageFactory;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeImageFactory
implements IImageFactory {
    Collection<IImageFactory> collection = new ArrayList<IImageFactory>();

    @Override
    public ImageDescriptor createImageDescriptor(String path) {
        for (IImageFactory imageFactory : this.collection) {
            ImageDescriptor result = imageFactory.createImageDescriptor(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public ImageDescriptor createModelTypeImageDescriptor(Object model) {
        for (IImageFactory imageFactory : this.collection) {
            ImageDescriptor result = imageFactory.createModelTypeImageDescriptor(model);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Image getImage(ImageDescriptor imageDescriptor) {
        for (IImageFactory imageFactory : this.collection) {
            Image result = imageFactory.getImage(imageDescriptor);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Image getImage(ImageDescriptor imageDescriptor, Dimension size) {
        for (IImageFactory imageFactory : this.collection) {
            Image result = imageFactory.getImage(imageDescriptor, size);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void addImageFactory(IImageFactory imageFactory) {
        if (imageFactory == null) {
            throw new IllegalArgumentException("Error: the argument is null!");
        }
        this.collection.add(imageFactory);
    }

    public void removeImageFactory(IImageFactory imageFactory) {
        if (imageFactory != null) {
            if (this.collection.contains(imageFactory)) {
                this.collection.remove(imageFactory);
            }
        } else {
            throw new IllegalArgumentException("Error: the argument is null!");
        }
    }

    public void setImageFactory(Collection<IImageFactory> colImageFactory) {
        if (colImageFactory == null) {
            throw new IllegalArgumentException("Error: the argument is null!");
        }
        this.collection = colImageFactory;
    }
}

