/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.actions.managed.recentfiles;

import java.io.Serializable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class RecentFileAction
extends Action
implements Serializable {
    private static final long serialVersionUID = -1469147461918518088L;
    String filename = "";

    public RecentFileAction(String filename, String id) {
        this.setFilename(filename);
        super.setId(id);
        super.setText(this.filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = RecentFileAction.makeFilename(filename);
        super.setText(this.filename);
    }

    public static String makeFilename(String filename) {
        return filename.replace("file:/", "");
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        if (this.filename.equals("")) {
            return;
        }
        try {
            URI fileURI = null;
            try {
                fileURI = URI.createFileURI((String)this.filename);
            }
            catch (Exception exception) {}
            if (fileURI == null) {
                try {
                    fileURI = URI.createURI((String)this.filename);
                }
                catch (Exception exception) {}
            }
            if (fileURI != null) {
                Plugin.openEditor(PlatformUI.getWorkbench(), fileURI);
            } else {
                MessageDialog.openError(null, (String)PluginProperties.editor_ErrorMessage_title, (String)NLS.bind((String)PluginProperties.editor_ErrorLoadingFile_message, (Object)this.filename));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

