/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;

public class HighLighter {
    private static AutServerLogger log = new AutServerLogger(HighLighter.class);
    private Color m_defaultBorderColor;
    private Color m_borderColor;

    public HighLighter() {
        this.m_borderColor = this.m_defaultBorderColor = new Color(20, 170, 140);
    }

    public void highLight(Component component, Color border) {
        this.m_borderColor = border != null ? border : this.m_defaultBorderColor;
        if (component instanceof JComponent) {
            this.paintBorder((JComponent)component);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("highLight() called for a component which is not a JComponent: " + component.getClass().getName()));
        }
    }

    public void lowLight(Component component) {
        component.repaint();
    }

    private void paintBorder(JComponent component) {
        Component glassPane = this.getGlassPane(component);
        if (glassPane == null) {
            log.warn((Object)("no glass pane for component: " + component.toString()));
            if (log.isInfoEnabled()) {
                log.warn((Object)("no glass pane for component: " + component.toString()));
            }
            return;
        }
        Graphics graphics = glassPane.getGraphics();
        if (graphics == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("paintBorder() called for a currently not displayable component: " + component.toString()));
            }
            return;
        }
        Color oldColor = graphics.getColor();
        graphics.setColor(this.m_borderColor);
        Rectangle bounds = SwingUtilities.convertRectangle(component, component.getVisibleRect(), glassPane);
        graphics.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        graphics.setColor(oldColor);
    }

    private Component getGlassPane(JComponent component) {
        Component result = null;
        JRootPane rootPane = component.getRootPane();
        if (rootPane != null) {
            result = rootPane.getGlassPane();
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("no root pane for " + component.getName()));
        }
        return result;
    }
}

