/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.util.ArrayList;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractUITester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuItemComponent;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.MenuUtilBase;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;

public abstract class AbstractMenuTester
extends AbstractUITester {
    private static AutServerLogger log = new AutServerLogger(AbstractMenuTester.class);

    public static AutServerLogger getLog() {
        return log;
    }

    public IMenuComponent getMenuAdapter() {
        return (IMenuComponent)this.getComponent();
    }

    public void verifyEnabled(String menuItem, String operator, boolean enabled, int timeout) {
        this.verifyEnabled(MenuUtilBase.splitPath(menuItem), operator, enabled, timeout);
    }

    public void verifyEnabled(final String[] menuItem, final String operator, final boolean enabled, int timeout) {
        this.checkPathLength(menuItem.length);
        CheckWithTimeoutQueuer.invokeAndWait("verifyEnabled", timeout, new Runnable(){

            public void run() {
                IMenuItemComponent item = AbstractMenuTester.this.navigateToMenuItem(AbstractMenuTester.this.getAndCheckMenu(), menuItem, operator);
                try {
                    AbstractMenuTester.this.checkIsNull(item);
                    Verifier.equals(enabled, item.isEnabled());
                }
                finally {
                    AbstractMenuTester.this.closeMenu(AbstractMenuTester.this.getAndCheckMenu(), menuItem, operator);
                }
            }
        });
    }

    private void checkIsNull(IMenuItemComponent item) {
        if (item.getRealComponent() == null) {
            this.throwMenuItemNotFound();
        }
    }

    public void verifyEnabledByIndexpath(String menuItem, boolean enabled, int timeout) {
        this.verifyEnabledByIndexpath(MenuUtilBase.splitIndexPath(menuItem), enabled, timeout);
    }

    public void verifyEnabledByIndexpath(final int[] menuItem, final boolean enabled, int timeout) {
        this.checkPathLength(menuItem.length);
        CheckWithTimeoutQueuer.invokeAndWait("verifyEnabledByIndexpath", timeout, new Runnable(){

            public void run() {
                IMenuItemComponent item = AbstractMenuTester.this.navigateToMenuItem(AbstractMenuTester.this.getAndCheckMenu(), menuItem);
                try {
                    AbstractMenuTester.this.checkIsNull(item);
                    Verifier.equals(enabled, item.isEnabled());
                }
                finally {
                    AbstractMenuTester.this.closeMenu(AbstractMenuTester.this.getAndCheckMenu(), menuItem);
                }
            }
        });
    }

    public void verifyExists(String menuItem, String operator, boolean exists, int timeout) {
        this.verifyExists(MenuUtilBase.splitPath(menuItem), operator, exists, timeout);
    }

    public void verifyExists(final String[] menuItem, final String operator, final boolean exists, int timeout) {
        this.checkPathLength(menuItem.length);
        CheckWithTimeoutQueuer.invokeAndWait("verifyExists", timeout, new Runnable(){

            public void run() {
                IMenuItemComponent item = AbstractMenuTester.this.navigateToMenuItem(AbstractMenuTester.this.getAndCheckMenu(), menuItem, operator);
                try {
                    Verifier.equals(exists, item.isExisting());
                }
                finally {
                    AbstractMenuTester.this.closeMenu(AbstractMenuTester.this.getAndCheckMenu(), menuItem, operator);
                }
            }
        });
    }

    public void verifyExistsByIndexpath(String menuItem, boolean exists, int timeout) {
        this.verifyExistsByIndexpath(MenuUtilBase.splitIndexPath(menuItem), exists, timeout);
    }

    public void verifyExistsByIndexpath(final int[] menuItem, final boolean exists, int timeout) {
        this.checkPathLength(menuItem.length);
        CheckWithTimeoutQueuer.invokeAndWait("verifyExistsByIndexpath", timeout, new Runnable(){

            public void run() {
                IMenuItemComponent item = AbstractMenuTester.this.navigateToMenuItem(AbstractMenuTester.this.getAndCheckMenu(), menuItem);
                try {
                    Verifier.equals(exists, item.isExisting());
                }
                finally {
                    AbstractMenuTester.this.closeMenu(AbstractMenuTester.this.getAndCheckMenu(), menuItem);
                }
            }
        });
    }

    public void verifySelected(String menuItem, String operator, boolean selected, int timeout) {
        this.verifySelected(MenuUtilBase.splitPath(menuItem), operator, selected, timeout);
    }

    public void verifySelected(final String[] menuItem, final String operator, final boolean selected, int timeout) {
        this.checkPathLength(menuItem.length);
        CheckWithTimeoutQueuer.invokeAndWait("verifySelected", timeout, new Runnable(){

            public void run() {
                IMenuItemComponent item = AbstractMenuTester.this.navigateToMenuItem(AbstractMenuTester.this.getAndCheckMenu(), menuItem, operator);
                try {
                    AbstractMenuTester.this.checkIsNull(item);
                    Verifier.equals(selected, item.isSelected());
                }
                finally {
                    AbstractMenuTester.this.closeMenu(AbstractMenuTester.this.getAndCheckMenu(), menuItem, operator);
                }
            }
        });
    }

    public void verifySelectedByIndexpath(String menuItem, boolean selected, int timeout) {
        this.verifySelectedByIndexpath(MenuUtilBase.splitIndexPath(menuItem), selected, timeout);
    }

    public void verifySelectedByIndexpath(final int[] menuItem, final boolean selected, int timeout) {
        this.checkPathLength(menuItem.length);
        CheckWithTimeoutQueuer.invokeAndWait("verifySelectedByIndexpath", timeout, new Runnable(){

            public void run() {
                IMenuItemComponent item = AbstractMenuTester.this.navigateToMenuItem(AbstractMenuTester.this.getAndCheckMenu(), menuItem);
                try {
                    AbstractMenuTester.this.checkIsNull(item);
                    Verifier.equals(selected, item.isSelected());
                }
                finally {
                    AbstractMenuTester.this.closeMenu(AbstractMenuTester.this.getAndCheckMenu(), menuItem);
                }
            }
        });
    }

    public void selectMenuItemByIndexpath(String indexPath) {
        int[] indexItems = MenuUtilBase.splitIndexPath(indexPath);
        this.checkPathLength(indexItems.length);
        try {
            IMenuItemComponent item = this.navigateToMenuItem(this.getAndCheckMenu(), indexItems);
            this.checkIsNull(item);
            item.selectMenuItem();
            if (EnvironmentUtils.isMacOS() && item.isShowing()) {
                this.closeMenu(this.getAndCheckMenu(), indexItems);
            }
        }
        catch (StepExecutionException stepExecutionException) {
            block5: {
                try {
                    this.closeMenu(this.getAndCheckMenu(), indexItems);
                }
                catch (StepExecutionException stepExecutionException2) {
                    if (!AbstractMenuTester.getLog().isInfoEnabled()) break block5;
                    AbstractMenuTester.getLog().info("Tried to close a disabled or already closed menu.");
                }
            }
            this.throwMenuItemNotFound();
        }
    }

    public void selectMenuItem(String namePath, String operator) {
        String[] menuItems = MenuUtilBase.splitPath(namePath);
        if (menuItems.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        IMenuItemComponent item = this.navigateToMenuItem(this.getAndCheckMenu(), menuItems, operator);
        if (item == null || item.getRealComponent() == null) {
            try {
                this.closeMenu(this.getAndCheckMenu(), menuItems, operator);
            }
            catch (StepExecutionException stepExecutionException) {
                AbstractMenuTester.getLog().info("Tried to close a disabled or already closed menu.");
            }
            this.throwMenuItemNotFound();
        }
        item.selectMenuItem();
        if (EnvironmentUtils.isMacOS() && item.isShowing()) {
            this.closeMenu(this.getAndCheckMenu(), menuItems, operator);
        }
    }

    protected IMenuComponent getAndCheckMenu() throws StepExecutionException {
        IMenuComponent menuAdapter = this.getMenuAdapter();
        if (menuAdapter == null || menuAdapter.getRealComponent() == null) {
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoMenuBar"), EventFactory.createActionError((String)"TestErrorEvent.NoMenuBar"));
        }
        return menuAdapter;
    }

    private void throwMenuItemNotFound() {
        throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
    }

    protected void closeMenu(IMenuComponent menuBar, String[] textPath, String operator) {
        IMenuItemComponent menuitem = this.findMenu(menuBar, this.getIndexForName(menuBar, textPath[0], operator));
        if (menuitem.getRealComponent() != null) {
            this.getRobot().click(menuitem.getRealComponent(), null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
        }
    }

    protected void closeMenu(IMenuComponent menuBar, int[] path) {
        IMenuItemComponent menuitem = this.findMenu(menuBar, path[0]);
        if (menuitem.getRealComponent() != null) {
            this.getRobot().click(menuitem.getRealComponent(), null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
        }
    }

    protected int getIndexForName(IMenuComponent menu, String name, String operator) {
        IMenuItemComponent[] subElements = menu.getItems();
        int ignoreElementCount = 0;
        int j = 0;
        while (j < subElements.length) {
            IMenuItemComponent tempMenu = subElements[j];
            if (!tempMenu.isShowing() || tempMenu.isSeparator() && tempMenu.isShowing()) {
                ++ignoreElementCount;
            }
            if (tempMenu.isShowing() && MatchUtil.getInstance().match(tempMenu.getText(), name, operator)) {
                return j - ignoreElementCount;
            }
            ++j;
        }
        return Integer.MAX_VALUE;
    }

    public void waitForComponent(int timeout, int delay) {
        IComponent component = this.getComponent();
        if (component == null || component.getRealComponent() == null) {
            long start = System.currentTimeMillis();
            do {
                RobotTiming.sleepWaitForComponentPollingDelay();
                component = this.getComponent();
            } while (System.currentTimeMillis() - start < (long)timeout && (component == null || component.getRealComponent() == null));
            if (component == null || component.getRealComponent() == null) {
                throw new StepExecutionException("No Menubar found.", EventFactory.createComponentNotFoundErrorEvent());
            }
        }
        TimeUtil.delay((long)delay);
    }

    protected IMenuItemComponent navigateToMenuItem(IMenuComponent menuBar, String[] path, String operator) {
        this.checkPathLength(path.length);
        IMenuComponent currentmenu = menuBar;
        IMenuItemComponent currentMenuItem = null;
        int pathLength = path.length;
        int beforeLast = pathLength - 1;
        int i = 0;
        while (i < path.length) {
            int pathIndex = this.getIndexForName(currentmenu, path[i], operator);
            currentMenuItem = this.getNextMenuItem(currentmenu, pathIndex);
            if (currentMenuItem.getRealComponent() == null && i < beforeLast) {
                return currentMenuItem;
            }
            if (i < beforeLast) {
                if (!currentMenuItem.hasSubMenu()) {
                    return this.newMenuItemAdapter(null);
                }
                currentmenu = currentMenuItem.openSubMenu();
            }
            ++i;
        }
        return currentMenuItem;
    }

    protected IMenuItemComponent navigateToMenuItem(IMenuComponent menubar, int[] path) {
        this.checkPathLength(path.length);
        IMenuComponent currentmenu = menubar;
        IMenuItemComponent currentMenuItem = null;
        int pathLength = path.length;
        int beforeLast = pathLength - 1;
        int i = 0;
        while (i < path.length) {
            int pathIndex = path[i];
            currentMenuItem = this.getNextMenuItem(currentmenu, pathIndex);
            if (currentMenuItem.getRealComponent() == null && i < beforeLast) {
                return currentMenuItem;
            }
            if (i < beforeLast) {
                if (!currentMenuItem.hasSubMenu()) {
                    return this.newMenuItemAdapter(null);
                }
                currentmenu = currentMenuItem.openSubMenu();
            }
            ++i;
        }
        return currentMenuItem;
    }

    private IMenuItemComponent getNextMenuItem(IMenuComponent currentmenu, int pathIndex) {
        if (pathIndex < 0) {
            AbstractMenuTester.throwInvalidPathException();
        }
        IMenuItemComponent currentMenuItem = this.findMenu(currentmenu, pathIndex);
        return currentMenuItem;
    }

    private IMenuItemComponent findMenu(IMenuComponent menu, int idx) {
        ArrayList<IMenuItemComponent> visibleSubMenus = new ArrayList<IMenuItemComponent>();
        IMenuItemComponent[] subElements = menu.getItems();
        int i = 0;
        while (i < subElements.length) {
            IMenuItemComponent menuitem = subElements[i];
            if (menuitem.getRealComponent() != null && !menuitem.isSeparator() && menuitem.isShowing()) {
                visibleSubMenus.add(menuitem);
            }
            ++i;
        }
        if (idx >= visibleSubMenus.size() || idx < 0) {
            return this.newMenuItemAdapter(null);
        }
        return (IMenuItemComponent)visibleSubMenus.get(idx);
    }

    private void checkPathLength(int length) {
        if (length < 1) {
            throw new StepExecutionException("empty path to menuitem is not allowed", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
    }

    private static void throwInvalidPathException() {
        throw new StepExecutionException("invalid path", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
    }

    protected abstract IMenuItemComponent newMenuItemAdapter(Object var1);
}

