/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.desktop.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.eclipse.jubula.autagent.common.AutStarter;
import org.eclipse.jubula.autagent.common.agent.AutAgent;
import org.eclipse.jubula.autagent.common.desktop.DesktopIntegration;
import org.eclipse.jubula.autagent.common.gui.ObjectMappingFrame;
import org.eclipse.jubula.autagent.common.gui.utils.AgentOMKeyProperitesUtils;
import org.eclipse.jubula.autagent.desktop.connection.DirectAUTConnection;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.tools.AUTIdentifier;
import org.eclipse.jubula.tools.internal.constants.InputCodeHelper;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.om.IObjectMappingObserver;
import org.eclipse.jubula.tools.internal.om.ObjectMappingDispatcher;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartOMActionListener
implements ActionListener {
    private static final Logger LOG = LoggerFactory.getLogger(StartOMActionListener.class);
    private AutIdentifier m_autID;

    public StartOMActionListener(AutIdentifier autID) {
        this.m_autID = autID;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            AutAgent agent = AutStarter.getInstance().getAgent();
            AutIdentifier id = this.m_autID;
            Communicator comm = agent.getAutCommunicator((AUTIdentifier)id);
            DirectAUTConnection connection = new DirectAUTConnection(comm, id);
            connection.setup();
            ChangeAUTModeMessage message = new ChangeAUTModeMessage();
            message.setMode(5);
            int modifier = AgentOMKeyProperitesUtils.getModifier();
            InputCodeHelper.UserInput userInput = AgentOMKeyProperitesUtils.getInput();
            int input = userInput.getCode();
            int inputType = userInput.getType();
            message.setMappingKeyModifier(modifier);
            switch (inputType) {
                case 2: {
                    message.setMappingMouseButton(input);
                    message.setMappingKey(-1);
                    break;
                }
                default: {
                    message.setMappingKey(input);
                    message.setMappingMouseButton(-1);
                }
            }
            message.setMappingWithParentsKeyModifier(192);
            switch (1) {
                case 2: {
                    message.setMappingWithParentsMouseButton(65);
                    message.setMappingWithParentsKey(-1);
                    break;
                }
                default: {
                    message.setMappingWithParentsKey(65);
                    message.setMappingWithParentsMouseButton(-1);
                }
            }
            connection.send((Message)message);
            ObjectMappingDispatcher.removeObserver((IObjectMappingObserver)ObjectMappingFrame.INSTANCE);
            ObjectMappingFrame.INSTANCE.showObjectMappingPanel();
            ObjectMappingDispatcher.addObserver((IObjectMappingObserver)ObjectMappingFrame.INSTANCE);
            DesktopIntegration.setObjectMappingAUT((AutIdentifier)id);
        }
        catch (IllegalArgumentException | CommunicationException ex) {
            DesktopIntegration.setObjectMappingAUT(null);
            LOG.error("There was an error during start of the OMM", ex);
        }
    }
}

