/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class EMFRootObjectManager
implements EditModelListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    private final Map projectEditModels = new HashMap();
    private final Map projectRootObjects = new HashMap();
    private final List listeners = new ArrayList();

    public EMFRootObjectManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        if (this.projectEditModels == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        EditModel editModel = null;
        Object[] keys = this.projectEditModels.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            editModel = (EditModel)this.projectEditModels.remove(keys[i]);
            if (editModel != null) {
                editModel.removeListener((EditModelListener)this);
                editModel.releaseAccess((Object)this);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRootObject(IProject project) {
        if (project == null || !project.isAccessible()) {
            return null;
        }
        EObject rootObject = null;
        Map map = this.projectRootObjects;
        synchronized (map) {
            EditModel editModel;
            rootObject = (EObject)this.projectRootObjects.get(project);
            if ((rootObject == null || ((EObject)rootObject).eResource() == null) && (editModel = this.getEditModelForProject(project)) != null) {
                rootObject = editModel.getPrimaryRootObject();
                this.projectRootObjects.put(project, rootObject);
            }
        }
        return rootObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EditModel getEditModelForProject(IProject project) {
        if (project == null) {
            return null;
        }
        EditModel editModel = null;
        Map map = this.projectEditModels;
        synchronized (map) {
            editModel = (EditModel)this.projectEditModels.get(project);
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            ArtifactEdit artifactEdit = null;
            try {
                if (editModel == null && project.isAccessible() && (artifactEdit = ArtifactEdit.getArtifactEditForRead((IVirtualComponent)component)) != null && (editModel = (EditModel)artifactEdit.getAdapter(EditModel.class)) != null) {
                    editModel.addListener((EditModelListener)this);
                    this.addMapping(project, editModel);
                }
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        return editModel;
    }

    protected void addMapping(IProject project, EditModel editModel) {
        this.projectEditModels.put(project, editModel);
    }

    public void editModelChanged(EditModelEvent anEvent) {
        IProject affectedProject = anEvent.getEditModel().getProject();
        switch (anEvent.getEventCode()) {
            case 3: 
            case 7: {
                Object oldRootObject = this.projectRootObjects.remove(affectedProject);
                if (oldRootObject == null) break;
                this.notifyListeners(affectedProject);
                break;
            }
            case 1: {
                Object oldRootObject = this.projectRootObjects.get(affectedProject);
                if (oldRootObject != null) break;
                this.notifyListeners(affectedProject);
                break;
            }
            case 5: {
                this.disposeCache(affectedProject);
                break;
            }
        }
    }

    private void notifyListeners(IProject aProject) {
        int x = 0;
        while (x < this.listeners.size()) {
            IRefreshHandlerListener refreshHandler = (IRefreshHandlerListener)this.listeners.get(x);
            refreshHandler.onRefresh(aProject);
            ++x;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (SWTException swte) {
                Logger.getLogger().logError((Throwable)swte);
            }
            catch (SWTError swte) {
                Logger.getLogger().logError((Throwable)swte);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    boolean projectOpenStateChanged;
                    boolean bl = projectOpenStateChanged = (delta.getFlags() & 0x4000) != 0;
                    if (delta.getKind() == 2 || projectOpenStateChanged) {
                        this.disposeCache((IProject)resource);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeCache(IProject affectedProject) {
        Map map = this.projectEditModels;
        synchronized (map) {
            this.projectRootObjects.remove(affectedProject);
            EditModel editModel = (EditModel)this.projectEditModels.remove(affectedProject);
            if (editModel != null) {
                editModel.removeListener((EditModelListener)this);
                editModel.releaseAccess((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.getListeners();
        synchronized (list) {
            if (aListener != null && !this.getListeners().contains(aListener)) {
                this.getListeners().add(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(aListener);
        }
    }

    protected List getListeners() {
        return this.listeners;
    }

    public static interface IRefreshHandlerListener {
        public void onRefresh(Object var1);
    }
}

