/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public final class BuildPropertiesUtils {
    private BuildPropertiesUtils() {
    }

    public static IBuildModel getBuildModel(IPluginModelBase model) throws CoreException {
        IProject project = model.getUnderlyingResource().getProject();
        IPluginModelBase pluginModelBase = PluginRegistry.findModel((IProject)project);
        IBuildModel buildModel = null;
        try {
            Method method = pluginModelBase.getClass().getMethod("getBuildModel", new Class[0]);
            if (method != null) {
                buildModel = (IBuildModel)method.invoke((Object)pluginModelBase, new Object[0]);
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
        }
        return buildModel;
    }

    public static IBuild getBuild(IProject project) throws CoreException {
        IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
        if (pluginModel == null) {
            return null;
        }
        IBuildModel buildModel = BuildPropertiesUtils.getBuildModel(pluginModel);
        if (buildModel == null) {
            return null;
        }
        return buildModel.getBuild();
    }

    public static boolean isInBuild(IFile elementFile) throws CoreException {
        String[] tokens;
        IProject project = elementFile.getProject();
        IPath filePath = elementFile.getFullPath().removeFirstSegments(1);
        IBuild build = BuildPropertiesUtils.getBuild(project);
        if (build == null) {
            return false;
        }
        IBuildEntry entry = build.getEntry("bin.includes");
        if (entry == null) {
            return false;
        }
        String[] stringArray = tokens = entry.getTokens();
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            Path path = new Path(token);
            if (path.isPrefixOf(filePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addToBuild(IFile elementFile) throws CoreException {
        IBuildModel buildModel;
        IProject project = elementFile.getProject();
        if (BuildPropertiesUtils.isInBuild(elementFile)) {
            return;
        }
        IPath filePath = elementFile.getFullPath().removeFirstSegments(1);
        IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
        IFile buildProperties = elementFile.getProject().getFile("build.properties");
        if (!buildProperties.exists()) {
            buildProperties.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        }
        if ((buildModel = BuildPropertiesUtils.getBuildModel(pluginModel)) == null) {
            throw new RuntimeException("Couldn't get build model");
        }
        IBuild build = buildModel.getBuild();
        IBuildEntry entry = build.getEntry("bin.includes");
        if (entry == null) {
            entry = buildModel.getFactory().createEntry("bin.includes");
            build.add(entry);
        }
        entry.addToken(filePath.toPortableString());
        ((IEditableModel)buildModel).save();
    }
}

