/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui;

import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.security.ui.AuthorizationManager;
import org.eclipse.equinox.internal.security.ui.DefaultAuthorizationManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.equinox.security.ui";
    private static final String PROP_TRUST_ENGINE = "osgi.signedcontent.trust.engine";
    private static final String PROP_AUTHZ_ENGINE = "osgi.signedcontent.authorization.engine";
    private static final String PROP_AUTHZ_MANAGER = "osgi.signedcontent.authorization.manager";
    private static final String PROP_DEFAULT_SERVICE = "org.eclipse.osgi";
    private static ServiceTracker<?, TrustEngine> trustEngineTracker;
    private static ServiceTracker<?, AuthorizationEngine> authzEngineTracker;
    private static ServiceTracker<?, AuthorizationManager> authzManagerTracker;
    private static ServiceTracker<?, PlatformAdmin> platformAdminTracker;
    private static ServiceTracker<?, DebugOptions> debugTracker;
    private static Activator plugin;
    private static BundleContext bundleContext;
    private ServiceRegistration<AuthorizationManager> defaultAuthzManagerReg;
    private static final String OPTION_DEBUG = "org.eclipse.equinox.security.ui/debug";
    private static final String OPTION_DEBUG_STORAGE = "org.eclipse.equinox.security.ui/debug/storage";

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getSymbolicName() {
        return plugin.getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        bundleContext = context;
        plugin = this;
        Hashtable<String, Object> properties = new Hashtable<String, Object>(7);
        properties.put("service.ranking", new Integer(Integer.MIN_VALUE));
        properties.put(PROP_AUTHZ_MANAGER, PROP_DEFAULT_SERVICE);
        this.defaultAuthzManagerReg = bundleContext.registerService(AuthorizationManager.class, (Object)new DefaultAuthorizationManager(), properties);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        bundleContext = null;
        plugin = null;
        if (this.defaultAuthzManagerReg != null) {
            this.defaultAuthzManagerReg.unregister();
            this.defaultAuthzManagerReg = null;
        }
        if (authzEngineTracker != null) {
            authzEngineTracker.close();
            authzEngineTracker = null;
        }
        if (authzManagerTracker != null) {
            authzManagerTracker.close();
            authzManagerTracker = null;
        }
        if (platformAdminTracker != null) {
            platformAdminTracker.close();
            platformAdminTracker = null;
        }
        if (debugTracker != null) {
            debugTracker.close();
            debugTracker = null;
        }
    }

    public static TrustEngine[] getTrustEngines() {
        if (trustEngineTracker == null) {
            String trustAuthorityProp = Activator.getBundleContext().getProperty(PROP_TRUST_ENGINE);
            Filter filter = null;
            if (trustAuthorityProp != null) {
                try {
                    filter = FrameworkUtil.createFilter((String)("(&(objectClass=" + TrustEngine.class.getName() + ")(" + PROP_TRUST_ENGINE + "=" + trustAuthorityProp + "))"));
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            }
            trustEngineTracker = filter != null ? new ServiceTracker(bundleContext, filter, null) : new ServiceTracker(bundleContext, TrustEngine.class, null);
            trustEngineTracker.open();
        }
        return (TrustEngine[])trustEngineTracker.getServices((Object[])new TrustEngine[0]);
    }

    public static AuthorizationEngine getAuthorizationEngine() {
        if (authzEngineTracker == null) {
            String implProp = Activator.getBundleContext().getProperty(PROP_AUTHZ_ENGINE);
            Filter filter = null;
            if (implProp != null) {
                try {
                    filter = FrameworkUtil.createFilter((String)("(&(objectClass=" + AuthorizationEngine.class.getName() + ")(" + PROP_AUTHZ_ENGINE + "=" + implProp + "))"));
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
            }
            authzEngineTracker = filter != null ? new ServiceTracker(Activator.getBundleContext(), filter, null) : new ServiceTracker(Activator.getBundleContext(), AuthorizationEngine.class, null);
            authzEngineTracker.open();
        }
        return (AuthorizationEngine)authzEngineTracker.getService();
    }

    public static AuthorizationManager getAuthorizationManager() {
        if (authzManagerTracker == null) {
            String implProp = Activator.getBundleContext().getProperty(PROP_AUTHZ_MANAGER);
            Filter filter = null;
            if (implProp != null) {
                try {
                    filter = FrameworkUtil.createFilter((String)("(&(objectClass=" + AuthorizationManager.class.getName() + ")(" + PROP_AUTHZ_MANAGER + "=" + implProp + "))"));
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
            }
            authzManagerTracker = filter != null ? new ServiceTracker(Activator.getBundleContext(), filter, null) : new ServiceTracker(Activator.getBundleContext(), AuthorizationManager.class, null);
            authzManagerTracker.open();
        }
        return (AuthorizationManager)authzManagerTracker.getService();
    }

    public static PlatformAdmin getPlatformAdmin() {
        if (platformAdminTracker == null) {
            platformAdminTracker = new ServiceTracker(Activator.getBundleContext(), PlatformAdmin.class, null);
            platformAdminTracker.open();
        }
        return (PlatformAdmin)platformAdminTracker.getService();
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons" + relativePath));
    }

    public static void log(int severity, String key, Object[] args, Throwable throwable) {
        plugin.getLog().log((IStatus)new Status(severity, Activator.getSymbolicName(), 0, NLS.bind((String)key, (Object[])args), throwable));
    }

    public DebugOptions getDebugOptions() {
        if (debugTracker == null) {
            debugTracker = new ServiceTracker(bundleContext, DebugOptions.class, null);
            debugTracker.open();
        }
        return (DebugOptions)debugTracker.getService();
    }

    public boolean debugStorageContents() {
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            return false;
        }
        return debugOptions.getBooleanOption(OPTION_DEBUG, false) && debugOptions.getBooleanOption(OPTION_DEBUG_STORAGE, false);
    }
}

