/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.cargo.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.cargo.core.CLIOption;
import org.eclipse.jface.preference.IPreferenceStore;

public class CargoTools {
    private CargoTools() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<CLIOption> getOptions(String subCommand) {
        try {
            Process process = CorrosionPlugin.getProcessForCommand(CargoTools.getCargoCommand(), subCommand, "--help");
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                List<CLIOption> list;
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    String line = in.readLine();
                    while (line != null && !"options:".equalsIgnoreCase(line)) {
                        line = in.readLine();
                    }
                    if (line == null) {
                        list = Collections.emptyList();
                        return list;
                    }
                    ArrayList<CLIOption> options = new ArrayList<CLIOption>();
                    ArrayList<String> currentOptionLines = new ArrayList<String>();
                    while (line != null && !line.matches("\\s*")) {
                        if (line.matches("\\s*-+.*")) {
                            if (!currentOptionLines.isEmpty()) {
                                options.add(new CLIOption(currentOptionLines));
                                currentOptionLines.clear();
                            }
                            currentOptionLines.add(line);
                        } else if (!currentOptionLines.isEmpty()) {
                            currentOptionLines.add(line);
                        }
                        line = in.readLine();
                    }
                    if (!currentOptionLines.isEmpty()) {
                        options.add(new CLIOption(currentOptionLines));
                        currentOptionLines.clear();
                    }
                    return options;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (in == null) return list;
                    in.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static String getCargoCommand() {
        IPreferenceStore store = CorrosionPlugin.getDefault().getPreferenceStore();
        return store.getString("corrosion.rustup_cargoPath");
    }
}

