/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTypeId;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.utils.CPPASTAllVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class NamespaceHelper {
    public static ICPPASTName[] getSurroundingNamespace(final ITranslationUnit translationUnit, final int offset, CRefactoringContext astCache) throws CoreException {
        final ArrayList names = new ArrayList();
        astCache.getAST(translationUnit, null).accept((ASTVisitor)new CPPASTAllVisitor(){

            @Override
            public int visit(IASTDeclSpecifier declSpec) {
                if (declSpec instanceof ICPPASTCompositeTypeSpecifier && NamespaceHelper.checkFileNameAndLocation(translationUnit.getLocation(), offset, (IASTNode)declSpec)) {
                    names.add((ICPPASTName)NamespaceHelper.createNameWithTemplates((IASTNode)declSpec));
                }
                return super.visit(declSpec);
            }

            @Override
            public int visit(ICPPASTNamespaceDefinition namespace) {
                if (NamespaceHelper.checkFileNameAndLocation(translationUnit.getLocation(), offset, (IASTNode)namespace)) {
                    names.add((ICPPASTName)namespace.getName().copy(IASTNode.CopyStyle.withLocations));
                }
                return super.visit(namespace);
            }
        });
        return names.toArray(new ICPPASTName[names.size()]);
    }

    private static boolean checkFileNameAndLocation(IPath path, int offset, IASTNode namespace) {
        IASTFileLocation fileLoc = namespace.getFileLocation();
        if (fileLoc == null) {
            return false;
        }
        boolean fileNameOk = fileLoc.getFileName().endsWith(path.toOSString());
        if (!fileNameOk) {
            return false;
        }
        IASTNodeLocation[] iASTNodeLocationArray = namespace.getNodeLocations();
        int n = iASTNodeLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean locationOk;
            IASTNodeLocation nodeLocation = iASTNodeLocationArray[n2];
            int nodeOffset = nodeLocation.getNodeOffset();
            boolean bl = locationOk = offset >= nodeOffset && offset < nodeOffset + nodeLocation.getNodeLength();
            if (locationOk) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IASTName createNameWithTemplates(IASTNode declarationParent) {
        IASTName parentName = ((ICPPASTCompositeTypeSpecifier)declarationParent).getName().copy(IASTNode.CopyStyle.withLocations);
        if (NamespaceHelper.classHasTemplates(declarationParent)) {
            CPPASTTemplateId templateId = new CPPASTTemplateId();
            templateId.setTemplateName(parentName);
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = ((ICPPASTTemplateDeclaration)declarationParent.getParent().getParent()).getTemplateParameters();
            int n = iCPPASTTemplateParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter templateParameter = iCPPASTTemplateParameterArray[n2];
                if (templateParameter instanceof CPPASTSimpleTypeTemplateParameter) {
                    CPPASTSimpleTypeTemplateParameter simpleTypeTemplateParameter = (CPPASTSimpleTypeTemplateParameter)templateParameter;
                    CPPASTTypeId id = new CPPASTTypeId();
                    CPPASTNamedTypeSpecifier namedTypeSpecifier = new CPPASTNamedTypeSpecifier();
                    namedTypeSpecifier.setName(simpleTypeTemplateParameter.getName().copy(IASTNode.CopyStyle.withLocations));
                    id.setDeclSpecifier((IASTDeclSpecifier)namedTypeSpecifier);
                    templateId.addTemplateArgument((IASTTypeId)id);
                }
                ++n2;
            }
            parentName = templateId;
        }
        return parentName;
    }

    private static boolean classHasTemplates(IASTNode declarationParent) {
        return declarationParent.getParent() != null && declarationParent.getParent().getParent() instanceof ICPPASTTemplateDeclaration;
    }
}

