/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class AdditionalInput
implements IAdditionalInput {
    private static final String BUILD_VARIABLE_STATIC_LIB = "ARCHIVES";
    private static final String BUILD_VARIABLE_SHARED_LIB = "LIBRARIES";
    private String[] expandedNames;
    private IInputType fParent;
    private String fPaths;
    private Integer fKind;
    private boolean fIsExtensionAdditionalInput = false;
    private boolean fIsDirty = false;
    private boolean fResolved = true;
    private boolean fRebuildState;

    public AdditionalInput(IInputType parent, IManagedConfigElement element) {
        this.fParent = parent;
        this.fIsExtensionAdditionalInput = true;
        this.fResolved = false;
        this.loadFromManifest(element);
    }

    public AdditionalInput(InputType parent, boolean isExtensionElement) {
        this.fParent = parent;
        this.fIsExtensionAdditionalInput = isExtensionElement;
        if (!isExtensionElement) {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public AdditionalInput(IInputType parent, ICStorageElement element) {
        this.fParent = parent;
        this.fIsExtensionAdditionalInput = false;
        this.loadFromProject(element);
    }

    public AdditionalInput(IInputType parent, AdditionalInput additionalInput) {
        this.fParent = parent;
        this.fIsExtensionAdditionalInput = false;
        if (additionalInput.fPaths != null) {
            this.fPaths = additionalInput.fPaths;
        }
        if (additionalInput.fKind != null) {
            this.fKind = additionalInput.fKind;
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        this.fPaths = SafeStringInterner.safeIntern((String)element.getAttribute("paths"));
        String kindStr = element.getAttribute("kind");
        if (kindStr == null || kindStr.equals("additionalinputdependency")) {
            this.fKind = 3;
        } else if (kindStr.equals("additionalinput")) {
            this.fKind = 2;
        } else if (kindStr.equals("additionaldependency")) {
            this.fKind = 1;
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        if (element.getAttribute("paths") != null) {
            this.fPaths = SafeStringInterner.safeIntern((String)element.getAttribute("paths"));
        }
        if (element.getAttribute("kind") != null) {
            String kindStr = element.getAttribute("kind");
            if (kindStr == null || kindStr.equals("additionalinputdependency")) {
                this.fKind = 3;
            } else if (kindStr.equals("additionalinput")) {
                this.fKind = 2;
            } else if (kindStr.equals("additionaldependency")) {
                this.fKind = 1;
            }
        }
    }

    public void serialize(ICStorageElement element) {
        if (this.fPaths != null) {
            element.setAttribute("paths", this.fPaths);
        }
        if (this.fKind != null) {
            String str;
            switch (this.getKind()) {
                case 2: {
                    str = "additionalinput";
                    break;
                }
                case 1: {
                    str = "additionaldependency";
                    break;
                }
                case 3: {
                    str = "additionalinputdependency";
                    break;
                }
                default: {
                    str = "";
                }
            }
            element.setAttribute("kind", str);
        }
        this.fIsDirty = false;
    }

    @Override
    public IInputType getParent() {
        return this.fParent;
    }

    @Override
    public String[] getPaths() {
        if (this.fPaths == null) {
            return null;
        }
        String[] nameTokens = CDataUtil.stringToArray((String)this.fPaths, (String)";");
        return nameTokens;
    }

    @Override
    public void setPaths(String newPaths) {
        if (this.fPaths == null && newPaths == null) {
            return;
        }
        if (this.fPaths == null || newPaths == null || !this.fPaths.equals(newPaths)) {
            this.fPaths = newPaths;
            this.fIsDirty = true;
            this.setRebuildState(true);
        }
    }

    @Override
    public int getKind() {
        if (this.fKind == null) {
            return 3;
        }
        return this.fKind;
    }

    @Override
    public void setKind(int newKind) {
        if (this.fKind == null || this.fKind != newKind) {
            this.fKind = newKind;
            this.fIsDirty = true;
            this.setRebuildState(true);
        }
    }

    public boolean isExtensionElement() {
        return this.fIsExtensionAdditionalInput;
    }

    @Override
    public boolean isDirty() {
        if (this.fIsExtensionAdditionalInput) {
            return false;
        }
        return this.fIsDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.fIsDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.fResolved) {
            this.fResolved = true;
        }
    }

    public boolean needsRebuild() {
        long artifactTimeStamp;
        IToolChain toolChain;
        if (this.fIsExtensionAdditionalInput) {
            return false;
        }
        if (this.fRebuildState) {
            return this.fRebuildState;
        }
        if ((this.fKind == 1 || this.fKind == 3 || this.isLibrariesInput()) && (toolChain = this.getToolChain()) != null && !toolChain.isExtensionElement() && 0L != (artifactTimeStamp = this.getArtifactTimeStamp(toolChain))) {
            String[] paths = this.getPaths();
            int i = 0;
            while (i < paths.length) {
                if (paths[i].length() != 0 && this.dependencyChanged(paths[i], artifactTimeStamp)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private long getArtifactTimeStamp(IToolChain toolChain) {
        IBuilder builder = toolChain.getBuilder();
        IConfiguration configuration = toolChain.getParent();
        URI buildLocationURI = ManagedBuildManager.getBuildLocationURI(configuration, builder);
        if (buildLocationURI != null) {
            if (!buildLocationURI.toString().endsWith("/")) {
                buildLocationURI = URI.create(String.valueOf(buildLocationURI.toString()) + "/");
            }
            String artifactName = configuration.getArtifactName();
            String artifactExt = configuration.getArtifactExtension();
            String artifactPref = configuration.getOutputPrefix(artifactExt);
            if (artifactName.length() > 0) {
                if (artifactExt.length() > 0) {
                    artifactName = String.valueOf(artifactName) + "." + artifactExt;
                }
                if (artifactPref.length() > 0) {
                    artifactName = String.valueOf(artifactPref) + artifactName;
                }
                try {
                    artifactName = ManagedBuildManager.getBuildMacroProvider().resolveValue(artifactName, "", " ", 3, configuration);
                }
                catch (BuildMacroException buildMacroException) {
                    // empty catch block
                }
                URI buildArtifactURI = EFSExtensionManager.getDefault().append(buildLocationURI, artifactName);
                try {
                    IFileInfo info;
                    IFileStore artifact = EFS.getStore((URI)buildArtifactURI);
                    IFileInfo iFileInfo = info = artifact == null ? null : artifact.fetchInfo();
                    if (info != null && info.exists()) {
                        return info.getLastModified();
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    private boolean isLibrariesInput() {
        return this.fKind == 2 && Arrays.asList(this.getPaths()).contains("$(LIBS)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dependencyChanged(String sPath, long artefactTimeStamp) {
        try {
            IToolChain toolChain = this.getToolChain();
            IConfiguration configuration = toolChain.getParent();
            if (this.fIsDirty || this.expandedNames == null) {
                this.expandedNames = "$(LIBS)".equals(sPath) ? this.getDepLibs() : ("$(USER_OBJS)".equals(sPath) ? this.getDepObjs(configuration) : this.getDepFiles(sPath));
            }
            int j = 0;
            while (true) {
                if (j >= this.expandedNames.length) {
                    return false;
                }
                if (this.expandedNames[j] != null) {
                    IFileInfo info;
                    IFileStore file = AdditionalInput.getEFSFile(this.expandedNames[j]);
                    IFileInfo iFileInfo = info = file == null ? null : file.fetchInfo();
                    if (info != null && info.exists() && info.getLastModified() > artefactTimeStamp) {
                        return true;
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return false;
    }

    private IToolChain getToolChain() {
        IBuildObject bo = this.fParent.getParent().getParent();
        IToolChain tCh = null;
        if (bo instanceof IToolChain) {
            tCh = (IToolChain)bo;
        } else if (bo instanceof org.eclipse.cdt.managedbuilder.core.IFileInfo) {
            tCh = ((ResourceConfiguration)bo).getBaseToolChain();
        }
        return tCh;
    }

    private String[] getDepLibs() throws CoreException, BuildException, CdtVariableException {
        IOption[] options = this.fParent.getParent().getOptions();
        String[] libNames = null;
        ArrayList<String> libPaths = null;
        int i = 0;
        while (i < options.length) {
            int type = options[i].getValueType();
            if (type == 6) {
                libNames = options[i].getLibraries();
            } else if (type == 9) {
                if (libPaths == null) {
                    libPaths = new ArrayList<String>();
                }
                libPaths.addAll(Arrays.asList(this.restoreLibraryPaths(options[i])));
            }
            ++i;
        }
        if (libNames != null && libPaths != null) {
            IToolChain toolChain = this.getToolChain();
            int i2 = 0;
            while (i2 < libNames.length) {
                URI uri = this.findLibrary(toolChain, libNames[i2], libPaths);
                libNames[i2] = uri == null ? null : uri.toString();
                ++i2;
            }
            return libNames;
        }
        return new String[0];
    }

    private String[] restoreLibraryPaths(IOption option) throws BuildException, CdtVariableException {
        List libPaths = (List)option.getValue();
        String[] dirs = libPaths.toArray(new String[libPaths.size()]);
        dirs = this.substituteEnvVars(option, dirs);
        return dirs;
    }

    private URI findLibrary(IToolChain toolChain, String libName, List<String> dirs) throws CoreException {
        String libSO = String.valueOf(AdditionalInput.getDynamicLibPrefix(toolChain)) + libName + '.' + AdditionalInput.getDynamicLibExtension(toolChain);
        String libA = String.valueOf(AdditionalInput.getStaticLibPrefix(toolChain)) + libName + '.' + AdditionalInput.getStaticLibExtension(toolChain);
        Iterator<String> i = dirs.iterator();
        while (i.hasNext()) {
            IFileStore dir = AdditionalInput.getEFSFile(i.next());
            class LibFilter {
                private final /* synthetic */ String val$libA;
                private final /* synthetic */ String val$libSO;
                private final /* synthetic */ String val$libName;

                LibFilter(String string, String string2, String string3) {
                    this.val$libA = string;
                    this.val$libSO = string2;
                    this.val$libName = string3;
                }

                public boolean accept(String name) {
                    if (this.equals(this.val$libA, name)) {
                        return true;
                    }
                    if (!this.startsWith(name, this.val$libSO)) {
                        return false;
                    }
                    if (this.val$libSO.length() == name.length()) {
                        return true;
                    }
                    if (name.charAt(this.val$libSO.length()) != '.') {
                        return false;
                    }
                    String ext = this.val$libName.substring(this.val$libSO.length() + 1);
                    try {
                        Integer.parseInt(ext);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                boolean equals(String a, String b) {
                    return a.equals(b);
                }

                boolean startsWith(String string, String prefix) {
                    return string.startsWith(prefix);
                }
            }
            class CaseInsensitiveLibFilter
            extends LibFilter {
                CaseInsensitiveLibFilter(String string, String string2, String string3) {
                    super(string, string2, string3);
                }

                @Override
                boolean equals(String a, String b) {
                    return a.equalsIgnoreCase(b);
                }

                @Override
                boolean startsWith(String string, String prefix) {
                    return string.toLowerCase().startsWith(prefix.toLowerCase());
                }
            }
            LibFilter filter = dir.getFileSystem().isCaseSensitive() ? new LibFilter(libA, libSO, libName) : new CaseInsensitiveLibFilter(libA, libSO, libName);
            IFileStore[] iFileStoreArray = dir.childStores(0, null);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                if (filter.accept(child.getName())) {
                    return child.toURI();
                }
                ++n2;
            }
        }
        return null;
    }

    private static IFileStore getEFSFile(String pathOrURI) {
        IFileStore result;
        try {
            result = EFS.getStore((URI)URI.create(pathOrURI));
        }
        catch (Exception e) {
            result = EFS.getLocalFileSystem().getStore((IPath)new Path(pathOrURI));
        }
        return result;
    }

    private String[] substituteEnvVars(IOption option, String[] paths) throws CdtVariableException {
        BuildMacroProvider provider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
        IMacroContextInfo info = provider.getMacroContextInfo(2, new OptionContextData(option, (IBuildObject)this.fParent));
        String delimiter = ManagedBuildManager.getEnvironmentVariableProvider().getDefaultDelimiter();
        String inexVal = " ";
        SupplierBasedCdtVariableSubstitutor subst = provider.getMacroSubstitutor(info, inexVal, delimiter);
        String[] newPaths = CdtVariableResolver.resolveStringListValues((String[])paths, (IVariableSubstitutor)subst, (boolean)false);
        int i = 0;
        while (i < newPaths.length) {
            String newPath = newPaths[i];
            int len = newPath.length();
            if (len > 1 && newPath.charAt(0) == '\"' && newPath.charAt(len - 1) == '\"') {
                newPaths[i] = newPaths[i].substring(1, len - 1);
            }
            ++i;
        }
        return newPaths;
    }

    private static String getStaticLibPrefix(IToolChain toolChain) {
        IOutputType type = AdditionalInput.findOutputType(toolChain, BUILD_VARIABLE_STATIC_LIB);
        if (type == null) {
            return "lib";
        }
        return type.getOutputPrefix();
    }

    private static String getStaticLibExtension(IToolChain toolChain) {
        IOutputType type = AdditionalInput.findOutputType(toolChain, BUILD_VARIABLE_STATIC_LIB);
        if (type == null || type.getOutputExtensionsAttribute().length == 0) {
            return "a";
        }
        return type.getOutputExtensionsAttribute()[0];
    }

    private static String getDynamicLibPrefix(IToolChain toolChain) {
        IOutputType type = AdditionalInput.findOutputType(toolChain, BUILD_VARIABLE_SHARED_LIB);
        if (type == null) {
            return "lib";
        }
        return type.getOutputPrefix();
    }

    private static String getDynamicLibExtension(IToolChain toolChain) {
        IOutputType type = AdditionalInput.findOutputType(toolChain, BUILD_VARIABLE_SHARED_LIB);
        if (type == null || type.getOutputExtensionsAttribute().length == 0) {
            return "so";
        }
        return type.getOutputExtensionsAttribute()[0];
    }

    public static IOutputType findOutputType(IToolChain toolChain, String buildVariable) {
        toolChain = ManagedBuildManager.getExtensionToolChain(toolChain);
        ITool[] tools = toolChain.getTools();
        int i = 0;
        while (i < tools.length) {
            IOutputType[] oTypes = tools[i].getOutputTypes();
            int j = 0;
            while (j < oTypes.length) {
                if (buildVariable.equals(oTypes[j].getBuildVariable())) {
                    return oTypes[j];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private String[] getDepObjs(IConfiguration configuration) throws BuildException, CdtVariableException {
        IOption[] options = this.fParent.getParent().getOptions();
        String[] userObjs = null;
        int i = 0;
        while (i < options.length) {
            int type = options[i].getValueType();
            if (type == 7) {
                userObjs = options[i].getUserObjects();
                return this.substituteEnvVars(options[i], userObjs);
            }
            ++i;
        }
        return new String[0];
    }

    private String[] getDepFiles(String sPath) {
        return new String[0];
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        this.fRebuildState = rebuild;
    }
}

