/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.IGdbTerminalControlConnector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;

public class GdbTerminalConnector
implements IGdbTerminalControlConnector {
    private static final int HIST_BUFFER_MAX_SIZE = 1000;
    private static final int HIST_BUFFER_WRITE_SIZE = 100;
    private final Process fProcess;
    private final Set<ITerminalControl> fTerminalPageControls = Collections.synchronizedSet(new HashSet());
    private final Job fOutputStreamJob;
    private final Job fErrorStreamJob;
    private final ConsoleHistoryLinesBuffer fHistoryBuffer;

    public GdbTerminalConnector(Process process) {
        this.fProcess = process;
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        int prefBufferLines = store.getInt("org.eclipse.cdt.dsf.gdb.consoleBufferLines");
        int history_buffer_size = prefBufferLines < 1000 ? prefBufferLines : 1000;
        this.fHistoryBuffer = new ConsoleHistoryLinesBuffer(history_buffer_size);
        String jobSuffix = "";
        this.fOutputStreamJob = new OutputReadJob(process.getInputStream(), jobSuffix);
        this.fOutputStreamJob.schedule();
        jobSuffix = "-Error";
        this.fErrorStreamJob = new OutputReadJob(process.getErrorStream(), jobSuffix);
        this.fErrorStreamJob.schedule();
    }

    public void dispose() {
        this.fOutputStreamJob.cancel();
        this.fErrorStreamJob.cancel();
    }

    @Override
    public void addPageTerminalControl(ITerminalControl terminalControl) {
        new WriteHistoryJob(terminalControl).schedule();
    }

    @Override
    public void removePageTerminalControl(ITerminalControl terminalControl) {
        if (terminalControl != null) {
            this.fTerminalPageControls.remove(terminalControl);
        }
    }

    @Override
    public OutputStream getTerminalToRemoteStream() {
        return this.fProcess.getOutputStream();
    }

    private class ConsoleHistoryLinesBuffer
    extends ArrayDeque<String> {
        private static final long serialVersionUID = 1L;
        private final StringBuilder fHistoryRemainder;

        public ConsoleHistoryLinesBuffer(int size) {
            super(size);
            this.fHistoryRemainder = new StringBuilder();
        }

        @Override
        public synchronized int size() {
            return super.size();
        }

        private synchronized void appendRemainder(String text) {
            this.fHistoryRemainder.append(text);
        }

        private synchronized String popRemainder() {
            String remainder = this.fHistoryRemainder.toString();
            this.fHistoryRemainder.setLength(0);
            return remainder;
        }

        private synchronized HistorySnapShot getHistorySnapShot() {
            return new HistorySnapShot(this.toArray(), this.fHistoryRemainder.toString());
        }

        public synchronized void appendHistory(byte[] b, int read) {
            StringBuilder info = new StringBuilder(new String(b, StandardCharsets.UTF_8));
            info.setLength(read);
            String regEx = "(?<=\\n)";
            String[] chunks = info.toString().split(regEx);
            int i = 0;
            while (i < chunks.length) {
                StringBuilder lineBuilder = new StringBuilder();
                if (i == 0) {
                    lineBuilder.append(this.popRemainder());
                }
                lineBuilder.append(chunks[i]);
                String line = lineBuilder.toString();
                if (line.endsWith("\n")) {
                    while (this.size() >= 1000) {
                        this.remove();
                    }
                    this.offer(line);
                } else {
                    assert (i == chunks.length - 1);
                    this.appendRemainder(line);
                }
                ++i;
            }
        }

        public synchronized String[] toArray() {
            return super.toArray(new String[this.size()]);
        }

        private class HistorySnapShot {
            private final String[] fHistoryLinesSnapShot;
            private final String fHistoryRemainderSnapShot;

            private HistorySnapShot(String[] historyLines, String historyRemainder) {
                this.fHistoryLinesSnapShot = historyLines;
                this.fHistoryRemainderSnapShot = historyRemainder;
            }
        }
    }

    private class OutputReadJob
    extends Job {
        private InputStream fInputStream;

        private OutputReadJob(InputStream procStream, String nameSuffix) {
            super("GDB CLI output Job" + nameSuffix);
            this.setSystem(true);
            this.fInputStream = procStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                byte[] b = new byte[1024];
                int read = 0;
                while (!monitor.isCanceled()) {
                    read = this.fInputStream.read(b);
                    if (read > 0) {
                        Set set = GdbTerminalConnector.this.fTerminalPageControls;
                        synchronized (set) {
                            for (ITerminalControl control : GdbTerminalConnector.this.fTerminalPageControls) {
                                control.getRemoteToTerminalOutputStream().write(b, 0, read);
                            }
                            GdbTerminalConnector.this.fHistoryBuffer.appendHistory(b, read);
                        }
                    }
                    if (read >= 0) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.fInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    }

    private class WriteHistoryJob
    extends Job {
        private final ITerminalControl fTerminalControl;

        public WriteHistoryJob(ITerminalControl terminalControl) {
            super("GDB CLI write history job");
            this.setSystem(true);
            this.fTerminalControl = terminalControl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            OutputStream terminalOutputStream = this.fTerminalControl.getRemoteToTerminalOutputStream();
            if (terminalOutputStream == null) {
                return Status.OK_STATUS;
            }
            Set set = GdbTerminalConnector.this.fTerminalPageControls;
            synchronized (set) {
                ConsoleHistoryLinesBuffer.HistorySnapShot history = GdbTerminalConnector.this.fHistoryBuffer.getHistorySnapShot();
                String[] buffLines = history.fHistoryLinesSnapShot;
                int start = 0;
                int end = buffLines.length <= 100 ? buffLines.length : 100;
                StringBuilder sb = new StringBuilder(100);
                while (start < buffLines.length) {
                    String[] chunk;
                    String[] stringArray = chunk = Arrays.copyOfRange(buffLines, start, end);
                    int n = chunk.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        sb.append(line);
                        ++n2;
                    }
                    start = end;
                    int linesLeft = buffLines.length - end;
                    end = start + (linesLeft <= 100 ? linesLeft : 100);
                    if (start >= buffLines.length) {
                        sb.append(history.fHistoryRemainderSnapShot);
                    }
                    if (sb.length() <= 0) continue;
                    byte[] bytes = sb.toString().getBytes();
                    try {
                        terminalOutputStream.write(bytes, 0, bytes.length);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    sb.setLength(0);
                }
                GdbTerminalConnector.this.fTerminalPageControls.add(this.fTerminalControl);
            }
            return Status.OK_STATUS;
        }
    }
}

