/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.internal.docker.launcher.ILaunchConstants;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerNetworkSettings;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.ui.launch.ContainerLauncher;
import org.eclipse.linuxtools.docker.ui.launch.IContainerLaunchListener;

public class ContainerLaunchConfigurationDelegate
extends GdbLaunchDelegate
implements ILaunchConfigurationDelegate {
    private ContainerLauncher launcher;
    protected ICBuildConfigurationManager configManager = (ICBuildConfigurationManager)CDebugCorePlugin.getService(ICBuildConfigurationManager.class);
    protected IToolChainManager toolChainManager = (IToolChainManager)CDebugCorePlugin.getService(IToolChainManager.class);

    public ContainerLaunchConfigurationDelegate() {
        this.launcher = new ContainerLauncher();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath commandPath = this.getCommandPath(configuration);
        if (commandPath != null) {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("org.eclipse.cdt.container-launch", "");
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            labels.put("org.eclipse.cdt.project-name", projectName);
            if (mode.equals("run")) {
                ArrayList<String> additionalDirs;
                Path workingPath;
                String commandDir = commandPath.removeLastSegments(1).toPortableString();
                String commandString = commandPath.toPortableString();
                if (commandPath.getDevice() != null) {
                    commandDir = "/" + commandDir.replace(':', '/');
                    commandString = "/" + commandString.replace(':', '/');
                }
                StringBuilder b = new StringBuilder();
                b.append(commandString);
                String arguments = this.getProgramArguments(configuration);
                if (arguments.trim().length() > 0) {
                    b.append(" ");
                    b.append(arguments);
                }
                String command = b.toString();
                String workingDir = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                if (workingDir == null && projectName != null) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    workingDir = project.getLocation().toOSString();
                }
                if (workingDir != null && (workingPath = new Path(workingDir)).getDevice() != null) {
                    workingDir = "/" + workingPath.toPortableString().replace(':', '/');
                }
                Map envMap = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                Map<String, String> origEnv = null;
                boolean appendEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
                if (appendEnv) {
                    origEnv = System.getenv();
                }
                if ((additionalDirs = configuration.getAttribute(ILaunchConstants.ATTR_ADDITIONAL_DIRS, null)) != null) {
                    ArrayList<String> dirs = new ArrayList<String>();
                    for (String additionalDir : additionalDirs) {
                        Path path = new Path(additionalDir);
                        String dir = path.toPortableString();
                        if (path.getDevice() != null) {
                            dir = "/" + dir.replace(':', '/');
                        }
                        dirs.add(dir);
                    }
                    additionalDirs = dirs;
                }
                String image = configuration.getAttribute(ILaunchConstants.ATTR_IMAGE, null);
                String connectionUri = configuration.getAttribute(ILaunchConstants.ATTR_CONNECTION_URI, "");
                boolean keepContainer = configuration.getAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, false);
                boolean supportStdin = configuration.getAttribute(ILaunchConstants.ATTR_STDIN_SUPPORT, false);
                boolean privilegedMode = configuration.getAttribute(ILaunchConstants.ATTR_PRIVILEGED_MODE, false);
                this.launcher.launch("org.eclipse.cdt.docker.launcher", null, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, null, keepContainer, supportStdin, privilegedMode, labels);
            } else if (mode.equals("debug")) {
                ArrayList<String> additionalDirs;
                Path workingPath;
                String gdbserverPortNumber = configuration.getAttribute(ILaunchConstants.ATTR_GDBSERVER_PORT, "2345");
                List<String> ports = Arrays.asList(String.valueOf(gdbserverPortNumber) + "/tcp");
                String gdbserverCommand = configuration.getAttribute(ILaunchConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
                String commandString = commandPath.toPortableString();
                String commandDir = commandPath.removeLastSegments(1).toPortableString();
                if (commandPath.getDevice() != null) {
                    commandDir = "/" + commandDir.replace(':', '/');
                    commandString = "/" + commandString.replace(':', '/');
                }
                String commandArguments = ":" + gdbserverPortNumber + " " + this.spaceEscapify(commandString);
                StringBuilder b = new StringBuilder();
                b.append(gdbserverCommand).append(' ').append(commandArguments);
                String arguments = this.getProgramArguments(configuration);
                if (arguments.trim().length() > 0) {
                    b.append(" ");
                    b.append(arguments);
                }
                String command = b.toString();
                String workingDir = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                if (workingDir == null && projectName != null) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    workingDir = project.getLocation().toOSString();
                }
                if (workingDir != null && (workingPath = new Path(workingDir)).getDevice() != null) {
                    workingDir = "/" + workingPath.toPortableString().replace(':', '/');
                }
                Map envMap = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                Map<String, String> origEnv = null;
                boolean appendEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
                if (appendEnv) {
                    origEnv = System.getenv();
                }
                if ((additionalDirs = configuration.getAttribute(ILaunchConstants.ATTR_ADDITIONAL_DIRS, null)) != null) {
                    ArrayList<String> dirs = new ArrayList<String>();
                    for (String additionalDir : additionalDirs) {
                        Path path = new Path(additionalDir);
                        String dir = path.toPortableString();
                        if (path.getDevice() != null) {
                            dir = "/" + dir.replace(':', '/');
                        }
                        dirs.add(dir);
                    }
                    additionalDirs = dirs;
                }
                String image = configuration.getAttribute(ILaunchConstants.ATTR_IMAGE, null);
                String connectionUri = configuration.getAttribute(ILaunchConstants.ATTR_CONNECTION_URI, "");
                boolean isLocalConnection = true;
                try {
                    Pattern ipaddrPattern = Pattern.compile("[a-z]*://([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+)[:]*[0-9]*");
                    Matcher m = ipaddrPattern.matcher(connectionUri);
                    if (m.matches()) {
                        String ipaddr = m.group(1);
                        InetAddress addr = InetAddress.getByName(ipaddr);
                        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
                            isLocalConnection = true;
                        } else {
                            try {
                                isLocalConnection = NetworkInterface.getByInetAddress(addr) != null;
                            }
                            catch (SocketException e) {
                                isLocalConnection = false;
                            }
                        }
                    }
                }
                catch (UnknownHostException e) {
                    Activator.log((Throwable)e);
                }
                boolean keepContainer = configuration.getAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, false);
                boolean supportStdin = configuration.getAttribute(ILaunchConstants.ATTR_STDIN_SUPPORT, false);
                boolean privilegedMode = configuration.getAttribute(ILaunchConstants.ATTR_PRIVILEGED_MODE, false);
                StartGdbServerJob job = new StartGdbServerJob(Messages.Gdbserver_start);
                job.schedule();
                this.launcher.launch("org.eclipse.cdt.docker.launcher", (IContainerLaunchListener)job, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, ports, keepContainer, supportStdin, privilegedMode, labels, "seccomp:unconfined");
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (job.getResult() == Status.OK_STATUS && job.getIpAddress() != null) {
                    List bindingList;
                    ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                    wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
                    wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
                    Map<Object, Object> hostPorts = new HashMap();
                    if (job.getPorts() != null && isLocalConnection) {
                        hostPorts = job.getPorts();
                    }
                    if ((bindingList = (List)hostPorts.get(String.valueOf(gdbserverPortNumber) + "/tcp")) != null && !bindingList.isEmpty()) {
                        IDockerPortBinding firstBinding = (IDockerPortBinding)bindingList.get(0);
                        wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", "localhost");
                        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", firstBinding.hostPort());
                    } else {
                        wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", job.getIpAddress());
                        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPortNumber);
                    }
                    wc.doSave();
                    try {
                        try {
                            super.launch(configuration, mode, launch, monitor);
                        }
                        catch (CoreException ex) {
                            this.launcher.cleanup(connectionUri, job.getContainerInfo());
                            throw ex;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        }
    }

    private String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
        if (args != null && args.length() > 0) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    private IPath getCommandPath(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        if (projectName.length() > 0) {
            IProject project = CCorePlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return null;
            }
            String name = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            if (name.length() == 0) {
                return null;
            }
            Path exePath = new Path(name);
            if (!exePath.isAbsolute()) {
                IPath location = project.getLocation();
                if (location == null) {
                    return null;
                }
                exePath = location.append(name);
                if (!exePath.toFile().exists()) {
                    IFile projFile = null;
                    try {
                        projFile = project.getFile(name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (projFile == null || !projFile.exists()) {
                        return null;
                    }
                    exePath = projFile.getLocation();
                }
            }
            if (!exePath.toFile().exists()) {
                return null;
            }
            if (!exePath.toFile().isFile()) {
                return null;
            }
            return exePath;
        }
        return null;
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    public static IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getMappedResources()[0].getProject();
    }

    protected ICBuildConfiguration getBuildConfiguration(ILaunchConfiguration configuration, String mode, ILaunchTarget target, IProgressMonitor monitor) throws CoreException {
        String providerId;
        IToolChain toolchain;
        IProject project = ContainerLaunchConfigurationDelegate.getProject(configuration);
        String toolchainId = configuration.getAttribute("cdt.toolChain.id", null);
        if (toolchainId != null && (toolchain = this.toolChainManager.getToolChain(providerId = configuration.getAttribute("cdt.toolChain.type", ""), toolchainId)) != null) {
            return this.configManager.getBuildConfiguration(project, toolchain, mode, monitor);
        }
        HashMap properties = new HashMap();
        properties.putAll(target.getAttributes());
        for (IToolChain toolChain : this.toolChainManager.getToolChainsMatching(properties)) {
            ICBuildConfiguration buildConfig = this.configManager.getBuildConfiguration(project, toolChain, mode, monitor);
            if (buildConfig == null) continue;
            return buildConfig;
        }
        return null;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProject project = ContainerLaunchConfigurationDelegate.getProject(configuration);
        String name = configuration.getName();
        Pattern p = Pattern.compile(".*?\\[([^\\]]+)\\](.*)");
        Matcher m = p.matcher(name);
        if (m.matches()) {
            ICBuildConfiguration cconfig;
            ILaunchTarget[] targets;
            ILaunchTargetManager targetManager = (ILaunchTargetManager)CCorePlugin.getService(ILaunchTargetManager.class);
            ILaunchTarget target = null;
            ILaunchTarget[] iLaunchTargetArray = targets = targetManager.getLaunchTargetsOfType("org.eclipse.cdt.docker.launcher.launchTargetType.container");
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchTarget t = iLaunchTargetArray[n2];
                if (t.getAttribute("image_id", "").replaceAll(":", "_").equals(m.group(1))) {
                    target = t;
                    break;
                }
                ++n2;
            }
            if (target != null && (cconfig = this.getBuildConfiguration(configuration, mode, target, monitor)) != null) {
                IProjectDescription desc = project.getDescription();
                desc.setActiveBuildConfig(cconfig.getBuildConfiguration().getName());
                project.setDescription(desc, monitor);
            }
        }
        return super.buildForLaunch(configuration, mode, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        ICBuildConfiguration cconfig;
        IProject project = ContainerLaunchConfigurationDelegate.getProject(configuration);
        ILaunchTargetManager targetManager = (ILaunchTargetManager)CCorePlugin.getService(ILaunchTargetManager.class);
        ILaunchTarget target = null;
        ILaunchTarget[] targets = targetManager.getLaunchTargetsOfType("org.eclipse.cdt.docker.launcher.launchTargetType.container");
        String image = configuration.getAttribute("image_id", null);
        String connection = configuration.getAttribute("connection_uri", null);
        ILaunchTarget[] iLaunchTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchTarget t = iLaunchTargetArray[n2];
            if (t.getAttribute("image_id", "").equals(image)) {
                target = t;
                break;
            }
            ++n2;
        }
        String program = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        if (program == null && (cconfig = this.getBuildConfiguration(configuration, mode, target, monitor)) != null) {
            IBinary[] binaries;
            IBinary[] iBinaryArray = binaries = cconfig.getBuildOutput();
            int n3 = binaries.length;
            int n4 = 0;
            while (n4 < n3) {
                IBinary b = iBinaryArray[n4];
                if (b.isExecutable() && b.getElementName().contains(project.getName())) {
                    ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                    wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", b.getResource().getProjectRelativePath().toString());
                    wc.setMappedResources(new IResource[]{b.getResource(), b.getResource().getProject()});
                    wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                    wc.setAttribute(ILaunchConstants.ATTR_CONNECTION_URI, connection);
                    wc.setAttribute(ILaunchConstants.ATTR_IMAGE, image);
                    wc.doSave();
                    break;
                }
                ++n4;
            }
        }
        return super.finalLaunchCheck(configuration, mode, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        IProject project = null;
        if (projectName == null) {
            IResource[] resources = config.getMappedResources();
            if (resources != null && resources.length > 0 && resources[0] instanceof IProject) {
                project = (IProject)resources[0];
            }
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
            wc.doSave();
        } else if (!(projectName = projectName.trim()).isEmpty()) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return super.preLaunchCheck(config, mode, monitor);
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.docker.launcher";
    }

    private class StartGdbServerJob
    extends Job
    implements IContainerLaunchListener {
        private boolean started;
        private boolean done;
        private IDockerContainerInfo info;

        public StartGdbServerJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(this.getName(), -1);
            while (!this.done) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.started && this.getIpAddress() != null) {
                    this.done = true;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public void newOutput(String output) {
            if (output.contains(Messages.Gdbserver_up) || output.contains("gdbserver:")) {
                this.started = true;
            }
        }

        public String getIpAddress() {
            if (this.info != null) {
                IDockerNetworkSettings networkSettings = this.info.networkSettings();
                return networkSettings.ipAddress();
            }
            return null;
        }

        public Map<String, List<IDockerPortBinding>> getPorts() {
            if (this.info != null) {
                IDockerNetworkSettings networkSettings = this.info.networkSettings();
                return networkSettings.ports();
            }
            return null;
        }

        public IDockerContainerInfo getContainerInfo() {
            return this.info;
        }

        public void done() {
            this.done = true;
        }

        public void containerInfo(IDockerContainerInfo info) {
            this.info = info;
        }
    }
}

