/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.viewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentBaseChangeUpdate;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentContentUpdate;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentUpdate;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualDocument;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualSourceViewer;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementContentProvider;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.WorkbenchJob;

public class DocumentContentProvider
implements IModelChangedListener {
    private VirtualSourceViewer fViewer;
    private VirtualDocument fDocument;
    private Object fRoot;
    private Object fBase;
    private Object fInput;
    private IModelProxy fRootProxy;
    private IModelProxy fBaseProxy;
    private List<IModelProxy> fLineProxies = new ArrayList<IModelProxy>(50);
    private Map<Object, Integer> fLineElements = new HashMap<Object, Integer>(20);
    private DocumentUpdate fUpdateInProgress;

    public DocumentContentProvider(VirtualDocument document) {
        this.fDocument = document;
    }

    protected void init(Object root) {
        this.fRoot = root;
        this.installRootProxy(this.fRoot);
    }

    public void update(IDocumentPresentation presentationContext, int lineCount, int offset, boolean reveal) {
        IDocumentElementContentProvider contentAdapter = this.getContentAdapter(this.getInput());
        if (contentAdapter != null && this.getRoot() != null && this.getBase() != null) {
            DocumentContentUpdate update = new DocumentContentUpdate(this, contentAdapter, presentationContext, this.getRoot(), this.getBase(), this.getInput(), lineCount, offset, reveal);
            this.schedule(update);
        } else {
            this.updateCompleted(new DocumentContentUpdate(this, contentAdapter, presentationContext, this.getRoot(), this.getBase(), this.getInput(), lineCount, offset, reveal));
        }
    }

    public synchronized void updateCompleted(DocumentContentUpdate update) {
        if (this.fUpdateInProgress == update) {
            this.fUpdateInProgress = null;
        }
        if (!update.isCanceled()) {
            this.disposeLineProxies();
            this.fLineElements.clear();
            this.getDocument().setCurrentOffset(update.getOffset());
            Object[] elements = update.getElements();
            int i = 0;
            while (i < elements.length) {
                this.fLineElements.put(elements[i], i);
                this.installLineProxy(i, elements[i]);
                this.getDocument().updateElement(this.getInput(), i, elements[i]);
                ++i;
            }
        }
    }

    protected IDocumentElementContentProvider getContentAdapter(Object element) {
        IDocumentElementContentProvider adapter = null;
        if (element instanceof IDocumentElementContentProvider) {
            adapter = (IDocumentElementContentProvider)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IDocumentElementContentProvider)adaptable.getAdapter(IDocumentElementContentProvider.class);
        }
        return adapter;
    }

    protected VirtualDocument getDocument() {
        return this.fDocument;
    }

    public Object getRoot() {
        return this.fRoot;
    }

    public Object getInput() {
        return this.fInput;
    }

    public Object getBase() {
        return this.fBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DocumentContentProvider documentContentProvider = this;
        synchronized (documentContentProvider) {
            if (this.fUpdateInProgress != null) {
                this.fUpdateInProgress.cancel();
            }
        }
        this.disposeRootProxy();
        this.fDocument = null;
        this.fInput = null;
        this.fViewer = null;
    }

    public void changeInput(VirtualSourceViewer viewer, IDocumentPresentation presentationContext, Object oldInput, Object newInput, int offset) {
        this.fViewer = viewer;
        this.fInput = newInput;
        IDocumentElementContentProvider contentAdapter = this.getContentAdapter(this.getInput());
        if (contentAdapter != null) {
            DocumentBaseChangeUpdate update = new DocumentBaseChangeUpdate(this, contentAdapter, presentationContext, this.getRoot(), this.getBase(), this.getInput(), offset);
            this.schedule(update);
        } else {
            this.inputChanged(new DocumentBaseChangeUpdate(this, contentAdapter, presentationContext, this.getRoot(), this.getBase(), this.getInput(), offset));
        }
    }

    public synchronized void inputChanged(DocumentBaseChangeUpdate update) {
        if (this.fUpdateInProgress == update) {
            this.fUpdateInProgress = null;
        }
        Object newBase = update.getBaseElement();
        int newOffset = update.getOffset();
        VirtualDocument document = this.getDocument();
        if (document != null) {
            boolean needsUpdate = false;
            if (newBase != this.getBase()) {
                this.fBase = newBase;
                this.disposeBaseProxy();
                this.installBaseProxy(this.fBase);
                needsUpdate = true;
            }
            if (newOffset != document.getCurrentOffset()) {
                document.setCurrentOffset(newOffset);
                needsUpdate = true;
            }
            if (needsUpdate) {
                WorkbenchJob job = new WorkbenchJob("refresh content"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        DocumentContentProvider.this.getViewer().refresh(true);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    public void modelChanged(final IModelDelta delta, final IModelProxy proxy) {
        WorkbenchJob job = new WorkbenchJob("process model delta"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!proxy.isDisposed()) {
                    DocumentContentProvider.this.handleModelChanges(delta);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void handleModelChanges(IModelDelta delta) {
        this.updateNodes(new IModelDelta[]{delta});
    }

    protected void updateNodes(IModelDelta[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            IModelDelta node = nodes[i];
            int flags = node.getFlags();
            if ((flags & 1) != 0) {
                this.handleAdd(node);
            }
            if ((flags & 2) != 0) {
                this.handleRemove(node);
            }
            if ((flags & 0x400) != 0) {
                this.handleContent(node);
            }
            if ((flags & 0x200000) != 0) {
                this.handleSelect(node);
            }
            if ((flags & 0x800) != 0) {
                this.handleState(node);
            }
            if ((flags & 0x10) != 0) {
                this.handleInsert(node);
            }
            if ((flags & 8) != 0) {
                this.handleReplace(node);
            }
            if ((flags & 0x400000) != 0) {
                this.handleInstall(node);
            }
            if ((flags & 0x800000) != 0) {
                this.handleUninstall(node);
            }
            if ((flags & 0x1000000) != 0) {
                this.handleReveal(node);
            }
            this.updateNodes(node.getChildDeltas());
            ++i;
        }
    }

    protected void handleState(IModelDelta delta) {
        int index = this.getElementIndex(delta.getElement());
        if (index >= 0) {
            this.getDocument().updateElement(this.getInput(), index, delta.getElement());
        }
    }

    protected void handleSelect(IModelDelta delta) {
    }

    protected void handleContent(IModelDelta delta) {
        if (delta.getElement().equals(this.getRoot()) || delta.getElement().equals(this.getBase())) {
            this.getViewer().refresh();
        }
    }

    protected void handleRemove(IModelDelta delta) {
    }

    protected void handleAdd(IModelDelta delta) {
    }

    protected void handleInsert(IModelDelta delta) {
    }

    protected void handleReplace(IModelDelta delta) {
    }

    protected void handleReveal(IModelDelta delta) {
    }

    protected void handleInstall(IModelDelta delta) {
    }

    protected void handleUninstall(IModelDelta delta) {
    }

    protected synchronized void installRootProxy(Object element) {
        if (!(element == null || element.equals(this.getRoot()) && this.fRootProxy != null)) {
            IModelProxy proxy;
            this.disposeRootProxy();
            IModelProxyFactory modelProxyFactory = this.getModelProxyFactoryAdapter(element);
            if (modelProxyFactory != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
                this.fRootProxy = proxy;
                Job job = new Job("Model Proxy installed notification job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (!monitor.isCanceled()) {
                            proxy.init(DocumentContentProvider.this.getPresentationContext());
                            proxy.addModelChangedListener((IModelChangedListener)DocumentContentProvider.this);
                            proxy.installed((Viewer)DocumentContentProvider.this.getViewer());
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    protected synchronized void installBaseProxy(Object element) {
        IModelProxy proxy;
        IModelProxyFactory modelProxyFactory;
        if (!(element == null || element.equals(this.getBase()) && this.fBaseProxy != null || (modelProxyFactory = this.getModelProxyFactoryAdapter(element)) == null || (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) == null)) {
            this.fBaseProxy = proxy;
            Job job = new Job("Model Proxy installed notification job"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        proxy.init(DocumentContentProvider.this.getPresentationContext());
                        proxy.addModelChangedListener((IModelChangedListener)DocumentContentProvider.this);
                        proxy.installed((Viewer)DocumentContentProvider.this.getViewer());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected synchronized void installLineProxy(int index, Object element) {
        IModelProxy proxy;
        IModelProxyFactory modelProxyFactory = this.getModelProxyFactoryAdapter(element);
        if (modelProxyFactory != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
            this.fLineProxies.add(index, proxy);
            Job job = new Job("Model Proxy installed notification job"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        proxy.init(DocumentContentProvider.this.getPresentationContext());
                        proxy.addModelChangedListener((IModelChangedListener)DocumentContentProvider.this);
                        proxy.installed((Viewer)DocumentContentProvider.this.getViewer());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected IModelProxyFactory getModelProxyFactoryAdapter(Object element) {
        IModelProxyFactory adapter = null;
        if (element instanceof IModelProxyFactory) {
            adapter = (IModelProxyFactory)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IModelProxyFactory)adaptable.getAdapter(IModelProxyFactory.class);
        }
        return adapter;
    }

    protected IPresentationContext getPresentationContext() {
        return this.getDocument().getPresentationContext();
    }

    protected synchronized void disposeRootProxy() {
        this.disposeBaseProxy();
        if (this.fRootProxy != null) {
            this.fRootProxy.dispose();
        }
        this.fRootProxy = null;
    }

    protected synchronized void disposeBaseProxy() {
        this.disposeLineProxies();
        if (this.fBaseProxy != null) {
            this.fBaseProxy.dispose();
        }
        this.fBaseProxy = null;
    }

    protected synchronized void disposeLineProxies() {
        for (IModelProxy proxy : this.fLineProxies) {
            proxy.dispose();
        }
        this.fLineProxies.clear();
    }

    protected VirtualSourceViewer getViewer() {
        return this.fViewer;
    }

    synchronized void schedule(DocumentUpdate update) {
        if (this.fUpdateInProgress != null) {
            if (update instanceof DocumentBaseChangeUpdate) {
                this.fUpdateInProgress.cancel();
                this.fUpdateInProgress.done();
                this.fUpdateInProgress = update;
                this.fUpdateInProgress.start();
            } else if (this.fUpdateInProgress instanceof DocumentBaseChangeUpdate && update instanceof DocumentContentUpdate) {
                update.cancel();
                update.done();
            } else if (this.fUpdateInProgress instanceof DocumentContentUpdate && update instanceof DocumentBaseChangeUpdate) {
                this.fUpdateInProgress.cancel();
                this.fUpdateInProgress.done();
                this.fUpdateInProgress = update;
                this.fUpdateInProgress.start();
            }
        } else {
            this.fUpdateInProgress = update;
            this.fUpdateInProgress.start();
        }
    }

    private int getElementIndex(Object element) {
        Integer index = this.fLineElements.get(element);
        return index != null ? index : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getElementAtLine(int lineNumber) {
        Map<Object, Integer> map = this.fLineElements;
        synchronized (map) {
            for (Object element : this.fLineElements.keySet()) {
                if (this.fLineElements.get(element) != lineNumber) continue;
                return element;
            }
        }
        return null;
    }
}

