/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.widgets;

import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.LaunchModeProblemPreference;
import org.eclipse.cdt.codan.core.param.MapProblemPreference;
import org.eclipse.cdt.codan.core.param.RootProblemPreference;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.preferences.LaunchModesPropertyPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LaunchingTabComposite
extends Composite {
    private LaunchModesPropertyPage page;
    private IProblem problem;
    private PreferenceStore prefStore;
    private LaunchModeProblemPreference launchPref;

    public LaunchingTabComposite(Composite parent, IProblem problem, IResource resource) {
        super(parent, 0);
        if (problem == null) {
            throw new NullPointerException();
        }
        this.setLayout((Layout)new GridLayout(2, false));
        this.problem = problem;
        this.prefStore = new PreferenceStore();
        IProblemPreference info = problem.getPreference();
        if (info == null || !(info instanceof RootProblemPreference)) {
            Label label = new Label((Composite)this, 0);
            label.setText(CodanUIMessages.ParametersComposite_None);
            return;
        }
        LaunchModeProblemPreference launchModes = ((RootProblemPreference)info).getLaunchModePreference();
        this.launchPref = (LaunchModeProblemPreference)launchModes.clone();
        this.initPrefStore();
        this.page = new LaunchModesPropertyPage(problem, this.prefStore);
        this.page.noDefaultAndApplyButton();
        this.page.createControl(parent);
        this.page.getControl().setLayoutData((Object)new GridData(1808));
    }

    public void save(IProblemWorkingCopy problem) {
        if (this.page != null) {
            this.page.performOk();
        }
        this.savePrefStore(problem);
    }

    private void savePrefStore(IProblemWorkingCopy problem) {
        if (this.launchPref == null) {
            return;
        }
        this.saveToPref(this.launchPref, this.page.getPreferenceStore());
        MapProblemPreference parentMap = (MapProblemPreference)problem.getPreference();
        parentMap.addChildDescriptor((IProblemPreference)this.launchPref.clone());
    }

    private void saveToPref(LaunchModeProblemPreference launchPref, IPreferenceStore preferenceStore) {
        CheckerLaunchMode[] values = CheckerLaunchMode.values();
        int i = 0;
        while (i < values.length) {
            CheckerLaunchMode checkerLaunchMode = values[i];
            String name = checkerLaunchMode.name();
            if (!preferenceStore.isDefault(name)) {
                boolean value = preferenceStore.getBoolean(name);
                launchPref.setRunningMode(checkerLaunchMode, value);
            }
            ++i;
        }
    }

    private void initPrefStore() {
        if (this.launchPref == null) {
            return;
        }
        CheckerLaunchMode[] values = CheckerLaunchMode.values();
        int i = 0;
        while (i < values.length) {
            CheckerLaunchMode checkerLaunchMode = values[i];
            this.prefStore.setDefault(checkerLaunchMode.name(), true);
            this.prefStore.setValue(checkerLaunchMode.name(), this.launchPref.isRunningInMode(checkerLaunchMode));
            ++i;
        }
    }

    public IProblem getProblem() {
        return this.problem;
    }
}

