/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ExternalEditorInput;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.ITranslationUnitEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EditorUtility {
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";

    private EditorUtility() {
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = CUIPlugin.getActivePage()) != null) {
            return p.openEditor(input, editorID, activate);
        }
        return null;
    }

    private static IEditorInput getEditorInput(ICElement element) {
        while (element != null) {
            ITranslationUnit tu;
            if (element instanceof ISourceReference && (tu = ((ISourceReference)element).getTranslationUnit()) != null) {
                element = tu;
            }
            if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                element = ((IWorkingCopy)element).getOriginalElement();
            }
            if (element instanceof ITranslationUnit) {
                ITranslationUnit unit = (ITranslationUnit)element;
                IResource resource = unit.getResource();
                if (resource instanceof IFile) {
                    return new FileEditorInput((IFile)resource);
                }
                return new ExternalEditorInput(unit, (IStorage)new FileStorage(unit.getPath()));
            }
            if (element instanceof IBinary) {
                return new ExternalEditorInput(EditorUtility.getStorage((IBinary)element), null);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) {
        if (input instanceof ICElement) {
            return EditorUtility.getEditorInput((ICElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof IStorage) {
            return new ExternalEditorInput((IStorage)input);
        }
        return null;
    }

    public static IEditorPart openInEditor(IPath location, ICElement element) throws PartInitException {
        IEditorInput input = EditorUtility.getEditorInputForLocation(location, element);
        return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, element), true);
    }

    public static IEditorInput getEditorInputForLocation(IPath location, ICElement context) {
        ICProject cproject;
        IFile resource = EditorUtility.getWorkspaceFileAtLocation(location, context);
        if (resource != null) {
            return new FileEditorInput(resource);
        }
        if (context == null) {
            try {
                ICProject[] projects = CCorePlugin.getDefault().getCoreModel().getCModel().getCProjects();
                int i = 0;
                block2: while (i < projects.length) {
                    IIncludeReference[] includeReferences = projects[i].getIncludeReferences();
                    int j = 0;
                    while (j < includeReferences.length) {
                        if (includeReferences[j].isOnIncludeEntry(location)) {
                            context = projects[i];
                            break block2;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (context == null && projects.length > 0) {
                    context = projects[0];
                }
            }
            catch (CModelException projects) {
                // empty catch block
            }
        }
        if (context != null && (cproject = context.getCProject()) != null) {
            ITranslationUnit unit = CoreModel.getDefault().createTranslationUnitFrom(cproject, location);
            if (unit != null) {
                return new ExternalEditorInput(unit, (IStorage)new FileStorage(location));
            }
            IProject markerResource = cproject.getProject();
            return new ExternalEditorInput((IStorage)new FileStorage(location), (IResource)markerResource);
        }
        return new ExternalEditorInput((IStorage)new FileStorage(location));
    }

    private static IFile getWorkspaceFileAtLocation(IPath location, ICElement context) {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
        if (file == null) {
            ICProject cProject;
            IProject project = null;
            if (context != null && (cProject = context.getCProject()) != null) {
                project = cProject.getProject();
            }
            IFile bestMatch = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] files = root.findFilesForLocationURI(URIUtil.toURI((IPath)location));
            int i = 0;
            while (i < files.length) {
                file = files[i];
                if (file.isAccessible()) {
                    if (project != null && file.getProject() == project) {
                        bestMatch = file;
                        break;
                    }
                    if (bestMatch == null) {
                        bestMatch = file;
                        if (project == null) break;
                    }
                }
                ++i;
            }
            return bestMatch;
        }
        return file;
    }

    public static String getEditorID(String name) {
        IEditorDescriptor descriptor;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry != null && (descriptor = registry.getDefaultEditor(name)) != null) {
            return descriptor.getId();
        }
        return DEFAULT_TEXT_EDITOR_ID;
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        Object editorInput;
        ITranslationUnit tunit = null;
        if (inputObject instanceof ITranslationUnit) {
            tunit = (ITranslationUnit)inputObject;
        } else if (input instanceof IFileEditorInput) {
            editorInput = (IFileEditorInput)input;
            IFile file = editorInput.getFile();
            ICElement celement = CoreModel.getDefault().create(file);
            if (celement instanceof ITranslationUnit) {
                tunit = (ITranslationUnit)celement;
            }
        } else if (input instanceof ITranslationUnitEditorInput) {
            editorInput = (ITranslationUnitEditorInput)input;
            tunit = editorInput.getTranslationUnit();
        }
        if (tunit != null) {
            String contentTypeId = tunit.getContentTypeId();
            if (contentTypeId != null) {
                IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                IEditorDescriptor desc = registry.getDefaultEditor(input.getName(), contentType);
                if (desc != null) {
                    return desc.getId();
                }
            }
            if (tunit.isCLanguage()) {
                return "org.eclipse.cdt.ui.editor.CEditor";
            }
            if (tunit.isCXXLanguage()) {
                return "org.eclipse.cdt.ui.editor.CEditor";
            }
            if (tunit.isASMLanguage()) {
                return "org.eclipse.cdt.ui.editor.asm.AsmEditor";
            }
        }
        String editorId = EditorUtility.getEditorID(input.getName());
        return editorId;
    }

    public static IStorage getStorage(IBinary bin) {
        FileStorage store = null;
        try {
            IBuffer buffer = bin.getBuffer();
            if (buffer != null) {
                store = new FileStorage((InputStream)new ByteArrayInputStream(buffer.getContents().getBytes()), bin.getPath());
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return store;
    }
}

