/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.projectimport;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.util.Pair;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.gradle.tooling.ProgressListener;

public final class ProjectPreviewJob
extends ToolingApiWorkspaceJob {
    private final BuildConfiguration buildConfig;
    private final AsyncHandler initializer;
    private Pair<OmniBuildEnvironment, OmniGradleBuild> result;

    public ProjectPreviewJob(ProjectImportConfiguration configuration, List<ProgressListener> listeners, AsyncHandler initializer, final FutureCallback<Pair<OmniBuildEnvironment, OmniGradleBuild>> resultHandler) {
        super("Loading Gradle project preview");
        this.buildConfig = configuration.toBuildConfig();
        this.initializer = (AsyncHandler)Preconditions.checkNotNull((Object)initializer);
        this.result = null;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    resultHandler.onSuccess((Object)ProjectPreviewJob.this.result);
                } else {
                    resultHandler.onFailure(event.getResult().getException());
                }
            }
        });
    }

    @Override
    protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) throws Exception {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        this.initializer.run((IProgressMonitor)progress.newChild(10), this.getToken());
        OmniBuildEnvironment buildEnvironment = this.fetchBuildEnvironment((IProgressMonitor)progress.newChild(2));
        OmniGradleBuild gradleBuild = this.fetchGradleBuildStructure((IProgressMonitor)progress.newChild(8));
        this.result = new Pair((Object)buildEnvironment, (Object)gradleBuild);
    }

    private OmniBuildEnvironment fetchBuildEnvironment(IProgressMonitor monitor) {
        ModelProvider modelProvider = CorePlugin.gradleWorkspaceManager().getGradleBuild(this.buildConfig).getModelProvider();
        return modelProvider.fetchBuildEnvironment(FetchStrategy.FORCE_RELOAD, this.getToken(), monitor);
    }

    private OmniGradleBuild fetchGradleBuildStructure(IProgressMonitor monitor) {
        ModelProvider modelProvider = CorePlugin.gradleWorkspaceManager().getGradleBuild(this.buildConfig).getModelProvider();
        return modelProvider.fetchGradleBuild(FetchStrategy.FORCE_RELOAD, this.getToken(), monitor);
    }
}

