/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.bpel.model.messageproperties.MessagepropertiesFactory;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.model.messageproperties.PropertyAlias;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.AddImportCommand;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.details.providers.ColumnTableProvider;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.PropertyAliasContentProvider;
import org.eclipse.bpel.ui.details.providers.PropertyAliasFilter;
import org.eclipse.bpel.ui.dialogs.EditPropertyAliasDialog;
import org.eclipse.bpel.ui.util.BrowseUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.WSDLImportHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class EditMessagePropertyDialog
extends Dialog {
    protected static final int BID_USE_TYPE = 1054;
    protected static final int BID_USE_ELEMENT = 1055;
    protected boolean isNew;
    protected boolean isReplacement;
    protected Property property;
    protected Object propertyType;
    protected XSDTypeDefinition xsdTypeDefinition;
    protected XSDElementDeclaration xsdElementDeclaration;
    protected IFile targetFile;
    protected URI propertyTypeFileURI;
    protected BPELEditor bpelEditor;
    protected List newAliasesList = new ArrayList();
    protected Text propertyNameText;
    protected Label typeOrElementNameLabel;
    protected Label typeOrElementNameText;
    private Button typeRadio;
    private Button elementRadio;
    private int typeOrElement;
    protected Button browseTypeButton;
    protected Button newAliasButton;
    protected Button editAliasButton;
    protected Button removeAliasButton;
    protected Table aliasesTable;
    protected ColumnTableProvider aliasesTableProvider;
    protected TableViewer aliasesTableViewer;
    protected PropertyAliasFilter aliasesFilter;
    protected Set existingPropertyNames;
    protected TabbedPropertySheetWidgetFactory wf;

    public EditMessagePropertyDialog(Shell parentShell, Property property, String newPropertyName, BPELEditor bpelEditor, TabbedPropertySheetWidgetFactory wf) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.bpelEditor = bpelEditor;
        this.property = property;
        this.wf = wf;
        this.isNew = property == null;
        boolean bl = this.isReplacement = property != null && property.eIsProxy();
        if (this.isReplacement) {
            newPropertyName = property.getName();
        }
        if (this.isNew || this.isReplacement) {
            this.targetFile = bpelEditor.getEditModelClient().getArtifactsResourceInfo().getFile();
            this.property = MessagepropertiesFactory.eINSTANCE.createProperty();
            this.property.setName(newPropertyName);
            this.typeOrElement = 1054;
        } else {
            Object type = property.getType();
            if (type instanceof XSDTypeDefinition) {
                this.propertyType = type;
                this.xsdTypeDefinition = (XSDTypeDefinition)type;
                this.typeOrElement = 1054;
            } else if (type instanceof XSDElementDeclaration) {
                this.propertyType = type;
                this.xsdElementDeclaration = (XSDElementDeclaration)type;
                this.typeOrElement = 1055;
            } else {
                this.typeOrElement = 1054;
            }
        }
    }

    public Property getProperty() {
        return this.property;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        Listener enablementListener = new Listener(){

            public void handleEvent(Event e) {
                EditMessagePropertyDialog.this.updateEnablement();
            }
        };
        Label propertyNameLabel = new Label(composite, 0);
        propertyNameLabel.setText(Messages.EditMessagePropertyDialog_14);
        this.propertyNameText = new Text(composite, 2048);
        if (this.property != null) {
            String s = this.property.getName();
            this.propertyNameText.setText(s == null ? "" : s);
        }
        this.propertyNameText.addListener(24, enablementListener);
        if (this.isReplacement) {
            this.propertyNameText.setEnabled(false);
        }
        String groupText = Messages.EditMessagePropertyDialog_10;
        Group typeOrElementRadioGroup = new Group(composite, 16);
        typeOrElementRadioGroup.setText(groupText);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 1;
        typeOrElementRadioGroup.setLayout((Layout)layout);
        this.typeRadio = this.createRadioButton((Composite)typeOrElementRadioGroup, Messages.EditMessagePropertyDialog_11, 1054, this.typeOrElement == 1054);
        this.elementRadio = this.createRadioButton((Composite)typeOrElementRadioGroup, Messages.EditMessagePropertyDialog_12, 1055, this.typeOrElement == 1055);
        this.typeRadio.addListener(13, enablementListener);
        this.elementRadio.addListener(13, enablementListener);
        this.typeOrElementNameLabel = new Label(composite, 0);
        this.typeOrElementNameText = new Label(composite, 0);
        this.browseTypeButton = new Button(composite, 8);
        this.browseTypeButton.setText(Messages.EditMessagePropertyDialog_18);
        this.browseTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditMessagePropertyDialog.this.browsePropertyType();
            }
        });
        Label separator = new Label(composite, 259);
        Label aliasesLabel = new Label(composite, 0);
        aliasesLabel.setText(Messages.EditMessagePropertyDialog_20);
        Composite c2 = new Composite(composite, 0);
        this.newAliasButton = new Button(c2, 8);
        this.newAliasButton.setText(Messages.EditMessagePropertyDialog_21);
        this.newAliasButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditMessagePropertyDialog.this.createAlias();
            }
        });
        this.editAliasButton = new Button(c2, 8);
        this.editAliasButton.setText(Messages.EditMessagePropertyDialog_22);
        this.editAliasButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection sel = (IStructuredSelection)EditMessagePropertyDialog.this.aliasesTableViewer.getSelection();
                PropertyAlias alias = (PropertyAlias)sel.getFirstElement();
                EditMessagePropertyDialog.this.editAlias(alias);
            }
        });
        this.removeAliasButton = new Button(c2, 8);
        this.removeAliasButton.setText(Messages.EditMessagePropertyDialog_23);
        this.removeAliasButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection sel = (IStructuredSelection)EditMessagePropertyDialog.this.aliasesTableViewer.getSelection();
                PropertyAlias alias = (PropertyAlias)sel.getFirstElement();
                Definition definition = EditMessagePropertyDialog.this.property.getEnclosingDefinition();
                if (definition != null) {
                    definition.getEExtensibilityElements().remove((Object)alias);
                } else {
                    EditMessagePropertyDialog.this.newAliasesList.remove(alias);
                }
                EditMessagePropertyDialog.this.updatePropertyAliasTable();
            }
        });
        this.aliasesTable = new Table(composite, 68096);
        this.aliasesTable.setLinesVisible(true);
        this.aliasesTable.setHeaderVisible(true);
        this.aliasesTableProvider = new ColumnTableProvider();
        this.aliasesTableProvider.add(new MessageTypeColumn());
        this.aliasesTableProvider.add(new XSDElementColumn());
        this.aliasesTableProvider.add(new XSDTypeColumn());
        this.aliasesTableViewer = new TableViewer(this.aliasesTable);
        this.aliasesTableProvider.createTableLayout(this.aliasesTable);
        this.aliasesTableViewer.setLabelProvider((IBaseLabelProvider)this.aliasesTableProvider);
        this.aliasesTableViewer.setContentProvider((IContentProvider)new PropertyAliasContentProvider(){

            @Override
            public Object[] getElements(Object input) {
                Object[] superResult = super.getElements(input);
                Object[] result = new Object[superResult.length + EditMessagePropertyDialog.this.newAliasesList.size()];
                System.arraycopy(superResult, 0, result, 0, superResult.length);
                int i = superResult.length;
                Iterator it = EditMessagePropertyDialog.this.newAliasesList.iterator();
                while (it.hasNext()) {
                    result[i++] = it.next();
                }
                return result;
            }
        });
        this.aliasesTableViewer.setColumnProperties(this.aliasesTableProvider.getColumnProperties());
        this.aliasesFilter = new PropertyAliasFilter();
        this.aliasesTableViewer.addFilter((ViewerFilter)this.aliasesFilter);
        this.aliasesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditMessagePropertyDialog.this.updateEnablement();
            }
        });
        this.updateTypeWidgets();
        this.updatePropertyAliasTable();
        this.updateTypeFileText();
        GridData data = new GridData(32);
        data.horizontalSpan = 1;
        propertyNameLabel.setLayoutData((Object)data);
        data = new GridData(800);
        data.horizontalSpan = 2;
        this.propertyNameText.setLayoutData((Object)data);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        typeOrElementRadioGroup.setLayoutData((Object)data);
        data = new GridData(768);
        this.typeRadio.setLayoutData((Object)data);
        data = new GridData(768);
        this.elementRadio.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        separator.setLayoutData((Object)data);
        data = new GridData(32);
        this.typeOrElementNameLabel.setLayoutData((Object)data);
        data = new GridData(800);
        this.typeOrElementNameText.setLayoutData((Object)data);
        data = new GridData(128);
        this.browseTypeButton.setLayoutData((Object)data);
        data = new GridData(32);
        aliasesLabel.setLayoutData((Object)data);
        data = new GridData(128);
        data.horizontalSpan = 2;
        c2.setLayoutData((Object)data);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c2.setLayout((Layout)layout);
        data = new GridData(128);
        this.newAliasButton.setLayoutData((Object)data);
        data = new GridData(128);
        this.editAliasButton.setLayoutData((Object)data);
        data = new GridData(128);
        this.removeAliasButton.setLayoutData((Object)data);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 3;
        data.heightHint = 200;
        data.widthHint = 500;
        this.aliasesTable.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpel.ui.property_dialog");
        composite.pack();
        return composite;
    }

    protected Button createRadioButton(Composite parent, String label, int id, boolean checked) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                int val = (Integer)b.getData();
                EditMessagePropertyDialog.this.buttonPressed(val, b.getSelection(), true);
            }
        });
        return button;
    }

    protected void buttonPressed(int id, boolean checked, boolean bRefresh) {
        switch (id) {
            case 1054: 
            case 1055: {
                if (!checked) {
                    return;
                }
                this.typeOrElement = id;
                break;
            }
        }
        if (bRefresh) {
            this.updateTypeWidgets();
        }
    }

    protected void updatePropertyAliasTable() {
        this.aliasesFilter.setProperty(this.property);
        this.aliasesTableViewer.setInput((Object)this.bpelEditor.getProcess());
    }

    protected void updateTypeFileText() {
        if (this.propertyType instanceof XSDTypeDefinition) {
            this.xsdTypeDefinition = (XSDTypeDefinition)this.propertyType;
            this.typeOrElementNameText.setText(this.xsdTypeDefinition.getName());
        } else if (this.propertyType instanceof XSDElementDeclaration) {
            this.xsdElementDeclaration = (XSDElementDeclaration)this.propertyType;
            this.typeOrElementNameText.setText(this.xsdElementDeclaration.getName());
        } else {
            this.typeOrElementNameText.setText("");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isNew) {
            newShell.setText(Messages.EditMessagePropertyDialog_26);
        } else {
            newShell.setText(Messages.EditMessagePropertyDialog_27);
        }
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.updateEnablement();
        return result;
    }

    protected void updateEnablement() {
        Button okButton;
        boolean isOK = true;
        if (this.targetFile == null && this.property.eResource() == null || !this.isPropertyNameValid() || this.propertyType == null) {
            isOK = false;
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(isOK);
        }
        this.newAliasButton.setEnabled(isOK);
        this.editAliasButton.setEnabled(isOK &= !this.aliasesTableViewer.getSelection().isEmpty());
        this.removeAliasButton.setEnabled(isOK);
    }

    protected boolean isPropertyNameValid() {
        String name = this.propertyNameText.getText();
        if (name == null) {
            return false;
        }
        if ("".equals(name)) {
            return false;
        }
        return !this.propertyNameExists(name);
    }

    protected boolean propertyNameExists(String name) {
        if (!this.isNew && name.equals(this.property.getName())) {
            return false;
        }
        return !this.isReplacement && this.getExistingPropertyNames().contains(name);
    }

    protected Set getExistingPropertyNames() {
        if (this.existingPropertyNames == null) {
            Set<Property> properties = ModelHelper.getAvailableProperties(this.bpelEditor.getProcess());
            this.existingPropertyNames = new HashSet();
            for (Property prop : properties) {
                this.existingPropertyNames.add(prop.getName());
            }
        }
        return this.existingPropertyNames;
    }

    protected void updateTypeWidgets() {
        if (this.typeOrElement == 1055) {
            this.typeOrElementNameLabel.setText(Messages.EditMessagePropertyDialog_Element_1);
            this.typeRadio.setSelection(false);
            this.elementRadio.setSelection(true);
            this.propertyType = this.xsdElementDeclaration;
        } else {
            this.typeOrElementNameLabel.setText(Messages.EditMessagePropertyDialog_Type_1);
            this.typeRadio.setSelection(true);
            this.elementRadio.setSelection(false);
            this.propertyType = this.xsdTypeDefinition;
        }
        this.typeOrElementNameLabel.pack();
        this.updateTypeFileText();
    }

    protected void browsePropertyType() {
        Object type = null;
        Object[] result = null;
        result = this.typeOrElement == 1054 ? BrowseUtil.browseForXSDType((EObject)this.bpelEditor.getProcess(), this.getShell()) : BrowseUtil.browseForXSDElement((EObject)this.bpelEditor.getProcess(), this.getShell(), false);
        if (result != null && result.length >= 1) {
            type = result[0];
        }
        if (type != null) {
            this.propertyType = type;
            if (this.typeOrElement == 1055) {
                this.xsdElementDeclaration = (XSDElementDeclaration)type;
            } else {
                this.xsdTypeDefinition = (XSDTypeDefinition)type;
            }
            this.updateTypeFileText();
            this.updateEnablement();
        }
    }

    protected URI getTargetFileURI() {
        if (this.targetFile != null) {
            return URI.createPlatformResourceURI((String)this.targetFile.getFullPath().toString());
        }
        return this.property.eResource().getURI();
    }

    protected void okPressed() {
        this.createProperty();
        super.okPressed();
    }

    protected void createProperty() {
        URI uri = this.getTargetFileURI();
        final Resource resource = this.bpelEditor.getResourceSet().getResource(uri, true);
        final Definition definition = (Definition)resource.getContents().get(0);
        this.bpelEditor.getCommandFramework().execute((Command)new AutoUndoCommand((EObject)definition){

            @Override
            public void doExecute() {
                if (EditMessagePropertyDialog.this.isNew) {
                    definition.getEExtensibilityElements().add((Object)EditMessagePropertyDialog.this.property);
                    EditMessagePropertyDialog.this.property.setEnclosingDefinition(definition);
                    for (PropertyAlias alias : EditMessagePropertyDialog.this.newAliasesList) {
                        definition.getEExtensibilityElements().add((Object)alias);
                        alias.setEnclosingDefinition(definition);
                    }
                    EditMessagePropertyDialog.this.newAliasesList.clear();
                } else if (EditMessagePropertyDialog.this.isReplacement) {
                    boolean found = false;
                    for (Object obj : definition.getEExtensibilityElements()) {
                        if (!(obj instanceof Property) || !((Property)obj).getName().equals(EditMessagePropertyDialog.this.property.getName())) continue;
                        EditMessagePropertyDialog.this.property = (Property)obj;
                        found = true;
                        break;
                    }
                    if (!found) {
                        definition.getEExtensibilityElements().add((Object)EditMessagePropertyDialog.this.property);
                        EditMessagePropertyDialog.this.property.setEnclosingDefinition(definition);
                    }
                }
                EditMessagePropertyDialog.this.property.setName(EditMessagePropertyDialog.this.propertyNameText.getText());
                EditMessagePropertyDialog.this.property.setType(EditMessagePropertyDialog.this.propertyType);
                WSDLImportHelper.addAllImportsAndNamespaces(definition, (IResource)EditMessagePropertyDialog.this.bpelEditor.getEditModelClient().getPrimaryResourceInfo().getFile());
                if (definition.getPrefix("http://www.w3.org/2001/XMLSchema") == null) {
                    definition.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
                }
                if (EditMessagePropertyDialog.this.targetFile != null && !EditMessagePropertyDialog.this.targetFile.exists()) {
                    AddImportCommand cmd = new AddImportCommand(EditMessagePropertyDialog.this.bpelEditor.getProcess(), definition, null);
                    if (cmd.canDoExecute() && !cmd.wouldCreateDuplicateImport()) {
                        EditMessagePropertyDialog.this.bpelEditor.getCommandStack().execute((Command)cmd);
                    }
                    try {
                        resource.setModified(true);
                        resource.save(resource.getResourceSet().getLoadOptions());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    protected void createAlias() {
        PropertyAlias alias;
        EditPropertyAliasDialog dialog = new EditPropertyAliasDialog(this.getShell(), this.property, null, this.bpelEditor, this.wf);
        if (dialog.open() == 0 && (alias = dialog.getPropertyAlias()) != null) {
            URI uri = this.getTargetFileURI();
            Resource resource = this.bpelEditor.getResourceSet().getResource(uri, true);
            final Definition definition = (Definition)resource.getContents().get(0);
            this.bpelEditor.getCommandFramework().execute((Command)new AutoUndoCommand((EObject)definition){

                @Override
                public void doExecute() {
                    if (EditMessagePropertyDialog.this.isNew) {
                        EditMessagePropertyDialog.this.newAliasesList.add(alias);
                    } else {
                        if (EditMessagePropertyDialog.this.isReplacement) {
                            alias.setPropertyName((Object)EditMessagePropertyDialog.this.property);
                        }
                        alias.setEnclosingDefinition(definition);
                        definition.getEExtensibilityElements().add((Object)alias);
                    }
                    Definition imported = null;
                    Object messageTypeObject = alias.getMessageType();
                    Object xsdElementObject = alias.getXSDElement();
                    Object typeObject = alias.getType();
                    if (messageTypeObject instanceof Message) {
                        imported = ((Message)messageTypeObject).getEnclosingDefinition();
                    } else if (xsdElementObject instanceof XSDElementDeclaration) {
                        XSDElementDeclaration top = (XSDElementDeclaration)xsdElementObject;
                        while (top.eContainer() != null) {
                            if (!((top = top.eContainer()) instanceof Definition)) continue;
                            imported = top;
                            break;
                        }
                    } else if (typeObject instanceof XSDTypeDefinition) {
                        XSDTypeDefinition top = (XSDTypeDefinition)typeObject;
                        while (top.eContainer() != null) {
                            if (!((top = top.eContainer()) instanceof Definition)) continue;
                            imported = top;
                            break;
                        }
                    }
                    if (imported instanceof Definition) {
                        WSDLImportHelper.addImportAndNamespace(definition, imported);
                    } else if (imported instanceof XSDSchema) {
                        WSDLImportHelper.addImportAndNamespace(definition, (XSDSchema)imported, (IResource)EditMessagePropertyDialog.this.bpelEditor.getEditModelClient().getPrimaryResourceInfo().getFile());
                    }
                    ((DefinitionImpl)definition).updateElement();
                }
            });
            this.updatePropertyAliasTable();
        }
    }

    protected void editAlias(PropertyAlias alias) {
        EditPropertyAliasDialog dialog;
        if (alias != null && (dialog = new EditPropertyAliasDialog(this.getShell(), this.property, alias, this.bpelEditor, this.wf)).open() == 0) {
            this.updatePropertyAliasTable();
        }
    }

    public class MessageTypeColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        ModelLabelProvider labelProvider = new ModelLabelProvider();

        @Override
        public String getHeaderText() {
            return Messages.EditMessagePropertyDialog_1;
        }

        @Override
        public String getProperty() {
            return "aliasMsgType";
        }

        @Override
        public int getInitialWeight() {
            return 50;
        }

        public String getText(Object element) {
            PropertyAlias alias = (PropertyAlias)element;
            String part = alias.getPart();
            Object message = ((PropertyAlias)element).getMessageType();
            String s = "";
            if (message != null) {
                String query;
                s = String.valueOf(this.labelProvider.getText(message)) + (part == null ? "" : "." + part);
                if (part != null && alias.getQuery() != null && (query = alias.getQuery().getValue()) != null && !"".equals(query)) {
                    s = String.valueOf(s) + NLS.bind((String)Messages.EditMessagePropertyDialog_4, (Object[])new Object[]{query});
                }
            }
            return s;
        }
    }

    public class XSDElementColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        @Override
        public String getHeaderText() {
            return Messages.EditMessagePropertyDialog_15;
        }

        @Override
        public String getProperty() {
            return "aliasElement";
        }

        @Override
        public int getInitialWeight() {
            return 25;
        }

        public String getText(Object element) {
            String query;
            String s;
            PropertyAlias alias = (PropertyAlias)element;
            XSDNamedComponent xsdElem = (XSDNamedComponent)alias.getXSDElement();
            String string = s = xsdElem == null ? "" : xsdElem.getName();
            if (xsdElem != null && alias.getQuery() != null && (query = alias.getQuery().getValue()) != null && !"".equals(query)) {
                s = String.valueOf(s) + NLS.bind((String)Messages.EditMessagePropertyDialog_4, (Object[])new Object[]{query});
            }
            return s;
        }
    }

    public class XSDTypeColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        @Override
        public String getHeaderText() {
            return Messages.EditMessagePropertyDialog_16;
        }

        @Override
        public String getProperty() {
            return "aliasType";
        }

        @Override
        public int getInitialWeight() {
            return 25;
        }

        public String getText(Object element) {
            String query;
            String s;
            PropertyAlias alias = (PropertyAlias)element;
            XSDNamedComponent xsdElem = (XSDNamedComponent)alias.getType();
            String string = s = xsdElem == null ? "" : xsdElem.getName();
            if (xsdElem != null && alias.getQuery() != null && (query = alias.getQuery().getValue()) != null && !"".equals(query)) {
                s = String.valueOf(s) + NLS.bind((String)Messages.EditMessagePropertyDialog_4, (Object[])new Object[]{query});
            }
            return s;
        }
    }
}

