/*************************************************************************************
 * Copyright (c) 2004 Actuate Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Actuate Corporation - Initial implementation.
 ************************************************************************************/

package org.eclipse.birt.report.presentation.aggregation.control;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;

/**
 * Fragment for report tool bar.
 * <p>
 * @see BaseFragment
 */
public class BaseControlFragment extends BirtBaseFragment
{
	/**
	 * Base class implementation of post service process.
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	protected String doPostService( HttpServletRequest request, HttpServletResponse response ) throws ServletException, IOException
    {
		String className = getClass( ).getName( ).substring( getClass( ).getName( ).lastIndexOf ('.' ) + 1 );
		return JSPRootPath + "/pages/control/" + className + ".jsp"; //$NON-NLS-1$  //$NON-NLS-2$
    }
}
