/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.NativeDataTypeUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.ReportParamUpdater;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.StaticValues;

class DataSetParameterUpdater {
    private List<OdaDataSetParameterHandle> setDefinedParams = null;
    OdaDataSetParameter newParam = null;
    private String dataSourceId = null;
    private String dataSetId = null;
    protected ParameterDefinition paramDefn = null;
    private ModuleHandle module = null;
    private OdaDataSetHandle setHandle;

    DataSetParameterUpdater(OdaDataSetParameter param, ParameterDefinition paramDefn, OdaDataSetHandle setHandle, String dataSourceId, String dataSetId, List<OdaDataSetParameterHandle> setDefinedParams) {
        this.paramDefn = paramDefn;
        this.newParam = param;
        this.module = setHandle.getModuleHandle();
        this.setHandle = setHandle;
        this.dataSourceId = dataSourceId;
        this.dataSetId = dataSetId;
        this.setDefinedParams = setDefinedParams;
    }

    void process() throws SemanticException {
        DataElementAttributes dataAttrs = this.paramDefn.getAttributes();
        this.processDataElementAttributes(dataAttrs);
        ParameterMode inOutMode = this.paramDefn.getInOutMode();
        this.processInOutMode(inOutMode);
        InputElementAttributes inputElementAttrs = this.paramDefn.getEditableInputElementAttributes();
        this.processInputElementAttributes(inputElementAttrs);
        this.processLinkedReportParameter();
    }

    private void processDataElementAttributes(DataElementAttributes dataAttrs) {
        if (dataAttrs == null) {
            return;
        }
        String nativeName = dataAttrs.getName();
        String name = this.newParam.getName();
        if (StringUtil.isBlank((String)name) || !StringUtil.isBlank((String)nativeName) && !name.equalsIgnoreCase(nativeName)) {
            this.newParam.setName(nativeName);
        }
        this.newParam.setNativeName(nativeName);
        this.newParam.setPosition(Integer.valueOf(dataAttrs.getPosition()));
        Integer newPos = 0;
        Integer pos = this.newParam.getPosition();
        if (pos == null || pos < 0) {
            this.newParam.setPosition(newPos);
        }
        this.newParam.setNativeDataType(Integer.valueOf(dataAttrs.getNativeDataTypeCode()));
        String dataType = this.getROMDataType(this.dataSourceId, this.dataSetId, this.newParam, this.setDefinedParams.iterator());
        if (dataType == null || !"boolean".equalsIgnoreCase(dataType)) {
            this.newParam.setParameterDataType(dataType);
        }
        ElementNullability nullability = dataAttrs.getNullability();
        this.processElementNullability(nullability);
    }

    private void processElementNullability(ElementNullability nullability) {
        switch (nullability.getValue()) {
            case 1: {
                this.newParam.setAllowNull(true);
                break;
            }
            case 2: {
                this.newParam.setAllowNull(false);
                break;
            }
        }
    }

    private void processInOutMode(ParameterMode mode) {
        if (mode == null) {
            return;
        }
        switch (mode.getValue()) {
            case 2: {
                this.newParam.setIsInput(true);
                this.newParam.setIsOutput(true);
                break;
            }
            case 0: {
                this.newParam.setIsInput(true);
                break;
            }
            case 1: {
                this.newParam.setIsOutput(true);
            }
        }
    }

    private void processInputElementAttributes(InputElementAttributes attrs) {
        boolean withLinkedParameter = !StringUtil.isBlank((String)this.newParam.getParamName());
        StaticValues newValues = attrs.getDefaultValues();
        Object newValue = null;
        if (newValues != null && !newValues.isEmpty()) {
            newValue = newValues.getValues().get(0);
        }
        if (!withLinkedParameter) {
            this.setROMDefaultValue((DataSetParameter)this.newParam, newValue);
        }
        this.newParam.setIsOptional(Boolean.valueOf(attrs.isOptional()).booleanValue());
    }

    private void setROMDefaultValue(DataSetParameter setParam, Object newValue) {
        setParam.setExpressionProperty("defaultValue", AdapterUtil.createExpression(newValue));
    }

    private void processLinkedReportParameter() throws SemanticException {
        String reportParamName = this.newParam.getParamName();
        if (StringUtil.isBlank((String)reportParamName)) {
            return;
        }
        ScalarParameterHandle reportParam = (ScalarParameterHandle)this.module.findParameter(reportParamName);
        if (reportParam == null) {
            return;
        }
        CommandStack cmdStack = reportParam.getModuleHandle().getCommandStack();
        cmdStack.startTrans(null);
        ReportParamUpdater tmpUpdater = new ReportParamUpdater(this.paramDefn, this.newParam, reportParam, this.setHandle);
        tmpUpdater.process();
        cmdStack.commit();
    }

    private String getROMDataType(String dataSourceId, String dataSetId, OdaDataSetParameter param, Iterator setHandleParams) {
        String name = param.getNativeName();
        Integer position = param.getPosition();
        Integer nativeType = param.getNativeDataType();
        if (nativeType == null) {
            return param.getParameterDataType();
        }
        OdaDataSetParameterHandle tmpParam = this.findDataSetParameterByName(name, position, nativeType, setHandleParams);
        if (tmpParam == null) {
            return DataSetParameterUpdater.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeType);
        }
        Integer tmpPosition = tmpParam.getPosition();
        if (tmpPosition == null) {
            return DataSetParameterUpdater.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeType);
        }
        if (!tmpPosition.equals(param.getPosition())) {
            return DataSetParameterUpdater.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeType);
        }
        Integer tmpNativeCodeType = tmpParam.getNativeDataType();
        if (tmpNativeCodeType == null || tmpNativeCodeType.equals(nativeType)) {
            return tmpParam.getParameterDataType();
        }
        String oldDataType = tmpParam.getParameterDataType();
        return DataSetParameterUpdater.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeType, oldDataType);
    }

    private static String convertNativeTypeToROMDataType(String dataSourceId, String dataSetId, int nativeDataTypeCode) {
        return DataSetParameterUpdater.convertNativeTypeToROMDataType(dataSourceId, dataSetId, nativeDataTypeCode, null);
    }

    private static String convertNativeTypeToROMDataType(String dataSourceId, String dataSetId, int nativeDataTypeCode, String romDataType) {
        String romNewDataType = null;
        try {
            romNewDataType = NativeDataTypeUtil.getUpdatedDataType(dataSourceId, dataSetId, nativeDataTypeCode, romDataType, "paramType");
        }
        catch (BirtException birtException) {}
        return romNewDataType;
    }

    /*
     * Unable to fully structure code
     */
    private OdaDataSetParameterHandle findDataSetParameterByName(String dataSetParamName, Integer position, Integer nativeDataType, Iterator params) {
        if (position != null) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            param = (OdaDataSetParameterHandle)params.next();
            tmpNativeDataType = param.getNativeDataType();
            tmpNativeName = param.getNativeName();
            if (!StringUtil.isBlank((String)tmpNativeName) && tmpNativeName.equals(dataSetParamName)) {
                return param;
            }
            if (!StringUtil.isBlank((String)tmpNativeName) || !position.equals(param.getPosition()) || tmpNativeDataType != null && !tmpNativeDataType.equals(nativeDataType)) continue;
            return param;
lbl10:
            // 2 sources

            ** while (params.hasNext())
        }
lbl11:
        // 1 sources

        return null;
    }
}

