/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.AddImageResourceForNewTemplateWizard;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WizardReportSettingPage
extends WizardPage {
    private IPath containerFullPath;
    private static final String LABEL_DISPLAY_NAME = Messages.getString((String)"PublishTemplateAction.wizard.page.label.displayName");
    private static final String LABEL_DESCRIPTION = Messages.getString((String)"PublishTemplateAction.wizard.page.label.description");
    private static final String LABEL_IMAGE = Messages.getString((String)"PublishTemplateAction.wizard.page.label.image");
    private static final String BTN_CHOOSE = Messages.getString((String)"PublishTemplateAction.wizard.page.btn.browse");
    private static final String BROWSE_TITLE = Messages.getString((String)"PublishTemplateAction.wizard.page.browse.title");
    private static final String PLUGIN_ID = "org.eclipse.birt.report.designer.ui.actions.PublishTemplateWizard";
    private static final String STR_EMPTY = "";
    private String pageDesc = "";
    private ReportDesignHandle module;
    private Text previewImageText;
    private Text descText;
    private Text nameText;
    private Status nameStatus;
    private Status previewImageStatus;
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};
    private static final String[] IMAGE_FILEFILTERS = new String[]{"*.bmp;*.jpg;*.jpeg;*.jpe;*.jfif;*.gif;*.png;*.tif;*.tiff;*.ico;*.svg"};
    private String orientation = null;
    protected String displayName;
    protected String description;
    protected String previewImageFile;

    public void setContainerFullPath(IPath path) {
        this.containerFullPath = path;
    }

    public WizardReportSettingPage(ReportDesignHandle handle) {
        super(STR_EMPTY);
        this.module = handle;
        this.pageDesc = null;
    }

    public void setPageDesc(String pageDesc) {
        this.pageDesc = pageDesc;
        this.setMessage(pageDesc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        new Label(container, 0).setText(LABEL_DISPLAY_NAME);
        this.nameText = this.createText(container, 2, 1);
        if (this.module != null && this.module.getProperty("displayName") != null) {
            this.nameText.setText(this.module.getDisplayName());
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardReportSettingPage.this.checkStatus();
                WizardReportSettingPage.this.applyToStatusLine(WizardReportSettingPage.this.findMostSevere());
                WizardReportSettingPage.this.getWizard().getContainer().updateButtons();
                WizardReportSettingPage.this.displayName = WizardReportSettingPage.this.nameText.getText();
            }
        });
        new Label(container, 0).setText(LABEL_DESCRIPTION);
        this.descText = this.createText(container, 2, 5);
        if (this.module != null && this.module.getProperty("description") != null) {
            String descProp = (String)this.module.getProperty("description");
            this.descText.setText(descProp);
            this.description = descProp;
        }
        this.descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardReportSettingPage.this.checkStatus();
                WizardReportSettingPage.this.applyToStatusLine(WizardReportSettingPage.this.findMostSevere());
                WizardReportSettingPage.this.getWizard().getContainer().updateButtons();
                WizardReportSettingPage.this.description = WizardReportSettingPage.this.descText.getText();
            }
        });
        new Label(container, 0).setText(LABEL_IMAGE);
        this.previewImageText = this.createText(container, 1, 1, 2056);
        if (this.module != null && this.module.getIconFile() != null) {
            this.previewImageText.setText(this.module.getIconFile());
        }
        this.previewImageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardReportSettingPage.this.checkStatus();
                WizardReportSettingPage.this.applyToStatusLine(WizardReportSettingPage.this.findMostSevere());
                WizardReportSettingPage.this.getWizard().getContainer().updateButtons();
                WizardReportSettingPage.this.validate();
            }
        });
        Button chooseBtn = new Button(container, 0);
        chooseBtn.setText(BTN_CHOOSE);
        chooseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String fileName = null;
                AddImageResourceForNewTemplateWizard dlg = new AddImageResourceForNewTemplateWizard();
                dlg.setContainerFullPath(WizardReportSettingPage.this.containerFullPath);
                if (dlg.open() == 0) {
                    fileName = dlg.getPath();
                    WizardReportSettingPage.this.previewImageText.setText(fileName);
                    WizardReportSettingPage.this.previewImageFile = fileName;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nameText.forceFocus();
        this.setControl((Control)container);
        UIUtil.bindHelp(this.getControl(), "org.eclipse.birt.cshelp.PublishTemplateWizard_ID");
    }

    public String getDisplayName() {
        return this.displayName == null ? STR_EMPTY : this.displayName.trim();
    }

    public String getDescription() {
        return this.description == null ? STR_EMPTY : this.description.trim();
    }

    public String getPreviewImagePath() {
        return this.previewImageFile == null ? STR_EMPTY : this.previewImageFile.trim();
    }

    private Text createText(Composite container, int column, int row) {
        return this.createText(container, column, row, 2048);
    }

    private Text createText(Composite container, int column, int row, int style) {
        Text text;
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = column;
        if (row > 1) {
            text = new Text(container, style | 2 | 0x40);
            gridData.heightHint = row * 20;
        } else {
            text = new Text(container, style | 4);
        }
        text.setLayoutData((Object)gridData);
        return text;
    }

    private void validate() {
        if (this.previewImageStatus.getSeverity() != 0) {
            this.setErrorMessage(this.previewImageStatus.getMessage());
        }
        this.setPageComplete(this.previewImageStatus.getSeverity() != 4);
    }

    public void checkStatus() {
        Status status;
        String imageFileName = this.previewImageText.getText().trim();
        this.nameStatus = status = new Status(0, PLUGIN_ID, 0, this.pageDesc, null);
        this.previewImageStatus = status;
        if (WizardReportSettingPage.isTextEmpty(this.nameText)) {
            this.nameStatus = status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishTemplateAction.wizard.page.nameInfo"), null);
        } else if (!WizardReportSettingPage.isTextEmpty(this.previewImageText) && this.module != null && this.module.getIconFile() == null) {
            if (imageFileName.equals(Messages.getString((String)"ThumbnailBuilder.Image.DefaultName"))) {
                this.previewImageStatus = status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishTemplateAction.wizard.message.ThumbnailImageNotExist"), null);
            } else if (!(new File(imageFileName).exists() || new File(ReportPlugin.getDefault().getResourceFolder(), imageFileName).exists() || new File(UIUtil.getFragmentDirectory(), imageFileName).exists())) {
                this.previewImageStatus = status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishTemplateAction.wizard.message.PreviewImageNotExist"), null);
            } else if (!this.checkExtensions(imageFileName)) {
                this.previewImageStatus = status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishTemplateAction.wizard.message.PreviewImageNotValid"), null);
            }
        }
    }

    private static boolean isTextEmpty(Text text) {
        String s = text.getText();
        return s == null || s.trim().length() <= 0;
    }

    private IStatus findMostSevere() {
        if (this.nameStatus.getSeverity() == 4) {
            return this.nameStatus;
        }
        if (this.previewImageStatus.getSeverity() == 4) {
            return this.previewImageStatus;
        }
        if (this.nameStatus.getSeverity() == 2) {
            return this.nameStatus;
        }
        return this.previewImageStatus;
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = this.pageDesc;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 4: {
                this.setErrorMessage(message);
                this.setMessage(message, 3);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    public boolean canFinish() {
        this.checkStatus();
        return (this.nameStatus == null || this.nameStatus.getSeverity() != 4) && (this.previewImageStatus == null || this.previewImageStatus.getSeverity() != 4);
    }

    private boolean checkExtensions(String fileName) {
        int i = 0;
        while (i < IMAGE_TYPES.length) {
            if (fileName.toLowerCase().endsWith(IMAGE_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameText.forceFocus();
        }
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }
}

