/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.dialogs.IBindingDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AggregateOnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DataSetColumnBindingsFormDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AggregateOnBindingsFormDescriptor
extends DataSetColumnBindingsFormDescriptor {
    private AggregateOnBindingsFormHandleProvider provider;
    protected Button btnAddAggregateOn;
    protected Button btnAddMeasureOn;

    public AggregateOnBindingsFormDescriptor(boolean formStyle) {
        super(formStyle);
        super.setStyle(3);
        super.setButtonWithDialog(false);
    }

    @Override
    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof AggregateOnBindingsFormHandleProvider) {
            this.provider = (AggregateOnBindingsFormHandleProvider)provider;
        }
    }

    @Override
    public Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        this.btnAddAggregateOn = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton((Composite)control, "", 8) : new Button((Composite)control, 2048);
        if (this.bAddWithDialog) {
            this.btnAddAggregateOn.setText(Messages.getString((String)"FormPage.Button.AddWithDialog.AggregateOn"));
        } else {
            this.btnAddAggregateOn.setText(Messages.getString((String)"FormPage.Button.Add.AggregateOn"));
        }
        this.btnAddAggregateOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AggregateOnBindingsFormDescriptor.this.handleAddAggregateOnSelectEvent();
            }
        });
        this.btnAddMeasureOn = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton((Composite)control, "", 8) : new Button((Composite)control, 2048);
        if (this.bAddWithDialog) {
            this.btnAddMeasureOn.setText(Messages.getString((String)"FormPage.Button.AddWithDialog.MeasureOn"));
        } else {
            this.btnAddMeasureOn.setText(Messages.getString((String)"FormPage.Button.Add.MeasureOn"));
        }
        this.btnAddMeasureOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AggregateOnBindingsFormDescriptor.this.handleAddMeasureOnSelectEvent();
            }
        });
        this.fullLayout();
        return control;
    }

    protected void handleAddAggregateOnSelectEvent() {
        int pos = this.table.getSelectionIndex();
        try {
            this.provider.addAggregateOn(pos);
        }
        catch (Exception e) {
            WidgetUtil.processError((Shell)this.btnAddAggregateOn.getShell(), (Exception)e);
            return;
        }
        this.table.setSelection(this.table.getItemCount() - 1);
        this.updateArraw();
    }

    protected void handleAddMeasureOnSelectEvent() {
        int pos = this.table.getSelectionIndex();
        try {
            this.provider.addMeasureOn(pos);
        }
        catch (Exception e) {
            WidgetUtil.processError((Shell)this.btnAddMeasureOn.getShell(), (Exception)e);
            return;
        }
        this.table.setSelection(this.table.getItemCount() - 1);
        this.updateArraw();
    }

    @Override
    protected void fullLayout() {
        FormData data;
        super.fullLayout();
        Button button = this.btnAdd;
        if (this.btnAddAggregateOn != null) {
            IBindingDialogHelper helper;
            ReportElementHandle adaptableObject;
            button = this.btnAddAggregateOn;
            data = new FormData();
            data.top = new FormAttachment((Control)this.btnAdd, 0, 1024);
            data.left = new FormAttachment((Control)this.btnAdd, 0, 16384);
            data.width = Math.max(this.btnWidth, this.btnAddAggregateOn.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnAddAggregateOn.setLayoutData((Object)data);
            if (this.provider instanceof AggregateOnBindingsFormHandleProvider && (adaptableObject = this.provider.getBindingObject()) != null && adaptableObject instanceof ReportItemHandle && (helper = (IBindingDialogHelper)ElementAdapterManager.getAdapter((Object)adaptableObject, IBindingDialogHelper.class)) != null) {
                IBindingDialogHelper helperHelper = (IBindingDialogHelper)ElementAdapterManager.getAdapter((Object)helper, IBindingDialogHelper.class);
                if (helperHelper != null) {
                    helper = helperHelper;
                }
                helper.setBindingHolder((ReportItemHandle)adaptableObject);
                if (helper.canProcessMeasure()) {
                    button = this.btnAddMeasureOn;
                    data = new FormData();
                    data.top = new FormAttachment((Control)this.btnAddAggregateOn, 0, 1024);
                    data.left = new FormAttachment((Control)this.btnAddAggregateOn, 0, 16384);
                    data.width = Math.max(this.btnWidth, this.btnAddMeasureOn.computeSize((int)-1, (int)-1, (boolean)true).x);
                    this.btnAddMeasureOn.setLayoutData((Object)data);
                }
            }
            data = new FormData();
            data.top = new FormAttachment((Control)button, 0, 1024);
            data.left = new FormAttachment((Control)button, 0, 16384);
            data.width = Math.max(this.btnWidth, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnEdit.setLayoutData((Object)data);
        }
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnEdit, 0, 1024);
        data.left = new FormAttachment((Control)this.btnEdit, 0, 16384);
        data.width = Math.max(60, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
    }

    @Override
    public void setInput(Object object) {
        super.setInput(object);
        if (DEUtil.getInputSize((Object)object) > 0) {
            Object element = DEUtil.getInputFirstElement((Object)object);
            this.setBindingObject((ReportElementHandle)element);
        }
        if (this.provider.isEnable() && this.provider.isEditable()) {
            this.btnAddAggregateOn.setEnabled(true);
            this.btnAddMeasureOn.setEnabled(true);
        } else {
            this.btnAddAggregateOn.setEnabled(false);
            this.btnAddMeasureOn.setEnabled(false);
        }
        this.fullLayout();
    }

    private void setBindingObject(ReportElementHandle bindingObject) {
        this.provider.setBindingObject((DesignElementHandle)bindingObject);
    }

    @Override
    protected void handleRefreshSelectEvent() {
        this.provider.generateAllBindingColumns();
    }
}

