/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.script.model;

import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugElement;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugTarget;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugThread;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class ScriptStackFrame
extends ScriptDebugElement
implements IStackFrame {
    private int id;
    private ScriptDebugThread thread;
    private String name;
    private int lineNumber = 1;

    public ScriptStackFrame(ScriptDebugThread thread, String name, int id) {
        super((ScriptDebugTarget)thread.getDebugTarget());
        this.id = id;
        this.thread = thread;
        this.name = name;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        return this.lineNumber;
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    public String getName() throws DebugException {
        return String.valueOf(this.getId()) + "()" + "line: " + this.getLineNumber();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return ((ScriptDebugTarget)this.getDebugTarget()).getVariables(this);
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    protected int getIdentifier() {
        return this.id;
    }

    public String getId() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScriptStackFrame) {
            ScriptStackFrame sf = (ScriptStackFrame)((Object)obj);
            try {
                return sf.getName().equals(this.getName()) && sf.getLineNumber() == this.getLineNumber() && sf.id == this.id;
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    public String getFileName() {
        return ((ScriptDebugTarget)this.getDebugTarget()).getFileName();
    }

    @Override
    public String getDisplayName() {
        Object obj = ModuleUtil.getScriptObject((ModuleHandle)((ScriptDebugTarget)this.getDebugTarget()).getModuleHandle(), (String)this.getId());
        String name = "";
        if (obj instanceof PropertyHandle) {
            name = String.valueOf(DEUtil.getFlatHirarchyPathName((Object)((PropertyHandle)obj).getElementHandle())) + "." + ((PropertyHandle)obj).getDefn().getName();
            name = String.valueOf(name) + "()" + " line: " + this.lineNumber;
        } else {
            try {
                name = this.getName();
            }
            catch (DebugException debugException) {
                name = this.getId();
            }
        }
        return name;
    }
}

