/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectFileAccessor {
    private static final String[] EMPTY_ARRAY = new String[0];

    public static IPath getProjectFile(IContainer project) {
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource projItem = iResourceArray[n2];
                if (projItem.getName().equals("project.json") || projItem.getName().matches("^.*\\.csproj$")) {
                    return projItem.getFullPath();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            return null;
        }
        return null;
    }

    public static String[] getTargetFrameworks(IPath projectFile) {
        block20: {
            if (projectFile == null) {
                return EMPTY_ARRAY;
            }
            if (projectFile.getFileExtension().equals("json")) {
                try {
                    Throwable throwable = null;
                    Object var2_6 = null;
                    try (FileReader reader = new FileReader(projectFile.toFile());){
                        Gson gson = new Gson();
                        JsonObject object = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        ArrayList<String> frameworks = new ArrayList<String>();
                        for (Map.Entry framework : object.getAsJsonObject("frameworks").entrySet()) {
                            frameworks.add((String)framework.getKey());
                        }
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return EMPTY_ARRAY;
                }
            }
            if (projectFile.getFileExtension().equals("csproj")) {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(projectFile.toFile());
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName("PropertyGroup");
                    if (nList.getLength() > 0) {
                        String allFrameworks;
                        String tagName;
                        Node propertyGroup = nList.item(0);
                        NodeList frameworkNodeList = ((Element)propertyGroup).getElementsByTagName(tagName = "TargetFramework");
                        if (frameworkNodeList.getLength() > 0) {
                            String[] framework = new String[]{frameworkNodeList.item(0).getTextContent()};
                            return framework;
                        }
                        Node framework = ((Element)propertyGroup).getElementsByTagName(String.valueOf(tagName) + "s").item(0);
                        if (framework != null && !(allFrameworks = framework.getTextContent()).isEmpty()) {
                            return framework.getTextContent().split(";");
                        }
                    }
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    return EMPTY_ARRAY;
                }
            }
        }
        return EMPTY_ARRAY;
    }
}

