/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.viewport;

import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class ScrollBarHandlerTemplate
implements Listener {
    public static final int DEFAULT_OFFSET = 1;
    protected final ViewportLayer viewportLayer;
    protected final IUniqueIndexLayer scrollableLayer;
    protected final ScrollBar scrollBar;

    public ScrollBarHandlerTemplate(ViewportLayer viewportLayer, ScrollBar scrollBar) {
        this.viewportLayer = viewportLayer;
        this.scrollableLayer = viewportLayer.getScrollableLayer();
        this.scrollBar = scrollBar;
        this.scrollBar.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        ScrollBar scrollBar = (ScrollBar)event.widget;
        int position = this.getPositionByPixel(scrollBar.getSelection());
        this.setViewportOrigin(position);
    }

    void adjustScrollBar() {
        if (this.scrollBar.isDisposed()) {
            return;
        }
        int scrollablePosition = this.getScrollablePosition();
        int startPixel = this.getStartPixelOfPosition(scrollablePosition);
        this.scrollBar.setSelection(startPixel);
    }

    void recalculateScrollBarSize() {
        int thumbSize;
        if (this.scrollBar.isDisposed()) {
            return;
        }
        int scrollableLayerSpan = this.getScrollableLayerSpan();
        int viewportWindowSpan = this.getViewportWindowSpan();
        int max = scrollableLayerSpan + this.getScrollBarOverhang();
        if (!this.scrollBar.isDisposed()) {
            this.scrollBar.setMaximum(max);
        }
        this.scrollBar.setPageIncrement(viewportWindowSpan);
        if (viewportWindowSpan < max) {
            thumbSize = viewportWindowSpan;
            this.scrollBar.setEnabled(true);
            this.scrollBar.setVisible(true);
        } else {
            thumbSize = max;
            this.scrollBar.setEnabled(false);
            this.scrollBar.setVisible(false);
        }
        this.scrollBar.setThumb(thumbSize);
    }

    protected int getScrollBarOverhang() {
        int viewportWindowSpan = this.getViewportWindowSpan();
        if (viewportWindowSpan <= 0 || viewportWindowSpan >= this.getScrollableLayerSpan()) {
            return 0;
        }
        int edgePixel = this.getScrollableLayerSpan() - viewportWindowSpan;
        int positionAtEdge = this.getPositionByPixel(edgePixel);
        int startPixelOfPositionAtEdge = this.getStartPixelOfPosition(positionAtEdge);
        int overhang = 0;
        if (edgePixel != startPixelOfPositionAtEdge) {
            overhang = this.getSpanByPosition(positionAtEdge) - (edgePixel - startPixelOfPositionAtEdge);
        }
        return overhang;
    }

    abstract int getViewportWindowSpan();

    abstract int getScrollableLayerSpan();

    abstract boolean keepScrolling();

    abstract int pageScrollDistance();

    abstract int getSpanByPosition(int var1);

    abstract int getScrollablePosition();

    abstract int getStartPixelOfPosition(int var1);

    abstract int getPositionByPixel(int var1);

    abstract void setViewportOrigin(int var1);

    abstract SelectionLayer.MoveDirectionEnum scrollDirectionForEventDetail(int var1);
}

