/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.sort.command;

import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.sort.ISortModel;
import net.sourceforge.nattable.sort.SortDirectionEnum;
import net.sourceforge.nattable.sort.SortHeaderLayer;
import net.sourceforge.nattable.sort.command.SortColumnCommand;
import net.sourceforge.nattable.sort.event.SortColumnEvent;
import org.eclipse.swt.custom.BusyIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortCommandHandler<T>
extends AbstractLayerCommandHandler<SortColumnCommand> {
    private final ISortModel sortModel;
    private final SortHeaderLayer<T> sortHeaderLayer;

    public SortCommandHandler(ISortModel sortModel, SortHeaderLayer<T> sortHeaderLayer) {
        this.sortModel = sortModel;
        this.sortHeaderLayer = sortHeaderLayer;
    }

    @Override
    public boolean doCommand(final SortColumnCommand command) {
        final int columnIndex = command.getLayer().getColumnIndexByPosition(command.getColumnPosition());
        final SortDirectionEnum newSortDirection = this.sortModel.getSortDirection(columnIndex).getNextSortDirection();
        Runnable sortRunner = new Runnable(){

            public void run() {
                SortCommandHandler.this.sortModel.sort(columnIndex, newSortDirection, command.isAccumulate());
            }
        };
        BusyIndicator.showWhile(null, (Runnable)sortRunner);
        SortColumnEvent sortEvent = new SortColumnEvent(this.sortHeaderLayer, command.getColumnPosition());
        this.sortHeaderLayer.fireLayerEvent(sortEvent);
        return true;
    }

    @Override
    public Class<SortColumnCommand> getCommandClass() {
        return SortColumnCommand.class;
    }
}

