/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.search.command;

import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.search.command.SearchCommand;
import net.sourceforge.nattable.search.event.SearchEvent;
import net.sourceforge.nattable.search.strategy.AbstractSearchStrategy;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.command.SelectCellCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchGridCellsCommandHandler
implements ILayerCommandHandler<SearchCommand> {
    private final SelectionLayer selectionLayer;
    private PositionCoordinate searchResultCellCoordinate;

    public SearchGridCellsCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<SearchCommand> getCommandClass() {
        return SearchCommand.class;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SearchCommand searchCommand) {
        searchCommand.convertToTargetLayer(targetLayer);
        AbstractSearchStrategy searchStrategy = (AbstractSearchStrategy)searchCommand.getSearchStrategy();
        if (searchCommand.getSearchEventListener() != null) {
            this.selectionLayer.addLayerListener(searchCommand.getSearchEventListener());
        }
        PositionCoordinate anchor = this.selectionLayer.getSelectionAnchor();
        if (anchor.columnPosition < 0 || anchor.rowPosition < 0) {
            anchor = new PositionCoordinate(this.selectionLayer, 0, 0);
        }
        searchStrategy.setContextLayer(targetLayer);
        Object dataValueToFind = null;
        dataValueToFind = searchCommand.getSearchText();
        if (dataValueToFind == null) {
            dataValueToFind = this.selectionLayer.getDataValueByPosition(anchor.columnPosition, anchor.rowPosition);
        }
        searchStrategy.setCaseSensitive(searchCommand.isCaseSensitive());
        searchStrategy.setWrapSearch(searchCommand.isWrapSearch());
        searchStrategy.setSearchDirection(searchCommand.getSearchDirection());
        searchStrategy.setComparator(searchCommand.getComparator());
        this.searchResultCellCoordinate = searchStrategy.executeSearch(dataValueToFind);
        this.selectionLayer.fireLayerEvent(new SearchEvent(this.searchResultCellCoordinate));
        if (this.searchResultCellCoordinate != null) {
            SelectCellCommand command = new SelectCellCommand(this.selectionLayer, this.searchResultCellCoordinate.columnPosition, this.searchResultCellCoordinate.rowPosition, false, false);
            command.setForcingEntireCellIntoViewport(true);
            this.selectionLayer.doCommand(command);
        }
        return true;
    }

    public PositionCoordinate getSearchResultCellCoordinate() {
        return this.searchResultCellCoordinate;
    }
}

