/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.painter.cell;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.BackgroundPainter;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.CellStyleUtil;
import net.sourceforge.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ImagePainter
extends BackgroundPainter {
    private final Image image;
    private final boolean paintBg;

    public ImagePainter() {
        this((Image)null);
    }

    public ImagePainter(Image image) {
        this(image, true);
    }

    public ImagePainter(Image image, boolean paintBg) {
        this.image = image;
        this.paintBg = paintBg;
    }

    public int getPreferredWidth(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().width;
        }
        return 0;
    }

    public int getPreferredHeight(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().height;
        }
        return 0;
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Image image;
        if (this.paintBg) {
            super.paintCell(cell, gc, bounds, configRegistry);
        }
        if ((image = this.getImage(cell, configRegistry)) != null) {
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
            gc.drawImage(image, bounds.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, bounds, imageBounds.width), bounds.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, bounds, imageBounds.height));
        }
    }

    protected Image getImage(LayerCell cell, IConfigRegistry configRegistry) {
        if (this.image != null) {
            return this.image;
        }
        return CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.IMAGE);
    }
}

