/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.grid.command;

import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.grid.layer.GridLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.print.command.TurnViewportOffCommand;
import net.sourceforge.nattable.print.command.TurnViewportOnCommand;
import net.sourceforge.nattable.resize.MaxCellBoundsHelper;
import net.sourceforge.nattable.resize.command.AutoResizeRowsCommand;
import net.sourceforge.nattable.resize.command.MultiRowResizeCommand;
import net.sourceforge.nattable.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoResizeRowCommandHandler
implements ILayerCommandHandler<AutoResizeRowsCommand> {
    private final GridLayer gridLayer;

    public AutoResizeRowCommandHandler(GridLayer gridLayer) {
        this.gridLayer = gridLayer;
    }

    @Override
    public Class<AutoResizeRowsCommand> getCommandClass() {
        return AutoResizeRowsCommand.class;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, AutoResizeRowsCommand command) {
        targetLayer.doCommand(new TurnViewportOffCommand());
        int[] rowPositions = ObjectUtils.asIntArray(command.getRowPositions());
        int[] gridRowPositions = this.convertFromSelectionToGrid(rowPositions);
        int[] gridRowHeights = MaxCellBoundsHelper.getPreferedRowHeights(command.getConfigRegistry(), command.getGC(), this.gridLayer, gridRowPositions);
        this.gridLayer.doCommand(new MultiRowResizeCommand((ILayer)this.gridLayer, gridRowPositions, gridRowHeights));
        targetLayer.doCommand(new TurnViewportOnCommand());
        return true;
    }

    private int[] convertFromSelectionToGrid(int[] rowPositions) {
        int[] gridRowPositions = new int[rowPositions.length];
        int i = 0;
        while (i < rowPositions.length) {
            gridRowPositions[i] = this.gridLayer.underlyingToLocalRowPosition(this.gridLayer.getBodyLayer(), rowPositions[i]);
            ++i;
        }
        return gridRowPositions;
    }
}

