/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit.command;

import java.util.List;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.config.IEditableRule;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.edit.EditConfigAttributes;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.selection.SelectionLayer;

public class EditUtils {
    public static LayerCell getLastSelectedCell(SelectionLayer selectionLayer) {
        PositionCoordinate selectionAnchor = selectionLayer.getSelectionAnchor();
        return selectionLayer.getCellByPosition(selectionAnchor.columnPosition, selectionAnchor.rowPosition);
    }

    public static ICellEditor lastSelectedCellEditor(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        List<String> lastSelectedCellLabelsArray = EditUtils.getLastSelectedCell(selectionLayer).getConfigLabels().getLabels();
        return configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", lastSelectedCellLabelsArray);
    }

    public static boolean allCellsEditable(SelectionLayer selectionLayer, IConfigRegistry configRegistry) {
        PositionCoordinate[] selectedCells;
        PositionCoordinate[] positionCoordinateArray = selectedCells = selectionLayer.getSelectedCells();
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex;
            int columnIndex;
            PositionCoordinate cell = positionCoordinateArray[n2];
            LabelStack labelStack = selectionLayer.getConfigLabelsByPosition(cell.columnPosition, cell.rowPosition);
            IEditableRule editableRule = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", labelStack.getLabels());
            if (!editableRule.isEditable(columnIndex = selectionLayer.getColumnIndexByPosition(cell.columnPosition), rowIndex = selectionLayer.getRowIndexByPosition(cell.rowPosition))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isEditorSame(SelectionLayer selectionLayer, IConfigRegistry configRegistry, ICellEditor lastSelectedCellEditor) {
        PositionCoordinate[] selectedCells = selectionLayer.getSelectedCells();
        boolean isAllSelectedCellsHaveSameEditor = true;
        PositionCoordinate[] positionCoordinateArray = selectedCells;
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate selectedCell = positionCoordinateArray[n2];
            LabelStack labelStack = selectionLayer.getConfigLabelsByPosition(selectedCell.columnPosition, selectedCell.rowPosition);
            ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", labelStack.getLabels());
            if (cellEditor != lastSelectedCellEditor) {
                isAllSelectedCellsHaveSameEditor = false;
            }
            ++n2;
        }
        return isAllSelectedCellsHaveSameEditor;
    }
}

