/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.FieldReferenceConverter;
import com.google.gwt.uibinder.rebind.MortalLogger;

class StrictAttributeParser
implements AttributeParser {
    private final FieldReferenceConverter converter;
    protected final MortalLogger logger;
    private final JType type;

    StrictAttributeParser(FieldReferenceConverter converter, JType type, MortalLogger logger) {
        this.converter = converter;
        this.type = type;
        this.logger = logger;
    }

    public String parse(String value) throws UnableToCompleteException {
        if ("".equals(value.trim())) {
            this.logger.die("Cannot use empty value as type %s", new Object[]{this.type.getSimpleSourceName()});
        }
        try {
            return this.converter.convert(value, new FieldReferenceDelegate(this.type));
        }
        catch (FieldReferenceConverter.IllegalFieldReferenceException e) {
            this.logger.die("Cannot parse value: \"%s\" as type %s", new Object[]{value, this.type.getSimpleSourceName()});
            return null;
        }
    }

    static class FieldReferenceDelegate
    implements FieldReferenceConverter.Delegate {
        private boolean sawReference = false;
        private final JType type;

        FieldReferenceDelegate(JType type) {
            this.type = type;
        }

        public JType getType() {
            return this.type;
        }

        public String handleFragment(String fragment) throws FieldReferenceConverter.IllegalFieldReferenceException {
            if (fragment.length() > 0) {
                throw new FieldReferenceConverter.IllegalFieldReferenceException();
            }
            return fragment;
        }

        public String handleReference(String reference) throws FieldReferenceConverter.IllegalFieldReferenceException {
            this.assertOnly();
            this.sawReference = true;
            return reference;
        }

        private void assertOnly() {
            if (this.sawReference) {
                throw new FieldReferenceConverter.IllegalFieldReferenceException();
            }
        }
    }
}

