/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;

public class IOUtil {
    public static String readString(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String string = IOUtil.readString(in);
            return string;
        }
    }

    public static String readString(URL url) throws IOException {
        try (Reader reader = IOUtil.urlToReader(url);){
            String string = IOUtil.readString(reader);
            return string;
        }
    }

    public static String readString(InputStream in) throws IOException {
        return IOUtil.readString(new InputStreamReader(in));
    }

    public static String readString(Reader r) throws IOException {
        return IOUtil.readFully(r).toString();
    }

    public static String readString(Reader r, int maxChars) throws IOException {
        char[] charBuf = new char[maxChars];
        int charsRead = IOUtil.readChars(r, charBuf);
        return new String(charBuf, 0, charsRead);
    }

    public static char[] readChars(URL url) throws IOException {
        try (Reader reader = IOUtil.urlToReader(url);){
            char[] cArray = IOUtil.readChars(reader);
            return cArray;
        }
    }

    public static char[] readChars(Reader r) throws IOException {
        return IOUtil.readFully(r).toCharArray();
    }

    public static int readChars(Reader r, char[] charArray) throws IOException {
        int totalCharsRead = 0;
        int charsRead = r.read(charArray);
        while (charsRead >= 0 && (totalCharsRead += charsRead) != charArray.length) {
            charsRead = r.read(charArray, totalCharsRead, charArray.length - totalCharsRead);
        }
        return totalCharsRead;
    }

    public static byte[] readBytes(File file) throws IOException {
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File size exceeds maximum array length (" + fileSize + " > 2147483647)");
        }
        try (FileInputStream in = new FileInputStream(file);){
            byte[] byArray = IOUtil.readBytes((InputStream)in, (int)fileSize);
            return byArray;
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IOUtil.transfer(in, out);
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, int maxBytes) throws IOException {
        byte[] result = new byte[maxBytes];
        int bytesRead = IOUtil.readBytes(in, result);
        if (bytesRead < maxBytes) {
            byte[] tmp = new byte[bytesRead];
            System.arraycopy(result, 0, tmp, 0, bytesRead);
            result = tmp;
        }
        return result;
    }

    public static int readBytes(InputStream in, byte[] byteArray) throws IOException {
        int totalBytesRead = 0;
        int bytesRead = in.read(byteArray);
        while (bytesRead >= 0 && (totalBytesRead += bytesRead) != byteArray.length) {
            bytesRead = in.read(byteArray, totalBytesRead, byteArray.length - totalBytesRead);
        }
        return totalBytesRead;
    }

    public static Properties readProperties(File propsFile) throws IOException {
        return IOUtil.readProperties(propsFile, null);
    }

    public static Properties readProperties(File propsFile, Properties defaults) throws IOException {
        return IOUtil.readProperties(new FileInputStream(propsFile), defaults);
    }

    public static Properties readProperties(InputStream in) throws IOException {
        return IOUtil.readProperties(in, null);
    }

    public static Properties readProperties(InputStream in, Properties defaults) throws IOException {
        Properties result = new Properties(defaults);
        try (InputStream inputStream = in;){
            result.load(in);
        }
        return result;
    }

    public static void writeProperties(Properties props, File file, boolean includeDefaults) throws IOException {
        IOUtil.writeProperties(props, new FileOutputStream(file), includeDefaults);
    }

    public static void writeProperties(Properties props, OutputStream out, boolean includeDefaults) throws IOException {
        if (includeDefaults) {
            Properties all = new Properties();
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = props.getProperty(propName);
                all.put(propName, propValue);
            }
            props = all;
        }
        try (OutputStream outputStream = out;){
            props.store(out, null);
        }
    }

    public static void writeStream(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            IOUtil.transfer(in, out);
        }
    }

    public static void writeString(String contents, File file) throws IOException {
        try (FileWriter out = new FileWriter(file);){
            out.write(contents);
        }
    }

    public static void writeBytes(byte[] data, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            IOUtil.writeBytes(data, out);
        }
    }

    public static void writeBytes(byte[] data, OutputStream out) throws IOException {
        IOUtil.transfer((InputStream)new ByteArrayInputStream(data), out);
    }

    public static Reader urlToReader(URL url) throws IOException {
        URLConnection con = url.openConnection();
        return new InputStreamReader(con.getInputStream());
    }

    private static CharArrayWriter readFully(Reader r) throws IOException {
        int charsRead;
        CharArrayWriter result = new CharArrayWriter();
        char[] buf = new char[4096];
        while ((charsRead = r.read(buf)) != -1) {
            result.write(buf, 0, charsRead);
        }
        return result;
    }

    public static final long transfer(InputStream in, OutputStream out) throws IOException {
        int bytesInBuf;
        long totalBytes = 0L;
        byte[] buf = new byte[4096];
        while ((bytesInBuf = in.read(buf)) != -1) {
            out.write(buf, 0, bytesInBuf);
            totalBytes += (long)bytesInBuf;
        }
        return totalBytes;
    }

    public static final long transfer(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            long l = IOUtil.transfer(in, out);
            return l;
        }
    }

    public static final long transfer(Reader in, Writer out) throws IOException {
        int charsInBuf;
        long totalChars = 0L;
        char[] buf = new char[4096];
        while ((charsInBuf = in.read(buf)) != -1) {
            out.write(buf, 0, charsInBuf);
            totalChars += (long)charsInBuf;
        }
        return totalChars;
    }

    public static final long transfer(Reader reader, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            long l = IOUtil.transfer(reader, writer);
            return l;
        }
    }

    public static void writeVarInt(OutputStream out, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException("Unable to write negative variable length integer");
        }
        while (value > 127) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write(value);
    }

    public static void main(String[] args) throws IOException {
        byte[] bytes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.writeVarInt(baos, 100000);
        for (byte b : bytes = baos.toByteArray()) {
            System.out.print(" ");
            System.out.print(Integer.toBinaryString(0xFF & b));
        }
        System.out.println();
        ByteArrayInputStream bis = new ByteArrayInputStream(new byte[]{-96, -115, 6});
        System.out.println("read: " + IOUtil.readVarInt(bis));
    }

    public static int readVarInt(InputStream in) throws IOException {
        byte b = IOUtil.readByte(in);
        int v = b & 0x7F;
        int i = 7;
        while ((b & 0x80) != 0) {
            b = IOUtil.readByte(in);
            v |= (b & 0x7F) << i;
            i += 7;
        }
        return v;
    }

    private static byte readByte(InputStream in) throws IOException {
        int read = in.read();
        if (read == -1) {
            throw new EOFException();
        }
        return (byte)read;
    }
}

