/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclShapeParsingException;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclProperties {
    private static final Logger logger = LoggerFactory.getLogger(ShaclProperties.class);
    private Resource id;
    private IRI type;
    private final List<IRI> clazz = new ArrayList<IRI>();
    private final List<Resource> or = new ArrayList<Resource>();
    private final List<Resource> xone = new ArrayList<Resource>();
    private final List<Resource> and = new ArrayList<Resource>();
    private final List<Resource> not = new ArrayList<Resource>();
    private final List<Resource> node = new ArrayList<Resource>();
    private final List<Resource> property = new ArrayList<Resource>();
    private final List<IRI> equals = new ArrayList<IRI>();
    private final List<IRI> disjoint = new ArrayList<IRI>();
    private final List<IRI> lessThan = new ArrayList<IRI>();
    private final List<IRI> lessThanOrEquals = new ArrayList<IRI>();
    private Long minCount;
    private Long maxCount;
    private IRI datatype;
    private Resource in;
    private final List<Value> hasValue = new ArrayList<Value>();
    private final List<Resource> hasValueIn = new ArrayList<Resource>();
    private Long minLength;
    private Long maxLength;
    private Resource languageIn;
    private Resource nodeKind;
    private Resource path;
    private Literal minExclusive;
    private Literal maxExclusive;
    private Literal minInclusive;
    private Literal maxInclusive;
    private String pattern;
    private String flags;
    private final Set<Resource> targetClass = new HashSet<Resource>();
    private final TreeSet<Value> targetNode = new TreeSet<Value>(new ValueComparator());
    private final Set<IRI> targetSubjectsOf = new HashSet<IRI>();
    private final Set<IRI> targetObjectsOf = new HashSet<IRI>();
    private final List<Resource> targetShape = new ArrayList<Resource>();
    private Resource qualifiedValueShape;
    private Long qualifiedMinCount;
    private Long qualifiedMaxCount;
    private Boolean qualifiedValueShapesDisjoint;
    private final List<Resource> target = new ArrayList<Resource>();
    private Boolean deactivated = null;
    private Boolean uniqueLang = null;
    private Boolean closed = null;
    private Resource ignoredProperties;
    private final List<Literal> message = new ArrayList<Literal>();
    private IRI severity;
    private final List<Literal> name = new ArrayList<Literal>();
    private final List<Literal> description = new ArrayList<Literal>();
    private Value defaultValue;
    private Value order;
    private Value group;
    private final List<Resource> sparql = new ArrayList<Resource>();

    public ShaclProperties(Resource id, ShapeSource connection) {
        this.id = id;
        try (Stream<Statement> stream = connection.getAllStatements(id);){
            stream.forEach(statement -> {
                String predicate = statement.getPredicate().toString();
                Value object = statement.getObject();
                switch (predicate) {
                    case "http://www.w3.org/1999/02/22-rdf-syntax-ns#type": {
                        if (object.equals(SHACL.NODE_SHAPE)) {
                            if (this.type != null && !this.type.equals(SHACL.NODE_SHAPE)) {
                                throw new ShaclShapeParsingException("Shape with multiple types: <" + String.valueOf(this.type) + ">, <" + String.valueOf(SHACL.NODE_SHAPE) + ">", id);
                            }
                            this.type = SHACL.NODE_SHAPE;
                            break;
                        }
                        if (!object.equals(SHACL.PROPERTY_SHAPE)) break;
                        if (this.type != null && !this.type.equals(SHACL.PROPERTY_SHAPE)) {
                            throw new ShaclShapeParsingException("Shape with multiple types: <" + String.valueOf(this.type) + ">, <" + String.valueOf(SHACL.PROPERTY_SHAPE) + ">", id);
                        }
                        this.type = SHACL.PROPERTY_SHAPE;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#or": {
                        try {
                            this.or.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#xone": {
                        try {
                            this.xone.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#and": {
                        try {
                            this.and.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#not": {
                        try {
                            this.not.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#property": {
                        try {
                            this.property.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#node": {
                        try {
                            this.node.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#message": {
                        try {
                            this.message.add((Literal)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#name": {
                        try {
                            this.name.add((Literal)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#description": {
                        try {
                            this.description.add((Literal)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#severity": {
                        if (this.severity != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.severity, object);
                        }
                        try {
                            this.severity = (IRI)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, IRI.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#defaultValue": {
                        if (this.defaultValue != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.defaultValue, object);
                        }
                        this.defaultValue = object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#group": {
                        if (this.group != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.group, object);
                        }
                        this.group = object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#order": {
                        if (this.order != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.order, object);
                        }
                        this.order = object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#languageIn": {
                        if (this.languageIn != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.languageIn, object);
                        }
                        try {
                            this.languageIn = (Resource)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#nodeKind": {
                        if (this.nodeKind != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.nodeKind, object);
                        }
                        try {
                            this.nodeKind = (Resource)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#datatype": {
                        if (this.datatype != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.datatype, object);
                        }
                        try {
                            this.datatype = (IRI)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, IRI.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#minCount": {
                        if (this.minCount != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.minCount, object);
                        }
                        try {
                            this.minCount = ((Literal)object).longValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (NumberFormatException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Long.class);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#maxCount": {
                        if (this.maxCount != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.maxCount, object);
                        }
                        try {
                            this.maxCount = ((Literal)object).longValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (NumberFormatException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Long.class);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#minLength": {
                        if (this.minLength != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.minLength, object);
                        }
                        try {
                            this.minLength = ((Literal)object).longValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (NumberFormatException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Long.class);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#maxLength": {
                        if (this.maxLength != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.maxLength, object);
                        }
                        try {
                            this.maxLength = ((Literal)object).longValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (NumberFormatException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Long.class);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#minExclusive": {
                        if (this.minExclusive != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.minExclusive, object);
                        }
                        try {
                            this.minExclusive = (Literal)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#maxExclusive": {
                        if (this.maxExclusive != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.maxExclusive, object);
                        }
                        try {
                            this.maxExclusive = (Literal)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#minInclusive": {
                        if (this.minInclusive != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.minInclusive, object);
                        }
                        try {
                            this.minInclusive = (Literal)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#maxInclusive": {
                        if (this.maxInclusive != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.maxInclusive, object);
                        }
                        try {
                            this.maxInclusive = (Literal)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#pattern": {
                        if (this.pattern != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.pattern, object);
                        }
                        try {
                            this.pattern = ((Literal)object).getLabel();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#class": {
                        try {
                            this.clazz.add((IRI)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, IRI.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#targetNode": {
                        if (!object.isLiteral() && !object.isIRI()) {
                            throw new ShaclShapeParsingException("Expected predicate <" + predicate + "> to have a Literal or an IRI as object, but found " + ShaclProperties.getClassName(object) + " for " + String.valueOf(object), id);
                        }
                        this.targetNode.add(object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetClass": {
                        try {
                            this.targetClass.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#targetSubjectsOf": {
                        try {
                            this.targetSubjectsOf.add((IRI)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, IRI.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#targetObjectsOf": {
                        try {
                            this.targetObjectsOf.add((IRI)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, IRI.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#deactivated": {
                        if (this.deactivated != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.deactivated, object);
                        }
                        try {
                            this.deactivated = ((Literal)object).booleanValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (IllegalArgumentException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Boolean.class);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#uniqueLang": {
                        if (this.uniqueLang != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.uniqueLang, object);
                        }
                        try {
                            this.uniqueLang = ((Literal)object).booleanValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (IllegalArgumentException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Boolean.class);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#closed": {
                        if (this.closed != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.closed, object);
                        }
                        try {
                            this.closed = ((Literal)object).booleanValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (IllegalArgumentException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Boolean.class);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#ignoredProperties": {
                        if (this.ignoredProperties != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.ignoredProperties, object);
                        }
                        try {
                            this.ignoredProperties = (Resource)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#flags": {
                        if (this.flags != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.flags, object);
                        }
                        try {
                            this.flags = ((Literal)object).getLabel();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#path": {
                        if (this.path != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.path, object);
                        }
                        if (this.type == null) {
                            this.type = SHACL.PROPERTY_SHAPE;
                        } else if (!this.type.equals(SHACL.PROPERTY_SHAPE)) {
                            throw new IllegalStateException("Shape " + String.valueOf(id) + " has sh:path and must be of type sh:PropertyShape but is type " + String.valueOf(this.type));
                        }
                        try {
                            this.path = (Resource)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#in": {
                        if (this.in != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.in, object);
                        }
                        try {
                            this.in = (Resource)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#equals": {
                        try {
                            this.equals.add((IRI)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, IRI.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#disjoint": {
                        try {
                            this.disjoint.add((IRI)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, IRI.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#lessThan": {
                        try {
                            this.lessThan.add((IRI)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, IRI.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#lessThanOrEquals": {
                        try {
                            this.lessThanOrEquals.add((IRI)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, IRI.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#target": {
                        try {
                            this.target.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#hasValue": {
                        this.hasValue.add(object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#qualifiedValueShape": {
                        if (this.qualifiedValueShape != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.qualifiedValueShape, object);
                        }
                        try {
                            this.qualifiedValueShape = (Resource)object;
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#qualifiedValueShapesDisjoint": {
                        if (this.qualifiedValueShapesDisjoint != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.qualifiedValueShapesDisjoint, object);
                        }
                        try {
                            this.qualifiedValueShapesDisjoint = ((Literal)object).booleanValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (IllegalArgumentException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Boolean.class);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#qualifiedMinCount": {
                        if (this.qualifiedMinCount != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.qualifiedMinCount, object);
                        }
                        try {
                            this.qualifiedMinCount = ((Literal)object).longValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (NumberFormatException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Long.class);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#qualifiedMaxCount": {
                        if (this.qualifiedMaxCount != null) {
                            throw ShaclProperties.getExceptionForAlreadyPopulated(id, predicate, this.qualifiedMaxCount, object);
                        }
                        try {
                            this.qualifiedMaxCount = ((Literal)object).longValue();
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Literal.class, object);
                        }
                        catch (NumberFormatException e) {
                            throw ShaclProperties.getExceptionForLiteralFormatIssue(id, predicate, object, Long.class);
                        }
                    }
                    case "http://datashapes.org/dash#hasValueIn": {
                        try {
                            this.hasValueIn.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://rdf4j.org/shacl-extensions#targetShape": {
                        try {
                            this.targetShape.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    case "http://www.w3.org/ns/shacl#sparql": {
                        try {
                            this.sparql.add((Resource)object);
                            break;
                        }
                        catch (ClassCastException e) {
                            throw ShaclProperties.getExceptionForCastIssue(id, predicate, Resource.class, object);
                        }
                    }
                    default: {
                        if (!predicate.startsWith("http://www.w3.org/ns/shacl#")) break;
                        logger.warn("Unsupported SHACL feature detected {} in statement {}", (Object)predicate.replace("http://www.w3.org/ns/shacl#", "sh:"), statement);
                    }
                }
            });
        }
        if (this.type == null) {
            this.type = this.path == null ? SHACL.NODE_SHAPE : SHACL.PROPERTY_SHAPE;
        }
    }

    private static ShaclShapeParsingException getExceptionForLiteralFormatIssue(Resource id, String predicate, Value object, Class<?> clazz) {
        return new ShaclShapeParsingException("Expected predicate <" + predicate + "> to have a " + clazz.getSimpleName() + " as object but found " + String.valueOf(object), id);
    }

    private static ShaclShapeParsingException getExceptionForAlreadyPopulated(Resource id, String predicate, Object existingObject, Value secondValue) {
        Value existingValue;
        if (existingObject instanceof Value) {
            existingValue = (Value)existingObject;
        } else if (existingObject instanceof String) {
            existingValue = Values.literal(existingObject);
        } else if (existingObject instanceof Boolean) {
            existingValue = Values.literal(existingObject);
        } else {
            return new ShaclShapeParsingException("Expected predicate <" + predicate + "> to have no more than 1 object, found " + String.valueOf(existingObject) + " and " + String.valueOf(secondValue), id);
        }
        return new ShaclShapeParsingException("Expected predicate <" + predicate + "> to have no more than 1 object, found " + String.valueOf(existingValue) + " and " + String.valueOf(secondValue), id);
    }

    private static ShaclShapeParsingException getExceptionForCastIssue(Resource id, String predicate, Class<?> expectedClass, Value object) {
        Object expectedClassString = expectedClass == IRI.class ? "an IRI" : "a " + expectedClass.getSimpleName();
        return new ShaclShapeParsingException("Expected predicate <" + predicate + "> to have " + (String)expectedClassString + " as object, but found " + ShaclProperties.getClassName(object) + " for " + String.valueOf(object), id);
    }

    private static String getClassName(Value object) {
        String actualClassName;
        if (object == null) {
            return "null";
        }
        if (object.isIRI()) {
            actualClassName = "IRI";
        } else if (object.isLiteral()) {
            actualClassName = "Literal";
        } else if (object.isBNode()) {
            actualClassName = "BNode";
        } else if (object.isTriple()) {
            actualClassName = "Triple";
        } else {
            assert (false);
            actualClassName = object.getClass().getSimpleName();
        }
        return actualClassName;
    }

    public List<IRI> getClazz() {
        return this.clazz;
    }

    public List<Resource> getOr() {
        return this.or;
    }

    public List<Resource> getAnd() {
        return this.and;
    }

    public List<Resource> getNot() {
        return this.not;
    }

    public Long getMinCount() {
        return this.minCount;
    }

    public Long getMaxCount() {
        return this.maxCount;
    }

    public IRI getDatatype() {
        return this.datatype;
    }

    public Resource getIn() {
        return this.in;
    }

    public Long getMinLength() {
        return this.minLength;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Resource getLanguageIn() {
        return this.languageIn;
    }

    public Resource getNodeKind() {
        return this.nodeKind;
    }

    public Resource getPath() {
        return this.path;
    }

    public Literal getMinExclusive() {
        return this.minExclusive;
    }

    public Literal getMaxExclusive() {
        return this.maxExclusive;
    }

    public Literal getMinInclusive() {
        return this.minInclusive;
    }

    public Literal getMaxInclusive() {
        return this.maxInclusive;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFlags() {
        return this.flags;
    }

    public Set<Resource> getTargetClass() {
        return this.targetClass;
    }

    public TreeSet<Value> getTargetNode() {
        return this.targetNode;
    }

    public Set<IRI> getTargetSubjectsOf() {
        return this.targetSubjectsOf;
    }

    public Set<IRI> getTargetObjectsOf() {
        return this.targetObjectsOf;
    }

    public boolean isDeactivated() {
        return this.deactivated != null && this.deactivated != false;
    }

    public boolean isUniqueLang() {
        return this.uniqueLang != null && this.uniqueLang != false;
    }

    public Resource getId() {
        return this.id;
    }

    public IRI getType() {
        return this.type;
    }

    public List<Literal> getMessage() {
        return this.message;
    }

    public IRI getSeverity() {
        return this.severity;
    }

    public List<Literal> getName() {
        return this.name;
    }

    public List<Literal> getDescription() {
        return this.description;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public Value getOrder() {
        return this.order;
    }

    public Value getGroup() {
        return this.group;
    }

    public List<Resource> getProperty() {
        return this.property;
    }

    public List<Resource> getNode() {
        return this.node;
    }

    public boolean isClosed() {
        return this.closed != null && this.closed != false;
    }

    public Resource getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public List<Resource> getXone() {
        return this.xone;
    }

    public List<Value> getHasValue() {
        return this.hasValue;
    }

    public List<IRI> getEquals() {
        return this.equals;
    }

    public List<IRI> getDisjoint() {
        return this.disjoint;
    }

    public List<IRI> getLessThan() {
        return this.lessThan;
    }

    public List<IRI> getLessThanOrEquals() {
        return this.lessThanOrEquals;
    }

    public List<Resource> getTarget() {
        return this.target;
    }

    public List<Resource> getTargetShape() {
        return this.targetShape;
    }

    public List<Resource> getHasValueIn() {
        return this.hasValueIn;
    }

    public Resource getQualifiedValueShape() {
        return this.qualifiedValueShape;
    }

    public Long getQualifiedMinCount() {
        return this.qualifiedMinCount;
    }

    public Long getQualifiedMaxCount() {
        return this.qualifiedMaxCount;
    }

    public boolean getQualifiedValueShapesDisjoint() {
        return this.qualifiedValueShapesDisjoint != null && this.qualifiedValueShapesDisjoint != false;
    }

    public List<Resource> getSparql() {
        return this.sparql;
    }
}

