/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.StampedLock;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.Pool;
import org.eclipse.rdf4j.sail.lmdb.TxnManager;
import org.eclipse.rdf4j.sail.lmdb.Varint;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBVal;

class LmdbContextIdIterator
implements Closeable {
    private final Pool pool;
    private final long cursor;
    private final TxnManager.Txn txnRef;
    private long txnRefVersion;
    private final long txn;
    private final int dbi;
    private volatile boolean closed = false;
    private final MDBVal keyData;
    private final MDBVal valueData;
    private ByteBuffer minKeyBuf;
    private int lastResult;
    private final long[] record = new long[1];
    private boolean fetchNext = false;
    private final StampedLock txnLock;
    private final Thread ownerThread = Thread.currentThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LmdbContextIdIterator(Pool pool, int dbi, TxnManager.Txn txnRef) throws IOException {
        this.pool = pool;
        this.keyData = pool.getVal();
        this.valueData = pool.getVal();
        this.dbi = dbi;
        this.txnRef = txnRef;
        this.txnLock = txnRef.lock();
        long stamp = this.txnLock.readLock();
        try {
            this.txnRefVersion = txnRef.version();
            this.txn = txnRef.get();
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer pp = stack.mallocPointer(1);
                LmdbUtil.E(LMDB.mdb_cursor_open((long)this.txn, (int)dbi, (PointerBuffer)pp));
                this.cursor = pp.get(0);
            }
        }
        finally {
            this.txnLock.unlockRead(stamp);
        }
    }

    public long[] next() {
        long stamp = this.txnLock.readLock();
        try {
            if (this.txnRefVersion != this.txnRef.version()) {
                LmdbUtil.E(LMDB.mdb_cursor_renew((long)this.txn, (long)this.cursor));
                if (this.fetchNext) {
                    if (this.minKeyBuf == null) {
                        this.minKeyBuf = this.pool.getKeyBuffer();
                    }
                    this.minKeyBuf.clear();
                    Varint.writeUnsigned(this.minKeyBuf, this.record[0]);
                    this.minKeyBuf.flip();
                    this.keyData.mv_data(this.minKeyBuf);
                    this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)15));
                    if (this.lastResult != 0) {
                        this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)17));
                    }
                    if (this.lastResult != 0) {
                        this.closeInternal(false);
                        long[] lArray = null;
                        return lArray;
                    }
                }
                this.txnRefVersion = this.txnRef.version();
            }
            if (this.fetchNext) {
                this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8));
                this.fetchNext = false;
            } else if (this.minKeyBuf != null) {
                this.keyData.mv_data(this.minKeyBuf);
                this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)17));
            } else {
                this.lastResult = LmdbUtil.E(LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8));
            }
            if (this.lastResult == 0) {
                this.record[0] = Varint.readUnsigned(this.keyData.mv_data());
                this.fetchNext = true;
                long[] lArray = this.record;
                return lArray;
            }
            this.closeInternal(false);
            long[] lArray = null;
            return lArray;
        }
        catch (IOException e) {
            throw new SailException(e);
        }
        finally {
            this.txnLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean maybeCalledAsync) {
        if (!this.closed) {
            long stamp = maybeCalledAsync && this.ownerThread != Thread.currentThread() ? this.txnLock.writeLock() : 0L;
            try {
                if (!this.closed) {
                    LMDB.mdb_cursor_close((long)this.cursor);
                    this.pool.free(this.keyData);
                    this.pool.free(this.valueData);
                    if (this.minKeyBuf != null) {
                        this.pool.free(this.minKeyBuf);
                    }
                }
            }
            finally {
                this.closed = true;
                if (stamp != 0L) {
                    this.txnLock.unlockWrite(stamp);
                }
            }
        }
    }

    @Override
    public void close() {
        this.closeInternal(true);
    }
}

